/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.context.internal;

import com.kms.katalon.core.annotation.AfterTestCase;
import com.kms.katalon.core.annotation.AfterTestSuite;
import com.kms.katalon.core.annotation.BeforeTestCase;
import com.kms.katalon.core.annotation.BeforeTestSuite;
import com.kms.katalon.core.context.internal.ExecutionListenerEvent;
import com.kms.katalon.core.context.internal.ExecutionListenerEventHandler;
import com.kms.katalon.core.context.internal.TestHooker;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TestListenerCollector
implements ExecutionListenerEventHandler {
    private static final Map<ExecutionListenerEvent, String> LISTENER_ANNOTATION_NAMES = new HashMap<ExecutionListenerEvent, String>();
    private String sourceFolder;
    private List<TestHooker> testHookers;

    static {
        LISTENER_ANNOTATION_NAMES.put(ExecutionListenerEvent.BEFORE_TEST_SUITE, BeforeTestSuite.class.getName());
        LISTENER_ANNOTATION_NAMES.put(ExecutionListenerEvent.AFTER_TEST_SUITE, AfterTestSuite.class.getName());
        LISTENER_ANNOTATION_NAMES.put(ExecutionListenerEvent.BEFORE_TEST_CASE, BeforeTestCase.class.getName());
        LISTENER_ANNOTATION_NAMES.put(ExecutionListenerEvent.AFTER_TEST_CASE, AfterTestCase.class.getName());
    }

    public TestListenerCollector(String sourceFolder) {
        this.sourceFolder = sourceFolder;
        this.collectTestContextInProject();
    }

    public void collectTestContextInProject() {
        this.testHookers = new ArrayList<TestHooker>();
        File testListenerFolder = new File(this.sourceFolder);
        if (!testListenerFolder.exists()) {
            return;
        }
        try {
            Files.walk(testListenerFolder.toPath(), new FileVisitOption[0]).filter(p -> p.toString().endsWith(".groovy")).map(p -> p.toAbsolutePath().toFile()).forEach(file -> {
                TestHooker testHooker = new TestHooker(file.getAbsolutePath());
                this.testHookers.add(testHooker);
            });
        }
        catch (IOException iOException) {}
    }

    @Override
    public void handleListenerEvent(ExecutionListenerEvent listenerEvent, Object[] injectedObjects) {
        this.testHookers.forEach(hooker -> {
            if (LISTENER_ANNOTATION_NAMES.containsKey((Object)listenerEvent)) {
                String listenerAnnotationName = LISTENER_ANNOTATION_NAMES.get((Object)listenerEvent);
                hooker.invokeContextMethods(listenerAnnotationName, injectedObjects);
            }
        });
    }
}

