/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.context.internal;

import com.kms.katalon.core.annotation.AfterTestCase;
import com.kms.katalon.core.annotation.AfterTestSuite;
import com.kms.katalon.core.annotation.BeforeTestCase;
import com.kms.katalon.core.annotation.BeforeTestSuite;
import com.kms.katalon.core.constants.CoreMessageConstants;
import com.kms.katalon.core.logging.ErrorCollector;
import com.kms.katalon.core.logging.KeywordLogger;
import com.kms.katalon.core.main.TestCaseMain;
import com.kms.katalon.core.util.internal.ExceptionsUtil;
import com.kms.katalon.core.util.internal.PrimitiesUtil;
import groovy.lang.GroovyObject;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Stack;
import org.apache.commons.io.FileUtils;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.builder.AstBuilder;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.MultipleCompilationErrorsException;

public class TestHooker {
    private final KeywordLogger logger = KeywordLogger.getInstance(this.getClass());
    private String sourceFile;
    private Map<String, List<MethodNode>> testContextMethods;
    private ClassNode moduleNode;
    private GroovyObject testContextClassInstance;
    private Class<?> scriptClazz;

    public TestHooker(String sourceFile) {
        this.sourceFile = sourceFile;
        this.collectContextMethods();
    }

    private void clearContextMethods() {
        this.testContextMethods = new HashMap<String, List<MethodNode>>();
        this.testContextMethods.put(BeforeTestCase.class.getName(), new ArrayList());
        this.testContextMethods.put(AfterTestCase.class.getName(), new ArrayList());
        this.testContextMethods.put(BeforeTestSuite.class.getName(), new ArrayList());
        this.testContextMethods.put(AfterTestSuite.class.getName(), new ArrayList());
    }

    public void collectContextMethods() {
        this.clearContextMethods();
        File file = new File(this.sourceFile);
        try {
            List astNodes = new AstBuilder().buildFromString(FileUtils.readFileToString((File)file));
            astNodes.stream().filter(node -> node instanceof ClassNode).forEach(mainNode -> {
                if (mainNode instanceof ClassNode) {
                    this.moduleNode = (ClassNode)mainNode;
                    this.moduleNode.getAllDeclaredMethods().stream().forEach(method -> this.evaluateTestContextMethod((MethodNode)method));
                }
            });
        }
        catch (MultipleCompilationErrorsException e) {
            System.out.println(ExceptionsUtil.getMessageForThrowable(e));
        }
        catch (IOException e) {
            System.err.println(ExceptionsUtil.getMessageForThrowable(e));
        }
    }

    private void evaluateTestContextMethod(MethodNode method) {
        method.getAnnotations().forEach(annotationNode -> this.testContextMethods.keySet().forEach(testContextAnnotation -> {
            List<MethodNode> annotationContextMethods = this.testContextMethods.get(testContextAnnotation);
            if (annotationContextMethods == null) {
                annotationContextMethods = new ArrayList<MethodNode>();
            }
            if (testContextAnnotation.contains(annotationNode.getClassNode().getName()) && !annotationContextMethods.contains(method)) {
                annotationContextMethods.add(method);
            }
            this.testContextMethods.put((String)testContextAnnotation, annotationContextMethods);
        }));
    }

    public void invokeContextMethods(String listenerAnnotationName, Object[] injectedObjects) {
        if (this.testContextClassInstance == null) {
            try {
                this.scriptClazz = TestCaseMain.getScriptEngine().getExecutingScriptClassLoader().parseClass(new File(this.sourceFile));
                this.testContextClassInstance = (GroovyObject)this.scriptClazz.newInstance();
            }
            catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException | CompilationFailedException e) {
                System.err.println(ExceptionsUtil.getMessageForThrowable(e));
            }
        }
        this.testContextMethods.get(listenerAnnotationName).forEach(method -> this.invokeMethod(listenerAnnotationName, (MethodNode)method, injectedObjects));
    }

    /*
     * Unable to fully structure code
     */
    private void invokeMethod(String listenerAnnotationName, MethodNode method, Object[] injectedObjects) {
        block7: {
            methodName = method.getName();
            errorCollector = ErrorCollector.getCollector();
            oldErrors = errorCollector.getCoppiedErrors();
            keywordStack = new Stack<KeywordLogger.KeywordStackElement>();
            try {
                try {
                    errorCollector.clearErrors();
                    methodDisplayName = String.valueOf(this.scriptClazz.getName()) + "." + methodName + "(...)";
                    this.logger.startListenerKeyword(methodName, null, keywordStack);
                    this.logger.logDebug(MessageFormat.format(CoreMessageConstants.EXEC_LOG_STARTING_INVOKE_LISTENER_METHOD, new Object[]{listenerAnnotationName, methodDisplayName}));
                    this.testContextClassInstance.invokeMethod(methodName, (Object)this.getValueForParemeters(method, injectedObjects));
                    this.logger.logDebug(MessageFormat.format(CoreMessageConstants.EXEC_LOG_INVOKE_LISTENER_METHOD_COMPLETED, new Object[]{listenerAnnotationName, methodDisplayName}));
                    if (true) ** GOTO lbl39
                }
                catch (Throwable e) {
                    this.logger.logError(ExceptionsUtil.getMessageForThrowable(e));
                    ** while (!keywordStack.isEmpty())
                }
            }
            catch (Throwable var9_13) {
                ** while (!keywordStack.isEmpty())
            }
lbl-1000:
            // 1 sources

            {
                keywordStackElement = keywordStack.pop();
                this.logger.endKeyword(keywordStackElement.getKeywordName(), null, keywordStackElement.getNestedLevel());
                continue;
            }
lbl21:
            // 1 sources

            this.logger.endListenerKeyword(methodName, null, keywordStack);
            errorCollector.clearErrors();
            errorCollector.getErrors().addAll(oldErrors);
            break block7;
lbl-1000:
            // 1 sources

            {
                keywordStackElement = (KeywordLogger.KeywordStackElement)keywordStack.pop();
                this.logger.endKeyword(keywordStackElement.getKeywordName(), null, keywordStackElement.getNestedLevel());
                continue;
            }
lbl31:
            // 1 sources

            this.logger.endListenerKeyword(methodName, null, keywordStack);
            errorCollector.clearErrors();
            errorCollector.getErrors().addAll(oldErrors);
            throw var9_13;
            do {
                keywordStackElement = keywordStack.pop();
                this.logger.endKeyword(keywordStackElement.getKeywordName(), null, keywordStackElement.getNestedLevel());
lbl39:
                // 2 sources

            } while (!keywordStack.isEmpty());
            this.logger.endListenerKeyword(methodName, null, keywordStack);
            errorCollector.clearErrors();
            errorCollector.getErrors().addAll(oldErrors);
        }
    }

    private Object[] getValueForParemeters(MethodNode method, Object[] injectedObjects) {
        if (injectedObjects == null) {
            return null;
        }
        return Arrays.stream(method.getParameters()).map(param -> this.findInjectedObject((Parameter)param, injectedObjects)).toArray();
    }

    private Object findInjectedObject(Parameter param, Object[] injectedObjects) {
        Optional<Object> suitableOpt = Arrays.stream(injectedObjects).filter(o -> this.isSameClass(o, param)).findFirst();
        if (suitableOpt.isPresent()) {
            return suitableOpt.get();
        }
        Class<?> clazz = this.getParamClass(param);
        return clazz != null ? PrimitiesUtil.defaultValue(clazz) : null;
    }

    private Class<?> getParamClass(Parameter param) {
        try {
            String paramClassName = ClassHelper.getWrapper((ClassNode)param.getType()).getName();
            return Class.forName(paramClassName);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    private boolean isSameClass(Object o, Parameter param) {
        if (o == null) {
            return false;
        }
        Class<?> clazz = this.getParamClass(param);
        if (clazz != null) {
            return !clazz.equals(Object.class) && clazz.isInstance(o);
        }
        return false;
    }
}

