/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.mobile.util;

import com.kms.katalon.execution.mobile.constants.ExecutionMobileMessageConstants;
import com.kms.katalon.execution.mobile.exception.MobileSetupException;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.Platform;

public class MobileExecutionUtil {
    private static final String MAC_DEFAULT_NODEJS_LOCATION = "/usr/local/bin/node";

    public static void detectInstalledAppiumAndNodeJs() throws MobileSetupException {
        String appiumDir = null;
        try {
            appiumDir = MobileExecutionUtil.findAppiumDir();
        }
        catch (IOException e) {
            LogUtil.logError((Throwable)e);
        }
        String nodeEnvPath = "";
        try {
            nodeEnvPath = MobileExecutionUtil.detectNodeInstallation();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (IOException e) {
            LogUtil.logError((Throwable)e);
        }
        String errorMessage = "";
        if (StringUtils.isEmpty((String)appiumDir) && StringUtils.isEmpty((String)nodeEnvPath)) {
            errorMessage = ExecutionMobileMessageConstants.MSG_NO_APPIUM_AND_NODEJS;
        }
        if (StringUtils.isEmpty((String)appiumDir)) {
            errorMessage = ExecutionMobileMessageConstants.MSG_NO_APPIUM;
        }
        if (StringUtils.isEmpty((String)nodeEnvPath)) {
            errorMessage = ExecutionMobileMessageConstants.MSG_NO_NODEJS;
        }
        if (!errorMessage.isEmpty()) {
            throw new MobileSetupException(errorMessage);
        }
    }

    private static String findAppiumDir() throws IOException {
        ScopedPreferenceStore mobilePreferenceStore = PreferenceStoreManager.getPreferenceStore((String)"com.kms.katalon.composer.mobile");
        String appiumDir = mobilePreferenceStore.getString("mobile.appiumDirectory");
        if (StringUtils.isNotEmpty((String)appiumDir)) {
            return appiumDir;
        }
        appiumDir = MobileExecutionUtil.findAppiumFromDefaultLocation();
        if (StringUtils.isNotEmpty((String)appiumDir) && new File(appiumDir).exists()) {
            mobilePreferenceStore.setValue("mobile.appiumDirectory", appiumDir);
            mobilePreferenceStore.save();
        }
        return appiumDir;
    }

    private static String findAppiumFromDefaultLocation() {
        switch (Platform.getOS()) {
            case "macosx": {
                return "/usr/local/lib/node_modules/appium";
            }
            case "linux": {
                return "/usr/lib/node_modules/appium/";
            }
            case "win32": {
                return String.valueOf(System.getProperty("user.home")) + "\\AppData\\Roaming\\npm\\node_modules\\appium";
            }
        }
        return null;
    }

    private static String detectNodeInstallation() throws IOException, InterruptedException {
        String cmd = "";
        if (StringUtils.equals((String)Platform.getOS(), (String)"win32")) {
            cmd = "where node";
        } else if (StringUtils.equals((String)Platform.getOS(), (String)"macosx") || StringUtils.equals((String)Platform.getOS(), (String)"linux")) {
            File nodeJS = new File(MAC_DEFAULT_NODEJS_LOCATION);
            if (nodeJS.exists() && nodeJS.isFile()) {
                return MAC_DEFAULT_NODEJS_LOCATION;
            }
            cmd = "which node";
        }
        Process proc = Runtime.getRuntime().exec(cmd);
        int exitVal = proc.waitFor();
        StringBuilder sb = new StringBuilder();
        if (exitVal == 0) {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            while ((line = reader.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
        }
        return sb.toString();
    }
}

