/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.mobile.device;

import com.kms.katalon.core.mobile.constants.StringConstants;
import com.kms.katalon.core.util.ConsoleCommandExecutor;
import com.kms.katalon.execution.mobile.device.MobileDeviceInfo;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.eclipse.core.runtime.Platform;

public class IosDeviceInfo
extends MobileDeviceInfo {
    private static final String RELATIVE_PATH_TO_TOOLS_FOLDER = "resources" + File.separator + "tools" + File.separator;
    private static final String PATH = "PATH";
    private static final String DYLD_LIBRARY_PATH = "DYLD_LIBRARY_PATH";
    private static final String PRODUCT_TYPE_INFO_PREFIX = "ProductType:";
    private static final String PRODUCT_VERSION_INFO_PREFIX = "ProductVersion:";
    private static final String DEVICE_NAME_INFO_PREFIX = "DeviceName:";
    private static final String DEVICE_CLASS_INFO_PREFIX = "DeviceClass:";
    private static final String IMOBILE_DEVICE_FOLDER_RELATIVE_PATH = String.valueOf(RELATIVE_PATH_TO_TOOLS_FOLDER) + "imobiledevice";
    private static final String IOS_DEPLOY_FOLDER_RELATIVE_PATH = String.valueOf(RELATIVE_PATH_TO_TOOLS_FOLDER) + "ios-deploy";
    private static final String CARTHAGE_FOLDER_RELATIVE_PATH = String.valueOf(RELATIVE_PATH_TO_TOOLS_FOLDER) + "carthage" + File.separator + "0.18.1" + File.separator + "etc" + File.separator + "bash_completion.d";
    public static final String DEVICECONSOLE = "deviceconsole";
    private static final String DEVICE_CONSOLE_FOLDER_RELATIVE_PATH = String.valueOf(RELATIVE_PATH_TO_TOOLS_FOLDER) + "deviceconsole";
    private static final String DYLD_FALLBACK_LIBRARY_PATH = "DYLD_FALLBACK_LIBRARY_PATH";
    protected String deviceClass = "";
    protected String deviceName = "";
    protected String deviceOSVersion = "";
    protected String deviceType = "";

    public IosDeviceInfo(String deviceId) throws IOException, InterruptedException {
        super(deviceId);
        this.initDeviceInfos(deviceId);
    }

    public static List<String> executeCommand(String command) throws IOException, InterruptedException {
        String iMobileDeviceDirectory = IosDeviceInfo.getIMobileDeviceDirectoryAsString();
        String deviceCommandFile = "../device.sh";
        IosDeviceInfo.makeFileExecutable(new File(iMobileDeviceDirectory, deviceCommandFile));
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("KATALON_DEVICE_COMMAND", command);
        return ConsoleCommandExecutor.runConsoleCommandAndCollectResults((String[])new String[]{deviceCommandFile}, env, (String)iMobileDeviceDirectory);
    }

    protected void initDeviceInfos(String deviceId) throws IOException, InterruptedException {
        IosDeviceInfo.executeCommand("./idevicepair pair -u " + deviceId);
        List<String> deviceInfos = IosDeviceInfo.executeCommand("./ideviceinfo -u " + deviceId);
        for (String deviceInfo : deviceInfos) {
            if (deviceInfo.contains(DEVICE_CLASS_INFO_PREFIX)) {
                this.deviceClass = deviceInfo.substring(DEVICE_CLASS_INFO_PREFIX.length(), deviceInfo.length()).trim();
                continue;
            }
            if (deviceInfo.contains(DEVICE_NAME_INFO_PREFIX)) {
                this.deviceName = deviceInfo.substring(DEVICE_NAME_INFO_PREFIX.length(), deviceInfo.length()).trim();
                continue;
            }
            if (deviceInfo.contains(PRODUCT_VERSION_INFO_PREFIX)) {
                this.deviceOSVersion = deviceInfo.substring(PRODUCT_VERSION_INFO_PREFIX.length(), deviceInfo.length()).trim();
                continue;
            }
            if (!deviceInfo.contains(PRODUCT_TYPE_INFO_PREFIX)) continue;
            this.deviceType = deviceInfo.substring(PRODUCT_TYPE_INFO_PREFIX.length(), deviceInfo.length()).trim();
        }
        IosDeviceInfo.executeCommand("./idevicepair unpair -u " + deviceId);
    }

    @Override
    public String getDeviceName() {
        return this.deviceName;
    }

    @Override
    public String getDisplayName() {
        return String.valueOf(this.deviceClass) + " " + this.deviceName + " " + this.deviceOSVersion;
    }

    @Override
    public String getDeviceManufacturer() {
        return StringConstants.KW_MANUFACTURER_APPLE;
    }

    @Override
    public String getDeviceModel() {
        return this.deviceType;
    }

    @Override
    public String getDeviceOS() {
        return StringConstants.KW_OS_IOS;
    }

    @Override
    public String getDeviceOSVersion() {
        return this.deviceOSVersion;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.deviceId).append((Object)this.deviceClass).append((Object)this.deviceName).append((Object)this.deviceOSVersion).append((Object)this.deviceType).toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IosDeviceInfo other = (IosDeviceInfo)obj;
        return new EqualsBuilder().append((Object)this.deviceId, (Object)other.deviceId).append((Object)this.deviceClass, (Object)other.deviceClass).append((Object)this.deviceName, (Object)other.deviceName).append((Object)this.deviceOSVersion, (Object)other.deviceOSVersion).append((Object)this.deviceType, (Object)other.deviceType).isEquals();
    }

    public static File getIMobileDeviceDirectory() throws IOException {
        return IosDeviceInfo.getResourceFolder(IMOBILE_DEVICE_FOLDER_RELATIVE_PATH);
    }

    private static File getIosDeployDirectory() throws IOException {
        return IosDeviceInfo.getResourceFolder(IOS_DEPLOY_FOLDER_RELATIVE_PATH);
    }

    private static File getCarthageDirectory() throws IOException {
        return IosDeviceInfo.getResourceFolder(CARTHAGE_FOLDER_RELATIVE_PATH);
    }

    public static File getDeviceConsoleExecutablePath() throws IOException {
        return new File(IosDeviceInfo.getResourceFolder(DEVICE_CONSOLE_FOLDER_RELATIVE_PATH), DEVICECONSOLE);
    }

    public static String getIMobileDeviceDirectoryAsString() throws IOException {
        return IosDeviceInfo.getIMobileDeviceDirectory().getAbsolutePath();
    }

    @Override
    protected Map<String, String> getEnvironmentVariables() throws IOException, InterruptedException {
        return IosDeviceInfo.getIosAdditionalEnvironmentVariables();
    }

    public static Map<String, String> getIosAdditionalEnvironmentVariables() throws IOException, InterruptedException {
        IosDeviceInfo.makeIosDeployExecutable();
        IosDeviceInfo.makeDeviceConsoleExecutable();
        IosDeviceInfo.makeAllIMobileDeviceBinaryExecutable();
        IosDeviceInfo.makeAllFilesInFolderExecutable(IosDeviceInfo.getCarthageDirectory());
        HashMap<String, String> additionalEnvironmentVariables = new HashMap<String, String>();
        String iMobileDeviceDirectory = IosDeviceInfo.getIMobileDeviceDirectoryAsString();
        if (StringUtils.isNotEmpty((CharSequence)iMobileDeviceDirectory)) {
            additionalEnvironmentVariables.put(DYLD_LIBRARY_PATH, String.valueOf(StringUtils.defaultString((String)System.getenv(DYLD_LIBRARY_PATH))) + ":" + iMobileDeviceDirectory);
            additionalEnvironmentVariables.put(DYLD_FALLBACK_LIBRARY_PATH, String.valueOf(StringUtils.defaultString((String)System.getenv(DYLD_FALLBACK_LIBRARY_PATH))) + ":" + iMobileDeviceDirectory);
            additionalEnvironmentVariables.put(PATH, String.valueOf(StringUtils.defaultString((String)System.getenv(PATH))) + ":" + iMobileDeviceDirectory + ":" + IosDeviceInfo.getIosDeployDirectory().getAbsolutePath() + ":" + IosDeviceInfo.getCarthageDirectory().getAbsolutePath());
        }
        return additionalEnvironmentVariables;
    }

    public static void makeAllIMobileDeviceBinaryExecutable() throws IOException, InterruptedException {
        if (!"macosx".equals(Platform.getOS())) {
            return;
        }
        IosDeviceInfo.makeAllFilesInFolderExecutable(IosDeviceInfo.getIMobileDeviceDirectory());
    }

    private static void makeAllFilesInFolderExecutable(File iMobileDeviceBinDirectory) throws IOException, InterruptedException {
        if (!iMobileDeviceBinDirectory.exists() || !iMobileDeviceBinDirectory.isDirectory()) {
            return;
        }
        File[] fileArray = iMobileDeviceBinDirectory.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isFile()) {
                IosDeviceInfo.makeFileExecutable(file);
            }
            ++n2;
        }
    }

    public static void makeIosDeployExecutable() throws IOException, InterruptedException {
        if (!"macosx".equals(Platform.getOS())) {
            return;
        }
        IosDeviceInfo.makeAllFilesInFolderExecutable(IosDeviceInfo.getIosDeployDirectory());
    }

    public static void makeDeviceConsoleExecutable() throws IOException, InterruptedException {
        if (!"macosx".equals(Platform.getOS())) {
            return;
        }
        File deviceConsoleBinary = IosDeviceInfo.getDeviceConsoleExecutablePath();
        if (!deviceConsoleBinary.isFile()) {
            return;
        }
        IosDeviceInfo.makeFileExecutable(deviceConsoleBinary);
    }

    @Override
    public boolean isEmulator() {
        return false;
    }
}

