/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.mobile.configuration.contributor;

import com.kms.katalon.core.mobile.driver.MobileDriverType;
import com.kms.katalon.core.setting.PropertySettingStoreUtil;
import com.kms.katalon.entity.testsuite.RunConfigurationDescription;
import com.kms.katalon.execution.configuration.IRunConfiguration;
import com.kms.katalon.execution.configuration.contributor.IRunConfigurationContributor;
import com.kms.katalon.execution.console.entity.ConsoleOption;
import com.kms.katalon.execution.console.entity.StringConsoleOption;
import com.kms.katalon.execution.exception.ExecutionException;
import com.kms.katalon.execution.mobile.configuration.MobileRunConfiguration;
import com.kms.katalon.execution.mobile.configuration.providers.MobileDeviceProvider;
import com.kms.katalon.execution.mobile.constants.StringConstants;
import com.kms.katalon.execution.mobile.device.AndroidSDKDownloadManager;
import com.kms.katalon.execution.mobile.device.AndroidSDKManager;
import com.kms.katalon.execution.mobile.device.MobileDeviceInfo;
import com.kms.katalon.execution.mobile.driver.AndroidDriverConnector;
import com.kms.katalon.execution.mobile.driver.IosDriverConnector;
import com.kms.katalon.execution.mobile.exception.MobileSetupException;
import com.kms.katalon.execution.mobile.util.MobileExecutionUtil;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public abstract class MobileRunConfigurationContributor
implements IRunConfigurationContributor {
    public static final String DEVICE_ID_CONFIGURATION_KEY = "deviceId";
    public static final String DEVICE_DISPLAY_NAME_CONFIGURATION_KEY = "deviceName";
    private String deviceName;
    public static final StringConsoleOption DEVICE_NAME_CONSOLE_OPTION = new StringConsoleOption(){

        public String getOption() {
            return MobileRunConfigurationContributor.DEVICE_ID_CONFIGURATION_KEY;
        }
    };

    public String getId() {
        return this.getMobileDriverType().toString();
    }

    public IRunConfiguration getRunConfiguration(String projectDir) throws IOException, ExecutionException, InterruptedException {
        String string = this.deviceName = StringUtils.isNotBlank((String)this.deviceName) ? this.deviceName : MobileRunConfigurationContributor.getDefaultDeviceId(projectDir, this.getMobileDriverType());
        if (StringUtils.isBlank((String)this.deviceName)) {
            throw new ExecutionException(StringConstants.MOBILE_ERR_NO_DEVICE_NAME_AVAILABLE);
        }
        MobileExecutionUtil.detectInstalledAppiumAndNodeJs();
        AndroidSDKManager sdkManager = new AndroidSDKManager();
        if (!sdkManager.checkSDKExists()) {
            AndroidSDKDownloadManager downloadManager = new AndroidSDKDownloadManager(sdkManager.getSDKLocator());
            downloadManager.downloadAndInstall();
        }
        MobileDeviceInfo device = null;
        try {
            device = MobileDeviceProvider.getDevice(this.getMobileDriverType(), this.deviceName);
        }
        catch (MobileSetupException e) {
            throw new ExecutionException(e.getMessage());
        }
        if (device == null) {
            throw new ExecutionException(MessageFormat.format(StringConstants.MOBILE_ERR_CANNOT_FIND_DEVICE_WITH_NAME_X, this.deviceName));
        }
        MobileRunConfiguration runConfiguration = this.getMobileRunConfiguration(projectDir);
        runConfiguration.setDevice(device);
        return runConfiguration;
    }

    public IRunConfiguration getRunConfiguration(String projectDir, RunConfigurationDescription runConfigurationDescription) throws IOException, ExecutionException, InterruptedException {
        this.deviceName = this.getDeviceId(runConfigurationDescription);
        return super.getRunConfiguration(projectDir, runConfigurationDescription);
    }

    private String getDeviceId(RunConfigurationDescription runConfigurationDescription) {
        if (runConfigurationDescription != null && runConfigurationDescription.getRunConfigurationData() != null) {
            return (String)runConfigurationDescription.getRunConfigurationData().get(DEVICE_ID_CONFIGURATION_KEY);
        }
        return "";
    }

    protected abstract MobileRunConfiguration getMobileRunConfiguration(String var1) throws IOException;

    public List<ConsoleOption<?>> getConsoleOptionList() {
        ArrayList consoleOptionList = new ArrayList();
        consoleOptionList.add((ConsoleOption<?>)DEVICE_NAME_CONSOLE_OPTION);
        return consoleOptionList;
    }

    public void setArgumentValue(ConsoleOption<?> consoleOption, String argumentValue) throws Exception {
        if (StringUtils.isBlank((String)argumentValue)) {
            return;
        }
        if (consoleOption == DEVICE_NAME_CONSOLE_OPTION) {
            this.deviceName = argumentValue.trim();
        }
    }

    protected abstract MobileDriverType getMobileDriverType();

    public static String getDefaultDeviceId(String projectDir, MobileDriverType platform) throws IOException {
        String deviceId = null;
        switch (platform) {
            case ANDROID_DRIVER: {
                deviceId = new AndroidDriverConnector(String.valueOf(projectDir) + File.separator + PropertySettingStoreUtil.INTERNAL_SETTING_ROOT_FOLDER_NAME).getDefaultDeviceId();
                break;
            }
            case IOS_DRIVER: {
                deviceId = new IosDriverConnector(String.valueOf(projectDir) + File.separator + PropertySettingStoreUtil.INTERNAL_SETTING_ROOT_FOLDER_NAME).getDefaultDeviceId();
            }
        }
        return deviceId;
    }

    public List<ConsoleOption<?>> getConsoleOptions(final RunConfigurationDescription description) {
        return Arrays.asList(new StringConsoleOption(){

            public String getOption() {
                return MobileRunConfigurationContributor.DEVICE_ID_CONFIGURATION_KEY;
            }

            public String getValue() {
                return MobileRunConfigurationContributor.this.getDeviceId(description);
            }
        });
    }
}

