/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.tracking.service;

import com.google.gson.JsonObject;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.model.RunningMode;
import com.kms.katalon.core.testobject.SelectorMethod;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.core.webui.driver.WebUIDriverType;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.project.ProjectType;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.tracking.model.ProjectStatistics;
import com.kms.katalon.tracking.model.TrackInfo;
import com.kms.katalon.tracking.osgi.service.IProjectStatisticsCollector;
import com.kms.katalon.tracking.osgi.service.ServiceConsumer;
import com.kms.katalon.tracking.service.TrackingService;
import com.kms.katalon.util.SystemInformationUtil;
import org.apache.commons.lang3.StringUtils;

public class Trackings {
    private static TrackingService trackingService = new TrackingService();
    private static SystemInformationUtil system = new SystemInformationUtil();

    public static void trackOpenApplication(boolean isAnonymous, String runningMode) throws Exception {
        double cpu = 0.0;
        long freePhysicalMemorySize = 0L;
        long totalPhysicalMemorySize = 0L;
        cpu = SystemInformationUtil.getProcessCpuLoad();
        long maxMemory = SystemInformationUtil.getMaxMemory();
        long usedMemory = SystemInformationUtil.getUsedMemory();
        long totalMemory = SystemInformationUtil.getTotalMemory();
        long freeMemory = SystemInformationUtil.getFreeMemory();
        double percentageUsed = SystemInformationUtil.getPercentageUsed();
        freePhysicalMemorySize = SystemInformationUtil.freePhysicalMemorySize();
        totalPhysicalMemorySize = SystemInformationUtil.totalPhysicalMemorySize();
        double percentageUsedFormatted = SystemInformationUtil.getPercentageUsedFormatted();
        Trackings.trackAction("openApplication", isAnonymous, "runningMode", runningMode, "percent_cpu", cpu, "max_memory", maxMemory, "used_memory", usedMemory, "total_memory", totalMemory, "free_memory", freeMemory, "percent_used", percentageUsed, "format_percent_used", percentageUsedFormatted, "freephysicalMemorySize", freePhysicalMemorySize, "totalphysicalMemorySize", totalPhysicalMemorySize);
    }

    public static void trackProjectStatistics(ProjectEntity project, boolean isAnonymous, String runningMode) {
        Trackings.trackUsageData(project, isAnonymous, runningMode, "collectStatistics");
    }

    public static void trackOpenProject(ProjectEntity project) {
        Trackings.trackUsageData(project, false, "gui", "openProject");
        Trackings.trackOpenObject("project");
    }

    private static void trackUsageData(ProjectEntity project, boolean isAnonymous, String runningMode, String triggeredBy) {
        if (project == null) {
            return;
        }
        try {
            JsonObject statisticsObject = Trackings.collectProjectStatistics(project);
            JsonObject properties = new JsonObject();
            properties.addProperty("triggeredBy", triggeredBy);
            properties.addProperty("runningMode", runningMode);
            JsonUtil.mergeJsonObject((JsonObject)statisticsObject, (JsonObject)properties);
            TrackInfo trackInfo = TrackInfo.create().eventName("Katalon Studio Track").anonymous(isAnonymous).properties(properties);
            trackingService.track(trackInfo);
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e);
        }
    }

    private static JsonObject collectProjectStatistics(ProjectEntity project) throws Exception {
        IProjectStatisticsCollector collector = ServiceConsumer.getProjectStatisticsCollector();
        ProjectStatistics statistics = collector.collect(project);
        JsonObject statisticsObject = JsonUtil.toJsonObject((Object)statistics);
        return statisticsObject;
    }

    public static void trackOpenFirstTime() {
        TrackInfo trackInfo = TrackInfo.create().eventName("Katalon Open First Time").anonymous(true);
        trackingService.track(trackInfo);
    }

    public static void trackSpy(String type) {
        Trackings.trackUserAction("spy", "type", type);
    }

    public static void trackWebRecord(WebUIDriverType browserType, boolean useActiveBrowser, SelectorMethod webLocatorConfig) {
        Trackings.trackUserAction("record", "type", "web", "browserType", browserType.toString(), "active", useActiveBrowser, "webLocatorConfig", webLocatorConfig.toString());
    }

    public static void trackRecord(String type) {
        Trackings.trackUserAction("record", "type", type);
    }

    public static void trackExecuteTestCase(String launchMode, String driverType) {
        Trackings.trackUserAction("executeTestCase", "launchMode", launchMode, "driver", driverType);
    }

    public static void trackExecuteTestSuiteInGuiMode(String launchMode, String driverType) {
        Trackings.trackUserAction("executeTestSuite", "runningMode", "gui", "launchMode", launchMode, "driver", driverType);
    }

    public static void trackExecuteTestSuiteInConsoleMode(boolean isAnonymous, String driverType) {
        Trackings.trackAction("executeTestSuite", isAnonymous, "runningMode", "console", "driver", driverType);
    }

    public static void trackExecuteTestSuiteCollectionInGuiMode() {
        Trackings.trackUserAction("executeTestSuiteCollection", "runningMode", "gui");
    }

    public static void trackExecuteTestSuiteCollectionInConsoleMode(boolean isAnonymous) {
        Trackings.trackAction("executeTestSuiteCollection", isAnonymous, "runningMode", "console");
    }

    public static void trackGenerateCmd() {
        Trackings.trackUserAction("generateCmd", new Object[0]);
    }

    public static void trackQuickOverview(String userClick) {
        Trackings.trackUserAction("quickOverview", "userClick", userClick);
    }

    public static void trackCreatingObject(String objectType) {
        String action = "new" + StringUtils.capitalize((String)objectType);
        Trackings.trackUserAction(action, new Object[0]);
    }

    public static void trackCreatingProject(String newProjectId, ProjectType newProjectType) {
        Trackings.trackUserAction("newProject", "newProjectId", newProjectId, "newProjectType", newProjectType.toString());
    }

    public static void trackCreatingSampleProject(String sampleProjectType, String newProjectId, ProjectType newProjectType) {
        Trackings.trackUserAction("newProject", "sampleProjectType", sampleProjectType, "newProjectId", newProjectId, "newProjectType", newProjectType.toString());
    }

    public static void trackCreatingSampleProject(String sampleProjectType) {
        Trackings.trackUserAction("newProject", "sampleProjectType", sampleProjectType);
    }

    public static void trackOpenDraftRequest(String webServiceType, String openBy) {
        Trackings.trackUserAction("openDraftRequest", "requestType", webServiceType, "openBy", openBy);
    }

    public static void trackOpenObject(String objectType) {
        String action = "open" + StringUtils.capitalize((String)objectType);
        Trackings.trackUserAction(action, new Object[0]);
    }

    public static void trackOpenHelp(String url) {
        Trackings.trackUserAction("openHelp", "url", url);
    }

    public static void trackOpenSpy(String type) {
        Trackings.trackUserAction("openSpy", "type", type);
    }

    public static void trackSaveSpy(String type, int numberOfSavedObjects) {
        Trackings.trackUserAction("saveSpy", "type", type, "numberOfSavedObjects", numberOfSavedObjects);
    }

    public static void trackCloseSpy(String type) {
        Trackings.trackUserAction("closeSpy", "type", type);
    }

    public static void trackOpenWebRecord(Boolean continueRecording, SelectorMethod webLocatorConfig) {
        if (continueRecording != null) {
            Trackings.trackUserAction("openRecord", "type", "web", "continue", continueRecording != false ? "yes" : "no", "webLocatorConfig", webLocatorConfig.toString());
        } else {
            Trackings.trackUserAction("openRecord", "type", "web", "webLocatorConfig", webLocatorConfig.toString());
        }
    }

    public static void trackOpenMobileRecord() {
        Trackings.trackUserAction("openRecord", "type", "mobile");
    }

    public static void trackCloseWebRecord(String closeButton, int numberOfTestSteps, SelectorMethod webLocatorConfig) {
        if ("ok".equals(closeButton)) {
            Trackings.trackUserAction("closeRecord", "type", "web", "closePopup", closeButton, "numberOfTestSteps", String.valueOf(numberOfTestSteps), "webLocatorConfig", webLocatorConfig.toString());
        } else {
            Trackings.trackUserAction("closeRecord", "type", "web", "closePopup", closeButton, "webLocatorConfig", webLocatorConfig.toString());
        }
    }

    public static void trackCloseRecord(String type, String closeButton, int numberOfTestSteps) {
        if ("ok".equals(closeButton)) {
            Trackings.trackUserAction("closeRecord", "type", type, "closePopup", closeButton, "numberOfTestSteps", String.valueOf(numberOfTestSteps));
        } else {
            Trackings.trackUserAction("closeRecord", "type", type, "closePopup", closeButton);
        }
    }

    public static void trackRecordRunSteps(String type) {
        Trackings.trackUserAction("recordRunSteps", "type", type);
    }

    public static void trackImportKeywords(String type) {
        Trackings.trackUserAction("importKeywords", "type", type);
    }

    public static void trackExportKeywords() {
        Trackings.trackUserAction("exportKeywords", new Object[0]);
    }

    public static void trackForumSearch(String keyword) {
        Trackings.trackUserAction("forumSearch", "keyword", keyword);
    }

    public static void trackQuickDiscussion() {
        Trackings.trackUserAction("quickDiscussion", new Object[0]);
    }

    public static void trackOpenKAIntegration(String objectType) {
        Trackings.trackUserAction("openKAIntegration", "type", objectType);
    }

    public static void trackAddNewTestStep(String stepType) {
        Trackings.trackUserAction("newTestStep", "type", stepType);
    }

    public static void trackTestWebServiceObject(boolean withVerification, boolean isDraftRequest) {
        Trackings.trackUserAction("testWebServiceObject", "verify", withVerification, "isDraft", isDraftRequest);
    }

    public static void trackAddApiVariable() {
        Trackings.trackUserAction("addApiVariable", new Object[0]);
    }

    public static void trackOpenImportingSwagger() {
        Trackings.trackUserAction("openImportingSwagger", new Object[0]);
    }

    public static void trackOpenImportingWsdl() {
        Trackings.trackUserAction("openImportingWSDL", new Object[0]);
    }

    public static void trackImportSwagger(String importType) {
        Trackings.trackUserAction("importSwagger", "type", importType);
    }

    public static void trackImportWSDL(String importType) {
        Trackings.trackUserAction("importWSDL", "type", importType);
    }

    public static void trackClickSavingDraftRequest() {
        Trackings.trackUserAction("clickSavingDraftRequest", new Object[0]);
    }

    public static void trackSaveDraftRequest() {
        Trackings.trackUserAction("saveDraftRequest", new Object[0]);
    }

    public static void trackClickDeletingDraftRequest() {
        Trackings.trackUserAction("clickDeletingDraftRequest", new Object[0]);
    }

    public static void trackDeleteDraftRequest(int numberOfDeletedRequests) {
        Trackings.trackUserAction("deleteDraftRequest", "deletedRequestCount", numberOfDeletedRequests);
    }

    public static void trackClickAddingRequestToTestCase(boolean addToNewTestCase) {
        Trackings.trackUserAction("clickAddingRequestToTestCase", "addType", addToNewTestCase ? "new" : "existing");
    }

    public static void trackAddRequestToTestCase(boolean addToNewTestCase) {
        Trackings.trackUserAction("addRequestToTestCase", "addType", addToNewTestCase ? "new" : "existing");
    }

    public static void trackOpenTwitterDialog() {
        Trackings.trackUserAction("openTwitterDialog", new Object[0]);
    }

    public static void trackUserResponseForTwitterDialog(String option) {
        Trackings.trackUserAction("responseTwitterDialog", "type", option);
    }

    public static void trackOpenLinkedJiraIssuesDialog() {
        Trackings.trackUserAction("openLinkedJiraIssuesDialog", new Object[0]);
    }

    public static void trackClickCreateNewJiraIssue() {
        Trackings.trackUserAction("clickCreateNewJiraIssue", new Object[0]);
    }

    public static void trackClickCreateJiraSubIssue() {
        Trackings.trackUserAction("clickCreateSubJiraIssue", new Object[0]);
    }

    public static void trackClickLinkToExistingJiraIssue() {
        Trackings.trackUserAction("clickLinkToExistingJiraIssue", new Object[0]);
    }

    public static void trackClickHarLink() {
        Trackings.trackUserAction("clickHarLink", new Object[0]);
    }

    public static void trackInAppSurveyRatingAndIdea(int numberOfStars, String userIdea) {
        Trackings.trackUserAction("katalonStudioSurvey", "star", numberOfStars, "content", userIdea);
    }

    public static void trackClickWalkthroughDialogLink(String dialogId, String linkName, String link) {
        Trackings.trackUserAction("clickWalkthroughLink", "dialogId", dialogId, "linkName", linkName, "link", link);
    }

    public static void trackClickWalkthroughIgnoreButton(String dialogId) {
        Trackings.trackUserAction("clickWalkthroughIgnoreButton", "dialogId", dialogId);
    }

    public static void trackDownloadPlugin(String apiKey, long pluginId, String pluginName, String pluginVersion, RunningMode runningMode) {
        apiKey = StringUtils.isNotBlank((CharSequence)apiKey) ? apiKey : "";
        Trackings.trackUserAction("downloadPlugin", "apiKey", apiKey, "pluginId", pluginId, "pluginName", pluginName, "pluginVersion", pluginVersion, "runningMode", runningMode.toString());
    }

    private static void trackUserAction(String actionName, Object ... properties) {
        Trackings.trackAction(actionName, false, properties);
    }

    private static void trackAction(String actionName, boolean isAnonymous, Object ... properties) {
        JsonObject propertiesObject = new JsonObject();
        propertiesObject.addProperty("action", actionName);
        ProjectEntity currentProject = ProjectController.getInstance().getCurrentProject();
        if (currentProject != null) {
            propertiesObject.addProperty("projectId", currentProject.getUUID());
            propertiesObject.addProperty("projectType", currentProject.getType().toString());
        }
        if (properties != null) {
            JsonUtil.mergeJsonObject((JsonObject)Trackings.createJsonObject(properties), (JsonObject)propertiesObject);
        }
        TrackInfo trackInfo = TrackInfo.create().eventName("Katalon Studio Used").anonymous(isAnonymous).properties(propertiesObject);
        trackingService.track(trackInfo);
    }

    private static JsonObject createJsonObject(Object ... properties) {
        JsonObject jsonObject = new JsonObject();
        if (properties != null) {
            int i = 0;
            while (i < properties.length - 1) {
                String key = (String)properties[i];
                Object value = properties[i + 1];
                if (value instanceof Character) {
                    jsonObject.addProperty(key, (Character)value);
                } else if (value instanceof String) {
                    jsonObject.addProperty(key, (String)value);
                } else if (value instanceof Number) {
                    jsonObject.addProperty(key, (Number)value);
                } else if (value instanceof Boolean) {
                    jsonObject.addProperty(key, (Boolean)value);
                }
                i += 2;
            }
        }
        return jsonObject;
    }
}

