/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.core.search;

import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTClassNode;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTMethodNode;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.groovy.search.EqualityVisitor;
import org.eclipse.jdt.groovy.search.ITypeRequestor;
import org.eclipse.jdt.groovy.search.TypeLookupResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindAllReferencesRequestor
implements ITypeRequestor {
    private final AnnotatedNode declaration;
    private final Map<ASTNode, Integer> references;
    public static final int F_WRITE_OCCURRENCE = 1;
    public static final int F_READ_OCCURRENCE = 2;

    public FindAllReferencesRequestor(AnnotatedNode declaration) {
        this.declaration = declaration;
        this.references = new TreeMap<ASTNode, Integer>(new Comparator<ASTNode>(){

            @Override
            public int compare(ASTNode o1, ASTNode o2) {
                return o1.getStart() - o2.getStart();
            }
        });
    }

    public ITypeRequestor.VisitStatus acceptASTNode(ASTNode node, TypeLookupResult result, IJavaElement enclosingElement) {
        if (node.getLength() == 0) {
            return ITypeRequestor.VisitStatus.CONTINUE;
        }
        if (node instanceof AnnotatedNode) {
            ASTNode maybeDeclaration = result.declaration;
            if (maybeDeclaration == null) {
                return ITypeRequestor.VisitStatus.CONTINUE;
            }
            if (maybeDeclaration instanceof ClassNode) {
                ClassNode script;
                if (!(node instanceof ClassExpression || node instanceof ClassNode || node instanceof ImportNode)) {
                    return ITypeRequestor.VisitStatus.CONTINUE;
                }
                if (node instanceof ClassNode && (script = (ClassNode)node).isScript() && script.getNameWithoutPackage().length() != script.getLength()) {
                    return ITypeRequestor.VisitStatus.CONTINUE;
                }
                maybeDeclaration = ((ClassNode)maybeDeclaration).redirect();
            }
            if (maybeDeclaration instanceof PropertyNode && ((PropertyNode)maybeDeclaration).getField() != null) {
                maybeDeclaration = ((PropertyNode)maybeDeclaration).getField();
            }
            if (node instanceof ImportNode && ((ImportNode)node).getType() != null) {
                ImportNode imp = (ImportNode)node;
                node = imp.getType();
                if (imp.isStatic()) {
                    boolean isStaticDecl;
                    boolean bl = isStaticDecl = this.declaration instanceof FieldNode && ((FieldNode)this.declaration).isStatic() || this.declaration instanceof FieldNode && ((FieldNode)this.declaration).isStatic();
                    if (isStaticDecl) {
                        String declarationName = this.getDeclarationName();
                        ClassNode declaringClass = this.declaration.getDeclaringClass();
                        if (declarationName.equals(imp.getFieldName())) {
                            declaringClass.equals((Object)imp.getType());
                        }
                        return ITypeRequestor.VisitStatus.CONTINUE;
                    }
                }
            }
            if (this.isEquivalent(maybeDeclaration)) {
                int flag = EqualityVisitor.checkForAssignment((ASTNode)node, (BinaryExpression)result.enclosingAssignment) ? 1 : 2;
                this.references.put(node, flag);
            }
        }
        return ITypeRequestor.VisitStatus.CONTINUE;
    }

    private String getDeclarationName() {
        if (this.declaration instanceof FieldNode) {
            return ((FieldNode)this.declaration).getName();
        }
        if (this.declaration instanceof MethodNode) {
            return ((MethodNode)this.declaration).getName();
        }
        if (this.declaration instanceof ClassNode) {
            return ((ClassNode)this.declaration).getName();
        }
        return this.declaration.getText();
    }

    private boolean isEquivalent(ASTNode maybeDeclaration) {
        if (maybeDeclaration == this.declaration) {
            return true;
        }
        if (maybeDeclaration instanceof FieldNode && this.declaration instanceof FieldNode) {
            FieldNode maybeField = (FieldNode)maybeDeclaration;
            FieldNode field = (FieldNode)this.declaration;
            return maybeField.getName().equals(field.getName()) && maybeField.getDeclaringClass().equals((Object)field.getDeclaringClass());
        }
        if (this.declaration instanceof MethodNode) {
            if (maybeDeclaration instanceof JDTMethodNode) {
                MethodNode maybeMethod = (MethodNode)maybeDeclaration;
                MethodNode method = (MethodNode)this.declaration;
                return maybeMethod.getName().equals(method.getName()) && maybeMethod.getDeclaringClass().equals((Object)method.getDeclaringClass());
            }
            if (maybeDeclaration instanceof MethodNode) {
                MethodNode maybeMethod = (MethodNode)maybeDeclaration;
                MethodNode method = (MethodNode)this.declaration;
                return this.checkParamLength(maybeMethod, method) && maybeMethod.getName().equals(method.getName()) && maybeMethod.getDeclaringClass().equals((Object)method.getDeclaringClass()) && this.checkParams(maybeMethod, method);
            }
        }
        if (maybeDeclaration instanceof InnerClassNode && this.declaration instanceof JDTClassNode || this.declaration instanceof InnerClassNode && maybeDeclaration instanceof JDTClassNode) {
            return ((ClassNode)maybeDeclaration).getName().equals(((ClassNode)this.declaration).getName());
        }
        return false;
    }

    private boolean checkParams(MethodNode maybeMethod, MethodNode method) {
        Parameter[] maybeParameters = maybeMethod.getParameters();
        Parameter[] parameters = method.getParameters();
        int i = 0;
        while (i < parameters.length) {
            if (!maybeParameters[i].getName().equals(parameters[i].getName()) || !this.typeEquals(maybeParameters[i], parameters[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean typeEquals(Parameter maybeParameter, Parameter parameter) {
        ClassNode maybeType = maybeParameter.getType();
        ClassNode type = parameter.getType();
        if (maybeType == null) {
            return type == null;
        }
        if (type == null) {
            return false;
        }
        return maybeType.getName().equals(type.getName());
    }

    private boolean checkParamLength(MethodNode maybeMethod, MethodNode method) {
        Parameter[] maybeParameters = maybeMethod.getParameters();
        Parameter[] parameters = method.getParameters();
        if (maybeParameters == null) {
            return parameters == null;
        }
        if (parameters == null) {
            return false;
        }
        return maybeParameters.length == parameters.length;
    }

    public Map<ASTNode, Integer> getReferences() {
        return this.references;
    }
}

