/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.core.launchers;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.groovy.eclipse.core.util.ListUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.launching.JavaLaunchDelegate;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyShellLaunchDelegate
extends JavaLaunchDelegate {
    public static final String JLINE_JAR = "jline-*.jar";

    public String[] getClasspath(ILaunchConfiguration configuration) throws CoreException {
        String[] classpath = super.getClasspath(configuration);
        List<String> newClasspath = ListUtil.array(classpath);
        try {
            newClasspath.add(GroovyShellLaunchDelegate.getPathTo(JLINE_JAR));
        }
        catch (IOException e) {
            GroovyCore.logException("Could not fine path to jline jars", e);
        }
        return newClasspath.toArray(new String[0]);
    }

    private static String getPathTo(String jarName) throws CoreException, IOException {
        Bundle groovyBundle = Platform.getBundle((String)"org.codehaus.groovy");
        Enumeration enu = groovyBundle.findEntries("lib", jarName, false);
        if (enu != null && enu.hasMoreElements()) {
            URL jar = FileLocator.resolve((URL)((URL)enu.nextElement()));
            return jar.getFile();
        }
        throw new CoreException((IStatus)new Status(4, "org.codehaus.groovy.eclipse.core", "Could not find " + jarName + " on the class path.  Please add it manually"));
    }

    public static List<String> getExtraClasspathElements() throws CoreException, IOException {
        return Collections.singletonList(GroovyShellLaunchDelegate.getPathTo(JLINE_JAR));
    }
}

