/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.core.inference;

import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.DynamicVariable;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.eclipse.core.compiler.CompilerUtils;
import org.codehaus.groovy.transform.stc.StaticTypesMarker;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.jdt.groovy.search.ITypeLookup;
import org.eclipse.jdt.groovy.search.TypeLookupResult;
import org.eclipse.jdt.groovy.search.VariableScope;

public class STCTypeLookup
implements ITypeLookup {
    private static final boolean isEnabled = CompilerUtils.getActiveGroovyBundle().getVersion().getMajor() >= 2 && CompilerUtils.getActiveGroovyBundle().getVersion().getMinor() > -1;

    public void initialize(GroovyCompilationUnit unit, VariableScope topLevelScope) {
    }

    public TypeLookupResult lookupType(Expression node, VariableScope scope, ClassNode objectExpressionType) {
        if (!isEnabled) {
            return null;
        }
        Object inferredType = node.getNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE);
        if (inferredType instanceof ClassNode) {
            TypeLookupResult.TypeConfidence confidence = TypeLookupResult.TypeConfidence.INFERRED;
            Expression decl = node;
            if (node instanceof VariableExpression) {
                Variable accessedVariable = ((VariableExpression)node).getAccessedVariable();
                if (accessedVariable instanceof ASTNode) {
                    decl = (ASTNode)accessedVariable;
                } else if (accessedVariable instanceof DynamicVariable) {
                    confidence = TypeLookupResult.TypeConfidence.LOOSELY_INFERRED;
                }
            } else if (node instanceof FieldExpression) {
                decl = ((FieldExpression)node).getField();
            } else if (node instanceof ClassExpression) {
                decl = node.getType();
            }
            return new TypeLookupResult((ClassNode)inferredType, objectExpressionType, (ASTNode)decl, confidence, scope);
        }
        return null;
    }

    public TypeLookupResult lookupType(FieldNode node, VariableScope scope) {
        if (!isEnabled) {
            return null;
        }
        Object inferredType = node.getNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE);
        if (inferredType instanceof ClassNode) {
            return new TypeLookupResult((ClassNode)inferredType, node.getDeclaringClass(), (ASTNode)node, TypeLookupResult.TypeConfidence.INFERRED, scope);
        }
        return null;
    }

    public TypeLookupResult lookupType(MethodNode node, VariableScope scope) {
        if (!isEnabled) {
            return null;
        }
        Object inferredType = node.getNodeMetaData((Object)StaticTypesMarker.INFERRED_RETURN_TYPE);
        if (inferredType instanceof ClassNode) {
            return new TypeLookupResult((ClassNode)inferredType, node.getDeclaringClass(), (ASTNode)node, TypeLookupResult.TypeConfidence.INFERRED, scope);
        }
        return null;
    }

    public TypeLookupResult lookupType(AnnotationNode node, VariableScope scope) {
        return null;
    }

    public TypeLookupResult lookupType(ImportNode node, VariableScope scope) {
        return null;
    }

    public TypeLookupResult lookupType(ClassNode node, VariableScope scope) {
        return null;
    }

    public TypeLookupResult lookupType(Parameter node, VariableScope scope) {
        return null;
    }
}

