/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.core.compiler;

import groovy.lang.GroovySystem;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.SortedSet;
import java.util.TreeSet;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.groovy.frameworkadapter.util.CompilerChooser;
import org.codehaus.groovy.frameworkadapter.util.SpecifiedVersion;
import org.codehaus.jdt.groovy.model.GroovyNature;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.groovy.core.Activator;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompilerUtils {
    private static boolean includeServlet = true;

    static {
        try {
            String p = System.getProperty("greclipse.includeServletInClasspathContainer", "true");
            if (p.equalsIgnoreCase("false")) {
                includeServlet = false;
            }
        }
        catch (Exception exception) {}
    }

    public static String getGroovyVersion() {
        return GroovySystem.getVersion();
    }

    public static boolean isGroovyVersionDisabledOrMissing(SpecifiedVersion version) {
        return CompilerUtils.getActiveGroovyVersion() == version;
    }

    public static SpecifiedVersion getActiveGroovyVersion() {
        return CompilerChooser.getInstance().getActiveSpecifiedVersion();
    }

    public static Version getBundleVersion(SpecifiedVersion version) {
        return CompilerChooser.getInstance().getAssociatedVersion(version);
    }

    public static Bundle getActiveGroovyBundle() {
        return CompilerChooser.getInstance().getActiveBundle();
    }

    public static IStatus switchVersions(SpecifiedVersion fromVersion, SpecifiedVersion toVersion) {
        try {
            CompilerChooser.getInstance().storeVersion(toVersion);
            return Status.OK_STATUS;
        }
        catch (Exception e) {
            GroovyCore.logException(e.getMessage(), e);
            return new Status(4, "org.codehaus.groovy.eclipse.core", String.valueOf(e.getMessage()) + "\n\nSee the error log for more information.", (Throwable)e);
        }
    }

    public static SortedSet<SpecifiedVersion> getAllGroovyVersions() {
        SpecifiedVersion[] versions = CompilerChooser.getInstance().getAllSpecifiedVersions();
        TreeSet<SpecifiedVersion> allVersions = new TreeSet<SpecifiedVersion>();
        SpecifiedVersion[] specifiedVersionArray = versions;
        int n = versions.length;
        int n2 = 0;
        while (n2 < n) {
            SpecifiedVersion version = specifiedVersionArray[n2];
            allVersions.add(version);
            ++n2;
        }
        return allVersions;
    }

    private static String getDotGroovyLibLocation() {
        String home = CompilerUtils.getDotGroovyLocation();
        if (home != null) {
            home = String.valueOf(home) + "/lib";
        }
        return home;
    }

    public static SpecifiedVersion getCompilerLevel(IProject project) {
        String groovyCompilerLevelStr;
        SpecifiedVersion version = SpecifiedVersion.UNSPECIFIED;
        if (GroovyNature.hasGroovyNature((IProject)project) && (groovyCompilerLevelStr = Activator.getDefault().getGroovyCompilerLevel(project)) != null) {
            version = SpecifiedVersion.findVersionFromString((String)groovyCompilerLevelStr);
        }
        return version;
    }

    public static void setCompilerLevel(IProject project, SpecifiedVersion projectLevel) {
        CompilerUtils.setCompilerLevel(project, projectLevel, false);
    }

    public static void setCompilerLevel(IProject project, SpecifiedVersion projectLevel, boolean assertCompatible) {
        Activator.getDefault().setGroovyCompilerLevel(project, projectLevel.versionName);
        if (assertCompatible) {
            if (CompilerUtils.projectVersionMatchesWorkspaceVersion(projectLevel)) {
                CompilerUtils.removeCompilermMismatchProblem(project);
            } else {
                CompilerUtils.addCompilerMismatchError(project, projectLevel);
            }
        }
    }

    public static void addCompilerMismatchError(IProject project, SpecifiedVersion projectLevel) {
        try {
            SpecifiedVersion workspaceLevel = CompilerUtils.getWorkspaceCompilerLevel();
            IMarker marker = project.getProject().createMarker("org.codehaus.groovy.eclipse.core.compilerMismatch");
            marker.setAttribute("message", (Object)("Groovy: compiler mismatch Project level is: " + projectLevel.toReadableVersionString() + " Workspace level is " + workspaceLevel.toReadableVersionString() + "\nGroovy compiler level expected by the project does not match workspace compiler level. " + "\nGo to Project properties -> Groovy compiler to set the Groovy compiler level for this project"));
            marker.setAttribute("severity", 2);
            marker.setAttribute("location", (Object)project.getName());
        }
        catch (CoreException e) {
            GroovyCore.logException("Error checking Groovy project compiler level compatibility for " + project.getName(), e);
        }
    }

    public static void removeCompilermMismatchProblem(IProject project) {
        try {
            IMarker[] findMarkers;
            IMarker[] iMarkerArray = findMarkers = project.findMarkers("org.codehaus.groovy.eclipse.core.compilerMismatch", true, 0);
            int n = findMarkers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                marker.delete();
                ++n2;
            }
        }
        catch (CoreException e) {
            GroovyCore.logException("Error checking Groovy project compiler level compatibility for " + project.getName(), e);
        }
    }

    public static void addMultipleCompilersOnClasspathError(IProject project, SpecifiedVersion compiler1, SpecifiedVersion compiler2) {
        try {
            IMarker marker = project.getProject().createMarker("org.codehaus.groovy.eclipse.core.compilerMismatch");
            marker.setAttribute("message", (Object)("Multiple Groovy compilers found on classpath. Continuing with compilation will produce unpredictible results. Remove a compiler before continuing.\nFound " + compiler1.toReadableVersionString() + " and " + compiler2.toReadableVersionString()));
            marker.setAttribute("severity", 2);
            marker.setAttribute("location", (Object)project.getName());
        }
        catch (CoreException e) {
            GroovyCore.logException("Error checking Groovy project compiler level compatibility for " + project.getName(), e);
        }
    }

    public static boolean projectVersionMatchesWorkspaceVersion(SpecifiedVersion version) {
        if (version == SpecifiedVersion.UNSPECIFIED || version == SpecifiedVersion.DONT_CARE) {
            return true;
        }
        SpecifiedVersion workspaceCompilerLevel = CompilerUtils.getWorkspaceCompilerLevel();
        return version == workspaceCompilerLevel;
    }

    public static URL getExportedGroovyAllJar() {
        try {
            Bundle groovyBundle = CompilerUtils.getActiveGroovyBundle();
            if (groovyBundle == null) {
                throw new RuntimeException("Could not find groovy bundle");
            }
            Enumeration enu = groovyBundle.findEntries("lib", "groovy-all-*.jar", false);
            if (enu == null) {
                enu = groovyBundle.findEntries("", "groovy-all-*.jar", false);
            }
            while (enu.hasMoreElements()) {
                URL jar = (URL)enu.nextElement();
                if (jar.getFile().indexOf("-sources") != -1 || jar.getFile().indexOf("-javadoc") != -1 || jar.getFile().indexOf("-eclipse") != -1) continue;
                jar = FileLocator.resolve((URL)jar);
                return jar;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        throw new RuntimeException("Could not find groovy all jar");
    }

    public static URL[] getExtraJarsForClasspath() {
        try {
            Bundle groovyBundle = CompilerUtils.getActiveGroovyBundle();
            Enumeration enu = groovyBundle.findEntries("lib", "*.jar", false);
            if (enu == null) {
                enu = groovyBundle.findEntries("", "*.jar", false);
            }
            ArrayList<URL> urls = new ArrayList<URL>(5);
            while (enu.hasMoreElements()) {
                URL jar = (URL)enu.nextElement();
                if (jar.getFile().contains("groovy") || jar.getFile().contains("servlet") && !includeServlet || jar.getFile().endsWith("-sources.jar") || jar.getFile().endsWith("-javadoc.jar")) continue;
                jar = FileLocator.resolve((URL)jar);
                urls.add(jar);
            }
            return urls.toArray(new URL[urls.size()]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static URL getJarInGroovyLib(String jarName) throws IOException {
        Bundle groovyBundle = CompilerUtils.getActiveGroovyBundle();
        Enumeration enu = groovyBundle.findEntries("lib", jarName, false);
        if (enu == null) {
            enu = groovyBundle.findEntries("", jarName, false);
        }
        if (enu != null && enu.hasMoreElements()) {
            URL jar = (URL)enu.nextElement();
            if ((jar = FileLocator.resolve((URL)jar)).getFile().indexOf("sources") > 0 && enu.hasMoreElements()) {
                jar = (URL)enu.nextElement();
                jar = FileLocator.resolve((URL)jar);
            }
            return jar;
        }
        return null;
    }

    public static URL findDSLDFolder() {
        Bundle groovyBundle = CompilerUtils.getActiveGroovyBundle();
        Enumeration enu = groovyBundle.findEntries(".", "plugin_dsld_support", false);
        if (enu != null && enu.hasMoreElements()) {
            URL folder = (URL)enu.nextElement();
            try {
                folder = FileLocator.resolve((URL)folder);
                return folder;
            }
            catch (IOException e) {
                GroovyCore.logException("Exception when looking for DSLD folder", e);
            }
        }
        return null;
    }

    public static String getDotGroovyLocation() {
        String home = System.getProperty("user.home");
        if (home != null) {
            home = String.valueOf(home) + "/.groovy";
        }
        return home;
    }

    public static File[] findJarsInDotGroovyLocation() {
        File libDir;
        String home = CompilerUtils.getDotGroovyLibLocation();
        if (home != null && (libDir = new File(home)).isDirectory()) {
            File[] files = libDir.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return !new File(dir, name).isDirectory() && name.endsWith(".jar");
                }
            });
            return files;
        }
        return new File[0];
    }

    public static SpecifiedVersion getWorkspaceCompilerLevel() {
        String groovyVersion = GroovySystem.getVersion();
        int dotIndex = groovyVersion.lastIndexOf(46);
        if (dotIndex > 0) {
            groovyVersion = groovyVersion.substring(0, dotIndex);
        }
        return SpecifiedVersion.findVersionFromString((String)groovyVersion);
    }
}

