/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.core.builder;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.groovy.eclipse.core.GroovyCoreActivator;
import org.codehaus.groovy.eclipse.core.compiler.CompilerUtils;
import org.codehaus.groovy.eclipse.core.model.GroovyRuntime;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.ClasspathAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyClasspathContainer
implements IClasspathContainer {
    public static final Path CONTAINER_ID = new Path("GROOVY_SUPPORT");
    public static final IClasspathAttribute MINIMAL_ATTRIBUTE = new ClasspathAttribute("minimal", "true");
    public static final String DESC = "Groovy Libraries";
    public static final IClasspathAttribute[] MINIMAL_ATTRIBUTE_ARR = new IClasspathAttribute[]{MINIMAL_ATTRIBUTE};
    private IClasspathEntry[] entries;
    private IProject project;

    public GroovyClasspathContainer(IProject project) {
        this.project = project;
    }

    public synchronized IClasspathEntry[] getClasspathEntries() {
        if (this.entries == null) {
            this.updateEntries();
        }
        return this.entries;
    }

    synchronized void reset() {
        this.entries = null;
    }

    private void updateEntries() {
        try {
            boolean minimalLibraries = GroovyClasspathContainer.hasMinimalAttribute(GroovyRuntime.getGroovyClasspathEntry(JavaCore.create((IProject)this.project)));
            LinkedHashSet<URL> libraryUrls = new LinkedHashSet<URL>();
            libraryUrls.add(CompilerUtils.getExportedGroovyAllJar());
            if (!minimalLibraries) {
                libraryUrls.addAll(Arrays.asList(CompilerUtils.getExtraJarsForClasspath()));
            }
            ArrayList<IClasspathEntry> cpEntries = new ArrayList<IClasspathEntry>(libraryUrls.size());
            for (URL libraryUrl : libraryUrls) {
                File docJarFile;
                Path jarPath = new Path(libraryUrl.getPath());
                Path srcPath = null;
                File srcJarFile = new File(libraryUrl.getPath().replace(".jar", "-sources.jar"));
                if (srcJarFile.exists()) {
                    srcPath = new Path(srcJarFile.getAbsolutePath());
                }
                IClasspathAttribute[] cpAttrs = (docJarFile = new File(libraryUrl.getPath().replace(".jar", "-javadoc.jar"))).exists() ? new IClasspathAttribute[]{new ClasspathAttribute("javadoc_location", docJarFile.getAbsolutePath())} : new IClasspathAttribute[]{};
                cpEntries.add(JavaCore.newLibraryEntry((IPath)jarPath, (IPath)srcPath, null, null, (IClasspathAttribute[])cpAttrs, (boolean)true));
            }
            if (!minimalLibraries && this.useGroovyLibs()) {
                cpEntries.addAll(this.getGroovyJarsInDotGroovyLib());
            }
            this.entries = cpEntries.toArray(new IClasspathEntry[cpEntries.size()]);
        }
        catch (Exception e) {
            GroovyCore.logException("Problem finding groovy runtime", e);
            this.entries = new IClasspathEntry[0];
        }
    }

    public static boolean hasMinimalAttribute(IClasspathEntry entry) throws JavaModelException {
        IClasspathAttribute[] extraAttributes;
        if (entry == null) {
            return false;
        }
        IClasspathAttribute[] iClasspathAttributeArray = extraAttributes = entry.getExtraAttributes();
        int n = extraAttributes.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathAttribute attribute = iClasspathAttributeArray[n2];
            if (attribute.getName().equals(MINIMAL_ATTRIBUTE.getName()) && Boolean.valueOf(attribute.getValue()).booleanValue()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean useGroovyLibs() {
        ProjectScope projectScope = new ProjectScope(this.project);
        IEclipsePreferences projectNode = projectScope.getNode("org.codehaus.groovy.eclipse.core");
        String val = projectNode.get("groovy.classpath.use.groovy,lib", "default");
        if (val.equals(Boolean.TRUE.toString())) {
            return true;
        }
        if (val.equals(Boolean.FALSE.toString())) {
            return false;
        }
        return GroovyCoreActivator.getDefault().getPreference("groovy.classpath.use.groovy.lib.global", true);
    }

    private Collection<IClasspathEntry> getGroovyJarsInDotGroovyLib() {
        File[] files = CompilerUtils.findJarsInDotGroovyLocation();
        ArrayList<IClasspathEntry> newEntries = new ArrayList<IClasspathEntry>(files.length);
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            IClasspathEntry entry = JavaCore.newLibraryEntry((IPath)new Path(file.getAbsolutePath()), null, null, null, (IClasspathAttribute[])new IClasspathAttribute[0], (boolean)true);
            newEntries.add(entry);
            ++n2;
        }
        return newEntries;
    }

    public String getDescription() {
        return DESC;
    }

    public int getKind() {
        return 1;
    }

    public IPath getPath() {
        return CONTAINER_ID;
    }
}

