/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.webui.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;

public class WinRegistry {
    public static final int HKEY_CURRENT_USER = -2147483647;
    public static final int REG_SUCCESS = 0;
    public static final int REG_NOTFOUND = 2;
    private static final int KEY_READ = 131097;
    private static Preferences userRoot = Preferences.userRoot();
    private static Method regOpenKey = null;
    private static Method regCloseKey = null;
    private static Method regQueryInfoKey = null;
    private static Method regEnumKeyEx = null;
    private static Method regEnumValue = null;
    private static Method regQueryValueEx = null;
    private static Method regCreateKeyEx = null;
    private static Method regSetValueEx = null;
    private static Class<? extends Preferences> userClass = userRoot.getClass();
    public static final String FEATURE_CONTROL_REGISTRY_PATH = "Software\\Microsoft\\Internet Explorer\\Main\\FeatureControl";
    public static final String FEATURE_HTTP_USERNAME_PASSWORD_DISABLE_SUBKEY = "FEATURE_HTTP_USERNAME_PASSWORD_DISABLE";
    public static final String ADD_DWORD_IEXPLORE_EXE = "REG ADD \"HKEY_CURRENT_USER\\Software\\Microsoft\\Internet Explorer\\Main\\FeatureControl\\FEATURE_HTTP_USERNAME_PASSWORD_DISABLE\" /v iexplore.exe /t REG_DWORD /d 0 /f";

    static {
        try {
            regOpenKey = userClass.getDeclaredMethod("WindowsRegOpenKey", Integer.TYPE, byte[].class, Integer.TYPE);
            regOpenKey.setAccessible(true);
            regCloseKey = userClass.getDeclaredMethod("WindowsRegCloseKey", Integer.TYPE);
            regCloseKey.setAccessible(true);
            regQueryInfoKey = userClass.getDeclaredMethod("WindowsRegQueryInfoKey1", Integer.TYPE);
            regQueryInfoKey.setAccessible(true);
            regEnumKeyEx = userClass.getDeclaredMethod("WindowsRegEnumKeyEx", Integer.TYPE, Integer.TYPE, Integer.TYPE);
            regEnumKeyEx.setAccessible(true);
            regEnumValue = userClass.getDeclaredMethod("WindowsRegEnumValue", Integer.TYPE, Integer.TYPE, Integer.TYPE);
            regEnumValue.setAccessible(true);
            regQueryValueEx = userClass.getDeclaredMethod("WindowsRegQueryValueEx", Integer.TYPE, byte[].class);
            regQueryValueEx.setAccessible(true);
            regCreateKeyEx = userClass.getDeclaredMethod("WindowsRegCreateKeyEx", Integer.TYPE, byte[].class);
            regCreateKeyEx.setAccessible(true);
            regSetValueEx = userClass.getDeclaredMethod("WindowsRegSetValueEx", Integer.TYPE, byte[].class, byte[].class);
            regSetValueEx.setAccessible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void enableUsernamePasswordOnURL() throws Exception {
        List<String> subKeys = WinRegistry.readStringSubKeys(-2147483647, FEATURE_CONTROL_REGISTRY_PATH);
        if (!subKeys.contains(FEATURE_HTTP_USERNAME_PASSWORD_DISABLE_SUBKEY)) {
            WinRegistry.createKey("Software\\Microsoft\\Internet Explorer\\Main\\FeatureControl\\FEATURE_HTTP_USERNAME_PASSWORD_DISABLE");
            Runtime.getRuntime().exec(ADD_DWORD_IEXPLORE_EXE);
        }
    }

    public static List<String> readStringSubKeys(int hkey, String key) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return WinRegistry.readStringSubKeys(userRoot, hkey, key);
    }

    private static List<String> readStringSubKeys(Preferences root, int hkey, String key) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        ArrayList<String> results = new ArrayList<String>();
        int[] handles = (int[])regOpenKey.invoke((Object)root, new Integer(hkey), WinRegistry.toCstr(key), new Integer(131097));
        if (handles[1] != 0) {
            return null;
        }
        int[] info = (int[])regQueryInfoKey.invoke((Object)root, new Integer(handles[0]));
        int count = info[0];
        int maxlen = info[3];
        int index = 0;
        while (index < count) {
            byte[] name = (byte[])regEnumKeyEx.invoke((Object)root, new Integer(handles[0]), new Integer(index), new Integer(maxlen + 1));
            results.add(new String(name).trim());
            ++index;
        }
        regCloseKey.invoke((Object)root, new Integer(handles[0]));
        return results;
    }

    public static Map<String, String> readStringValues(String key) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return WinRegistry.readStringValues(userRoot, key);
    }

    public static String readString(String key, String valueName) throws InvocationTargetException, IllegalArgumentException, IllegalAccessException {
        return WinRegistry.readString(userRoot, key, valueName);
    }

    private static Map<String, String> readStringValues(Preferences root, String key) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        HashMap<String, String> results = new HashMap<String, String>();
        int[] handles = (int[])regOpenKey.invoke((Object)root, new Integer(-2147483647), WinRegistry.toCstr(key), new Integer(131097));
        if (handles[1] != 0) {
            return null;
        }
        int[] info = (int[])regQueryInfoKey.invoke((Object)root, new Integer(handles[0]));
        int count = info[0];
        int maxlen = info[3];
        int index = 0;
        while (index < count) {
            byte[] name = (byte[])regEnumValue.invoke((Object)root, new Integer(handles[0]), new Integer(index), new Integer(maxlen + 1));
            String value = WinRegistry.readString(key, new String(name));
            results.put(new String(name).trim(), value);
            ++index;
        }
        regCloseKey.invoke((Object)root, new Integer(handles[0]));
        return results;
    }

    private static String readString(Preferences root, String key, String value) throws InvocationTargetException, IllegalAccessException, IllegalArgumentException {
        int[] handles = (int[])regOpenKey.invoke((Object)root, new Integer(-2147483647), WinRegistry.toCstr(key), new Integer(131097));
        if (handles[1] != 0) {
            return null;
        }
        byte[] valb = (byte[])regQueryValueEx.invoke((Object)root, new Integer(handles[0]), WinRegistry.toCstr(value));
        regCloseKey.invoke((Object)root, new Integer(handles[0]));
        return valb != null ? new String(valb).trim() : null;
    }

    public static void createKey(String key) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        int[] ret = WinRegistry.createKey(userRoot, key);
        regCloseKey.invoke((Object)userRoot, new Integer(ret[0]));
        if (ret[1] != 0) {
            throw new IllegalArgumentException("rc=" + ret[1] + "  key=" + key);
        }
    }

    private static int[] createKey(Preferences root, String key) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return (int[])regCreateKeyEx.invoke((Object)root, new Integer(-2147483647), WinRegistry.toCstr(key));
    }

    private static byte[] toCstr(String str) {
        byte[] result = new byte[str.length() + 1];
        int i = 0;
        while (i < str.length()) {
            result[i] = (byte)str.charAt(i);
            ++i;
        }
        result[str.length()] = 0;
        return result;
    }
}

