/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.webui.util;

import com.kms.katalon.core.logging.KeywordLogger;
import com.kms.katalon.core.webui.constants.StringConstants;
import com.kms.katalon.core.webui.driver.WebUIDriverType;
import com.kms.katalon.selenium.firefox.CFirefoxProfile;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.remote.DesiredCapabilities;

public class WebDriverPropertyUtil {
    private static final KeywordLogger logger = KeywordLogger.getInstance(WebDriverPropertyUtil.class);
    public static final String DISABLE_EXTENSIONS = "--disable-extensions";
    public static final String CHROME_SWITCHES = "chrome.switches";
    public static final String CHROME_NO_SANDBOX = "--no-sandbox";
    private static final String CHROME_ARGUMENT_PROPERTY_KEY = "args";
    private static final String CHROME_BINARY_PROPERTY_KEY = "binary";
    private static final String CHROME_EXTENSIONS_PROPERTY_KEY = "extensions";
    private static final String CHROME_PREFERENCES_PROPERTY_KEY = "prefs";
    private static final String CHROME_LOCALSTATE_PROPERTY_KEY = "localState";
    private static final String CHROME_DETACH_PROPERTY_KEY = "detach";
    private static final String CHROME_DEBUGGER_ADDRESS_PROPERTY_KEY = "debuggerAddress";
    private static final String CHROME_EXCLUDE_SWITCHES_PROPERTY_KEY = "excludeSwitches";
    private static final String CHROME_MINI_DUMP_PATH_PROPERTY_KEY = "minidumpPath";
    private static final String CHROME_MOBILE_EMULATION_PROPERTY_KEY = "mobileEmulation";
    private static final String CHROME_PREF_LOGGING_PREFS_PROPERTY_KEY = "perfLoggingPrefs";
    private static final String[] CHROME_CAPABILITIES = new String[]{"args", "binary", "extensions", "prefs", "localState", "detach", "debuggerAddress", "excludeSwitches", "minidumpPath", "mobileEmulation", "perfLoggingPrefs"};
    private static final String STARTUP_HOMEPAGE_WELCOME_URL_ADDITIONAL_PREFERENCE = "startup.homepage_welcome_url.additional";
    private static final String STARTUP_HOMEPAGE_WELCOME_URL_PREFERENCE = "startup.homepage_welcome_url";
    private static final String BROWSER_STARTUP_HOMEPAGE_PREFERENCE = "browser.startup.homepage";
    private static final String FIREFOX_BLANK_PAGE = "about:blank";
    public static final String KATALON_DOCKER_ENV_KEY = "KATALON_DOCKER";

    public static DesiredCapabilities toDesireCapabilities(Map<String, Object> propertyMap, WebUIDriverType webUIDriverType) {
        if (propertyMap == null) {
            return null;
        }
        switch (webUIDriverType) {
            case CHROME_DRIVER: 
            case HEADLESS_DRIVER: {
                return WebDriverPropertyUtil.getDesireCapabilitiesForChrome(propertyMap);
            }
            case FIREFOX_DRIVER: 
            case FIREFOX_HEADLESS_DRIVER: {
                return WebDriverPropertyUtil.getDesireCapabilitiesForFirefox(propertyMap);
            }
        }
        return WebDriverPropertyUtil.toDesireCapabilities(propertyMap);
    }

    public static DesiredCapabilities toDesireCapabilities(Map<String, Object> propertyMap) {
        return WebDriverPropertyUtil.toDesireCapabilities(propertyMap, new DesiredCapabilities(), true);
    }

    public static DesiredCapabilities toDesireCapabilities(Map<String, Object> propertyMap, DesiredCapabilities desireCapabilities, boolean isLog) {
        for (Map.Entry<String, Object> property : propertyMap.entrySet()) {
            if (isLog) {
                logger.logInfo(MessageFormat.format(StringConstants.KW_LOG_WEB_UI_PROPERTY_SETTING, property.getKey(), property.getValue()));
            }
            desireCapabilities.setCapability(property.getKey(), property.getValue());
        }
        return desireCapabilities;
    }

    public static DesiredCapabilities getDesireCapabilitiesForFirefox(Map<String, Object> propertyMap) {
        DesiredCapabilities desireCapabilities = DesiredCapabilities.firefox();
        FirefoxProfile firefoxProfile = WebDriverPropertyUtil.createDefaultFirefoxProfile();
        for (Map.Entry<String, Object> property : propertyMap.entrySet()) {
            if (property.getKey().equals("firefox_profile") && property.getValue() instanceof Map) {
                WebDriverPropertyUtil.processFirefoxPreferencesSetting(firefoxProfile, (Map)property.getValue());
                continue;
            }
            desireCapabilities.setCapability(property.getKey(), property.getValue());
            logger.logInfo(MessageFormat.format(StringConstants.KW_LOG_WEB_UI_PROPERTY_SETTING, property.getKey(), property.getValue()));
        }
        desireCapabilities.setCapability("firefox_profile", (Object)firefoxProfile);
        return desireCapabilities;
    }

    private static void processFirefoxPreferencesSetting(FirefoxProfile firefoxProfile, Map<?, ?> firefoxPropertyMap) {
        for (Map.Entry<?, ?> entry : firefoxPropertyMap.entrySet()) {
            String entryKey;
            if (!(entry.getKey() instanceof String) || !WebDriverPropertyUtil.setFirefoxPreferenceValue(firefoxProfile, entryKey = (String)entry.getKey(), entry.getValue())) continue;
            logger.logInfo(MessageFormat.format(StringConstants.KW_LOG_FIREFOX_PROPERTY_SETTING, entryKey, entry.getValue()));
        }
    }

    private static boolean setFirefoxPreferenceValue(FirefoxProfile firefoxProfile, String entryKey, Object entryValue) {
        if (entryValue instanceof Number) {
            firefoxProfile.setPreference(entryKey, ((Number)entryValue).intValue());
            return true;
        }
        if (entryValue instanceof Boolean) {
            firefoxProfile.setPreference(entryKey, ((Boolean)entryValue).booleanValue());
            return true;
        }
        if (entryValue instanceof String) {
            firefoxProfile.setPreference(entryKey, (String)entryValue);
            return true;
        }
        return false;
    }

    public static FirefoxProfile createDefaultFirefoxProfile() {
        CFirefoxProfile firefoxProfile = new CFirefoxProfile();
        firefoxProfile.setPreference(BROWSER_STARTUP_HOMEPAGE_PREFERENCE, FIREFOX_BLANK_PAGE);
        firefoxProfile.setPreference(STARTUP_HOMEPAGE_WELCOME_URL_PREFERENCE, FIREFOX_BLANK_PAGE);
        firefoxProfile.setPreference(STARTUP_HOMEPAGE_WELCOME_URL_ADDITIONAL_PREFERENCE, FIREFOX_BLANK_PAGE);
        return firefoxProfile;
    }

    public static DesiredCapabilities getDesireCapabilitiesForChrome(Map<String, Object> propertyMap) {
        DesiredCapabilities desireCapabilities = DesiredCapabilities.chrome();
        HashMap<String, Object> chromeOptions = new HashMap<String, Object>();
        for (Map.Entry<String, Object> driverProperty : propertyMap.entrySet()) {
            if (Arrays.asList(CHROME_CAPABILITIES).contains(driverProperty.getKey())) {
                chromeOptions.put(driverProperty.getKey(), driverProperty.getValue());
            } else {
                desireCapabilities.setCapability(driverProperty.getKey(), driverProperty.getValue());
            }
            logger.logInfo(MessageFormat.format(StringConstants.KW_LOG_WEB_UI_PROPERTY_SETTING, driverProperty.getKey(), driverProperty.getValue()));
        }
        WebDriverPropertyUtil.injectAddtionalArgumentsForChrome(chromeOptions);
        desireCapabilities.setCapability("goog:chromeOptions", chromeOptions);
        return desireCapabilities;
    }

    private static void injectAddtionalArgumentsForChrome(Map<String, Object> chromeOptions) {
        if (chromeOptions == null) {
            return;
        }
        ArrayList<String> argumentsList = new ArrayList<String>();
        if (chromeOptions.get(CHROME_ARGUMENT_PROPERTY_KEY) instanceof List) {
            argumentsList.addAll((List)chromeOptions.get(CHROME_ARGUMENT_PROPERTY_KEY));
        }
        argumentsList.add(CHROME_SWITCHES);
        argumentsList.add(DISABLE_EXTENSIONS);
        if (WebDriverPropertyUtil.isRunningInDocker()) {
            argumentsList.add(CHROME_NO_SANDBOX);
        }
        chromeOptions.put(CHROME_ARGUMENT_PROPERTY_KEY, argumentsList);
    }

    public static void addArgumentsForChrome(DesiredCapabilities caps, String ... args) {
        ArrayList<String> argsEntry;
        HashMap<String, ArrayList<String>> chromeOptions = (HashMap<String, ArrayList<String>>)caps.getCapability("goog:chromeOptions");
        if (chromeOptions == null) {
            chromeOptions = new HashMap<String, ArrayList<String>>();
        }
        if ((argsEntry = (ArrayList<String>)chromeOptions.get(CHROME_ARGUMENT_PROPERTY_KEY)) == null) {
            argsEntry = new ArrayList<String>();
        }
        argsEntry.addAll(Arrays.asList(args));
        if (WebDriverPropertyUtil.isRunningInDocker()) {
            argsEntry.add(CHROME_NO_SANDBOX);
        }
        chromeOptions.put(CHROME_ARGUMENT_PROPERTY_KEY, argsEntry);
        caps.setCapability("goog:chromeOptions", chromeOptions);
    }

    public static void removeArgumentsForChrome(DesiredCapabilities caps, String ... args) {
        ArrayList<String> argsEntry;
        HashMap chromeOptions = (HashMap)caps.getCapability("goog:chromeOptions");
        if (chromeOptions == null) {
            chromeOptions = new HashMap();
        }
        if ((argsEntry = (ArrayList<String>)chromeOptions.get(CHROME_ARGUMENT_PROPERTY_KEY)) == null) {
            argsEntry = new ArrayList<String>();
        }
        argsEntry.removeAll(Arrays.asList(args));
        if (WebDriverPropertyUtil.isRunningInDocker()) {
            argsEntry.add(CHROME_NO_SANDBOX);
        }
        chromeOptions.put(CHROME_ARGUMENT_PROPERTY_KEY, argsEntry);
        caps.setCapability("goog:chromeOptions", chromeOptions);
    }

    public static boolean isRunningInDocker() {
        if (System.getenv().containsKey(KATALON_DOCKER_ENV_KEY)) {
            return Boolean.valueOf(System.getenv(KATALON_DOCKER_ENV_KEY));
        }
        return false;
    }
}

