/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.webui.util;

import com.kms.katalon.core.exception.StepFailedException;
import com.kms.katalon.core.webui.driver.DriverFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriverException;

public class FileUtil {
    private static final String SCREENSHOT_FOLDER = "resources/screen";
    private static final String KMS_IE_DRIVER_FOLDER = "resources/drivers/kmsie";
    private static final String AUTHENTICATION_FOLDER = "resources/authentication";

    public static String takesScreenshot(String fileName) throws IOException, WebDriverException, StepFailedException {
        FileUtils.copyFile((File)((File)((TakesScreenshot)DriverFactory.getWebDriver()).getScreenshotAs(OutputType.FILE)), (File)new File(fileName), (boolean)false);
        return fileName;
    }

    public static File extractScreenFiles() throws Exception {
        String path = FileUtil.class.getProtectionDomain().getCodeSource().getLocation().getFile();
        File jarFile = new File(path = URLDecoder.decode(path, "utf-8"));
        if (jarFile.isFile()) {
            JarFile jar = new JarFile(jarFile);
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry jarEntry = entries.nextElement();
                String name = jarEntry.getName();
                if (!name.startsWith(SCREENSHOT_FOLDER) || !name.endsWith(".png")) continue;
                String mappingFileName = name.replace("resources/screen/", "");
                File tmpFile = new File(String.valueOf(System.getProperty("java.io.tmpdir")) + mappingFileName);
                if (tmpFile.exists()) {
                    tmpFile.delete();
                }
                FileOutputStream fos = new FileOutputStream(tmpFile);
                IOUtils.copy((InputStream)jar.getInputStream(jarEntry), (OutputStream)fos);
                fos.flush();
                fos.close();
            }
            jar.close();
            return new File(System.getProperty("java.io.tmpdir"));
        }
        File folder = new File(String.valueOf(path) + "../" + SCREENSHOT_FOLDER);
        return folder;
    }

    public static File getKmsIeDriverDirectory() throws IOException {
        String path = FileUtil.class.getProtectionDomain().getCodeSource().getLocation().getFile();
        File jarFile = new File(path = URLDecoder.decode(path, "utf-8"));
        if (jarFile.isFile()) {
            String kmsIePath = String.valueOf(jarFile.getParentFile().getParentFile().getAbsolutePath()) + "/configuration/" + KMS_IE_DRIVER_FOLDER;
            return new File(kmsIePath);
        }
        File folder = new File(String.valueOf(path) + "../" + KMS_IE_DRIVER_FOLDER);
        return folder;
    }

    public static File getAuthenticationDirectory() throws IOException {
        String path = FileUtil.class.getProtectionDomain().getCodeSource().getLocation().getFile();
        File jarFile = new File(path = URLDecoder.decode(path, "utf-8"));
        if (jarFile.isFile()) {
            String kmsIePath = String.valueOf(jarFile.getParentFile().getParentFile().getAbsolutePath()) + "/configuration/" + AUTHENTICATION_FOLDER;
            return new File(kmsIePath);
        }
        File folder = new File(String.valueOf(path) + "../" + AUTHENTICATION_FOLDER);
        return folder;
    }
}

