/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.webui.driver;

import com.kms.katalon.core.appium.driver.AppiumDriverManager;
import com.kms.katalon.core.appium.exception.AppiumStartException;
import com.kms.katalon.core.appium.exception.MobileDriverInitializeException;
import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.driver.DriverType;
import com.kms.katalon.core.exception.StepFailedException;
import com.kms.katalon.core.logging.KeywordLogger;
import com.kms.katalon.core.webui.constants.StringConstants;
import com.kms.katalon.core.webui.driver.WebUIDriverType;
import io.appium.java_client.AppiumDriver;
import java.io.IOException;
import java.net.MalformedURLException;
import java.text.MessageFormat;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.remote.DesiredCapabilities;

public class WebMobileDriverFactory {
    private static final KeywordLogger logger = KeywordLogger.getInstance(WebMobileDriverFactory.class);
    private static final String CHROME = "Chrome";
    private static final String SAFARI = "Safari";
    public static final String MOBILE_DRIVER_PROPERTY = "Mobile";
    public static final String EXECUTED_MOBILE_PLATFORM = "devicePlatform";
    public static final String EXECUTED_MOBILE_DEVICE_ID = "deviceId";

    public static void cleanup() throws InterruptedException, IOException {
        AppiumDriverManager.cleanup();
    }

    public static AppiumDriver<?> getDriver() throws StepFailedException {
        return AppiumDriverManager.getDriver();
    }

    public static void closeDriver() {
        AppiumDriverManager.closeDriver();
    }

    private static DesiredCapabilities toDesireCapabilities(Map<String, Object> propertyMap, WebUIDriverType WebUIDriverType2) {
        DesiredCapabilities desireCapabilities = new DesiredCapabilities();
        for (Map.Entry<String, Object> property : propertyMap.entrySet()) {
            logger.logInfo(MessageFormat.format(StringConstants.KW_LOG_WEB_UI_PROPERTY_SETTING, property.getKey(), property.getValue()));
            desireCapabilities.setCapability(property.getKey(), property.getValue());
        }
        return desireCapabilities;
    }

    private static DesiredCapabilities createCapabilities(WebUIDriverType osType) {
        DesiredCapabilities capabilities = new DesiredCapabilities();
        Map driverPreferences = RunConfiguration.getDriverPreferencesProperties((String)MOBILE_DRIVER_PROPERTY);
        String deviceId = WebMobileDriverFactory.getDeviceId();
        if (driverPreferences != null && osType == WebUIDriverType.IOS_DRIVER) {
            capabilities.merge((Capabilities)WebMobileDriverFactory.toDesireCapabilities(driverPreferences, WebUIDriverType.IOS_DRIVER));
            capabilities.setCapability("browserName", SAFARI);
            if (deviceId == null) {
                capabilities.setCapability("platform", WebMobileDriverFactory.getDeviceOS());
                capabilities.setCapability("platformVersion", WebMobileDriverFactory.getDeviceOSVersion());
            }
            try {
                if (AppiumDriverManager.getXCodeVersion() >= 8) {
                    capabilities.setCapability("automationName", "XCUITest");
                    capabilities.setCapability("realDeviceLogger", RunConfiguration.getDeviceConsoleExecutable());
                    capabilities.setCapability("wdaLocalPort", (Object)AppiumDriverManager.getFreePort());
                }
            }
            catch (ExecutionException executionException) {}
        } else if (driverPreferences != null && osType == WebUIDriverType.ANDROID_DRIVER) {
            capabilities.merge((Capabilities)WebMobileDriverFactory.toDesireCapabilities(driverPreferences, WebUIDriverType.ANDROID_DRIVER));
            capabilities.setPlatform(Platform.ANDROID);
            capabilities.setCapability("browserName", CHROME);
        }
        capabilities.setCapability("deviceName", WebMobileDriverFactory.getDeviceName());
        if (deviceId != null) {
            capabilities.setCapability("udid", deviceId);
        }
        capabilities.setCapability("newCommandTimeout", (Object)1800);
        return capabilities;
    }

    public static AppiumDriver<?> startExisitingMobileDriver(DriverType driverType, String sessionId, String remoteServerUrl) throws MalformedURLException, MobileDriverInitializeException {
        return AppiumDriverManager.startExisitingMobileDriver((DriverType)driverType, (String)sessionId, (String)remoteServerUrl);
    }

    public static AppiumDriver<?> createMobileDriver(WebUIDriverType osType) throws MobileDriverInitializeException, IOException, InterruptedException, AppiumStartException {
        return AppiumDriverManager.createMobileDriver((DriverType)osType, (String)WebMobileDriverFactory.getDeviceId(), (DesiredCapabilities)WebMobileDriverFactory.createCapabilities(osType));
    }

    public static WebUIDriverType getWebMobileDriverType() {
        return WebUIDriverType.valueOf(RunConfiguration.getDriverSystemProperty((String)"WebUI", (String)EXECUTED_MOBILE_PLATFORM));
    }

    public static String getDevicePlatform() {
        return WebMobileDriverFactory.getWebMobileDriverType().toString();
    }

    public static String getDeviceId() {
        return AppiumDriverManager.getDeviceId((String)MOBILE_DRIVER_PROPERTY);
    }

    public static String getDeviceName() {
        return AppiumDriverManager.getDeviceName((String)MOBILE_DRIVER_PROPERTY);
    }

    public static String getDeviceModel() {
        return AppiumDriverManager.getDeviceModel((String)MOBILE_DRIVER_PROPERTY);
    }

    public static String getDeviceManufacturer() {
        return AppiumDriverManager.getDeviceManufacturer((String)MOBILE_DRIVER_PROPERTY);
    }

    public static String getDeviceOSVersion() {
        return AppiumDriverManager.getDeviceOSVersion((String)MOBILE_DRIVER_PROPERTY);
    }

    public static String getDeviceOS() {
        return AppiumDriverManager.getDeviceOS((String)MOBILE_DRIVER_PROPERTY);
    }
}

