/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.webui.driver;

import com.kms.katalon.selenium.driver.IExistingRemoteWebDriver;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.ConnectException;
import java.net.URL;
import java.util.Map;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.HttpCommandExecutor;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.http.JsonHttpCommandCodec;
import org.openqa.selenium.remote.http.JsonHttpResponseCodec;
import org.openqa.selenium.remote.http.W3CHttpCommandCodec;
import org.openqa.selenium.remote.http.W3CHttpResponseCodec;

public class ExistingRemoteWebDriver
extends RemoteWebDriver
implements IExistingRemoteWebDriver {
    private static final int REMOTE_BROWSER_CONNECT_TIMEOUT = 60000;
    private static Field EXECUTOR_COMMAND_CODEC_FIELD;
    private static Field EXECUTOR_RESPONSE_CODEC_FIELD;
    private String oldSessionId;

    static {
        try {
            EXECUTOR_COMMAND_CODEC_FIELD = HttpCommandExecutor.class.getDeclaredField("commandCodec");
            EXECUTOR_COMMAND_CODEC_FIELD.setAccessible(true);
            EXECUTOR_RESPONSE_CODEC_FIELD = HttpCommandExecutor.class.getDeclaredField("responseCodec");
            EXECUTOR_RESPONSE_CODEC_FIELD.setAccessible(true);
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (SecurityException securityException) {}
    }

    public ExistingRemoteWebDriver(URL remoteAddress, String oldSessionId) throws ConnectException {
        super(remoteAddress, (Capabilities)new DesiredCapabilities());
        ExistingRemoteWebDriver.waitForRemoteBrowserReady(remoteAddress);
        this.setSessionId(oldSessionId);
        this.oldSessionId = oldSessionId;
        if (this.getCommandExecutor() instanceof HttpCommandExecutor) {
            try {
                this.initCodecForHttpCommandExecutor();
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
        this.startClient();
        this.startSession((Capabilities)new DesiredCapabilities());
    }

    private void initCodecForHttpCommandExecutor() throws IllegalArgumentException, IllegalAccessException {
        HttpCommandExecutor executor = (HttpCommandExecutor)this.getCommandExecutor();
        EXECUTOR_COMMAND_CODEC_FIELD.set(executor, new JsonHttpCommandCodec());
        EXECUTOR_RESPONSE_CODEC_FIELD.set(executor, new JsonHttpResponseCodec());
        Response response = this.execute("status");
        if (response.getStatus() == null || response.getStatus() != 0) {
            EXECUTOR_COMMAND_CODEC_FIELD.set(executor, new W3CHttpCommandCodec());
            EXECUTOR_RESPONSE_CODEC_FIELD.set(executor, new W3CHttpResponseCodec());
        }
    }

    public ExistingRemoteWebDriver(String oldSessionId, CommandExecutor executor, Capabilities desiredCapabilities) {
        super(executor, desiredCapabilities);
        this.oldSessionId = oldSessionId;
    }

    protected void startSession(Capabilities desiredCapabilities) {
        if (this.oldSessionId == null) {
            return;
        }
        super.startSession(desiredCapabilities);
    }

    protected void startClient() {
        if (this.oldSessionId == null) {
            return;
        }
        super.startClient();
    }

    protected Response execute(String driverCommand, Map<String, ?> parameters) {
        if ("newSession".equals(driverCommand)) {
            return this.createResponseForNewSession(this.oldSessionId);
        }
        return super.execute(driverCommand, parameters);
    }

    private static void waitForRemoteBrowserReady(URL url) throws ConnectException {
        long waitUntil = System.currentTimeMillis() + 60000L;
        boolean connectable = false;
        while (!connectable) {
            try {
                url.openConnection().connect();
                connectable = true;
            }
            catch (IOException iOException) {}
            if (waitUntil < System.currentTimeMillis()) {
                throw new ConnectException(String.format("Unable to connect to browser on host %s and port %s after %s seconds.", url.getHost(), url.getPort(), 60000));
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

