/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.webui.driver;

import com.kms.katalon.core.appium.driver.SwipeableAndroidDriver;
import com.kms.katalon.core.appium.exception.AppiumStartException;
import com.kms.katalon.core.appium.exception.MobileDriverInitializeException;
import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.driver.DriverType;
import com.kms.katalon.core.exception.StepFailedException;
import com.kms.katalon.core.logging.KeywordLogger;
import com.kms.katalon.core.logging.LogLevel;
import com.kms.katalon.core.network.HttpClientProxyBuilder;
import com.kms.katalon.core.network.ProxyInformation;
import com.kms.katalon.core.webui.common.WebUiCommonHelper;
import com.kms.katalon.core.webui.constants.CoreWebuiMessageConstants;
import com.kms.katalon.core.webui.constants.StringConstants;
import com.kms.katalon.core.webui.driver.ExistingRemoteWebDriver;
import com.kms.katalon.core.webui.driver.WebMobileDriverFactory;
import com.kms.katalon.core.webui.driver.WebUIDriverType;
import com.kms.katalon.core.webui.driver.firefox.CFirefoxDriver47;
import com.kms.katalon.core.webui.driver.firefox.CGeckoDriver;
import com.kms.katalon.core.webui.driver.ie.InternetExploreDriverServiceBuilder;
import com.kms.katalon.core.webui.exception.BrowserNotOpenedException;
import com.kms.katalon.core.webui.util.FirefoxExecutable;
import com.kms.katalon.core.webui.util.WebDriverPropertyUtil;
import com.kms.katalon.core.webui.util.WebDriverProxyUtil;
import com.kms.katalon.selenium.driver.CChromeDriver;
import com.kms.katalon.selenium.driver.CEdgeDriver;
import com.kms.katalon.selenium.driver.CFirefoxDriver;
import com.kms.katalon.selenium.driver.CInternetExplorerDriver;
import com.kms.katalon.selenium.driver.CRemoteWebDriver;
import com.kms.katalon.selenium.driver.CSafariDriver;
import io.appium.java_client.ios.IOSDriver;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.http.impl.client.HttpClientBuilder;
import org.openqa.selenium.Alert;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.NoAlertPresentException;
import org.openqa.selenium.NoSuchWindowException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.edge.EdgeDriver;
import org.openqa.selenium.edge.EdgeDriverService;
import org.openqa.selenium.firefox.ExtensionConnection;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.firefox.GeckoDriverService;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.ie.InternetExplorerDriverLogLevel;
import org.openqa.selenium.ie.InternetExplorerDriverService;
import org.openqa.selenium.ie.InternetExplorerOptions;
import org.openqa.selenium.internal.BuildInfo;
import org.openqa.selenium.net.NetworkUtils;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.HttpCommandExecutor;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.UnreachableBrowserException;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.internal.ApacheHttpClient;
import org.openqa.selenium.safari.SafariDriver;

public class DriverFactory {
    private static final KeywordLogger logger = KeywordLogger.getInstance(DriverFactory.class);
    private static final int USING_MARIONETTEE_VERSION = 47;
    private static final int USING_GECKO_VERSION = 57;
    private static final String CAP_IE_USE_PER_PROCESS_PROXY = "ie.usePerProcessProxy";
    private static final String IE_DRIVER_SERVER_LOG_FILE_NAME = "IEDriverServer.log";
    public static final String WEB_UI_DRIVER_PROPERTY = "WebUI";
    public static final String MOBILE_DRIVER_PROPERTY = "Mobile";
    public static final String EXISTING_DRIVER_PROPERTY = "Existing";
    public static final String APPIUM_LOG_PROPERTY = "appiumLogFile";
    private static final String APPIUM_CAPABILITY_PLATFORM_NAME_ADROID = "android";
    private static final String APPIUM_CAPABILITY_PLATFORM_NAME_IOS = "ios";
    private static final String APPIUM_CAPABILITY_PLATFORM_NAME = "platformName";
    private static final String REMOTE_WEB_DRIVER_TYPE_APPIUM = "Appium";
    private static final String REMOTE_WEB_DRIVER_TYPE_SELENIUM = "Selenium";
    public static final String CHROME_DRIVER_PATH_PROPERTY_KEY = "webdriver.chrome.driver";
    private static final String IE_DRIVER_PATH_PROPERTY_KEY = "webdriver.ie.driver";
    private static final String JAVA_SCRIPT_ERROR_H_IS_NULL_MESSAGE = "[JavaScript Error: \"h is null\"";
    public static final String IE_DRIVER_PATH_PROPERTY = "ieDriverPath";
    public static final String EDGE_DRIVER_PATH_PROPERTY = "edgeDriverPath";
    public static final String CHROME_DRIVER_PATH_PROPERTY = "chromeDriverPath";
    public static final String WAIT_FOR_IE_HANGING_PROPERTY = "waitForIEHanging";
    public static final String ENABLE_PAGE_LOAD_TIMEOUT = "enablePageLoadTimeout";
    public static final String DEFAULT_PAGE_LOAD_TIMEOUT = "defaultPageLoadTimeout";
    public static final String ACTION_DELAY = "actionDelay";
    public static final String IGNORE_PAGE_LOAD_TIMEOUT_EXCEPTION = "ignorePageLoadTimeoutException";
    public static final String EXECUTED_BROWSER_PROPERTY = "browserType";
    public static final String REMOTE_WEB_DRIVER_URL = "remoteWebDriverUrl";
    public static final String REMOTE_WEB_DRIVER_TYPE = "remoteWebDriverType";
    public static final String DEBUG_PORT = "debugPort";
    public static final String DEBUG_HOST = "debugHost";
    public static final String DEFAULT_FIREFOX_DEBUG_PORT = "10001";
    public static final String DEFAULT_CHROME_DEBUG_PORT = "10002";
    public static final String DEFAULT_DEBUG_HOST = "localhost";
    private static final int REMOTE_BROWSER_CONNECT_TIMEOUT = 60000;
    private static final ThreadLocal<WebDriver> localWebServerStorage = new ThreadLocal<WebDriver>(){

        @Override
        protected WebDriver initialValue() {
            return null;
        }
    };
    private static final ThreadLocal<EdgeDriverService> localEdgeDriverServiceStorage = new ThreadLocal<EdgeDriverService>(){

        @Override
        protected EdgeDriverService initialValue() {
            return (EdgeDriverService)((EdgeDriverService.Builder)((EdgeDriverService.Builder)new EdgeDriverService.Builder().usingDriverExecutable(new File(DriverFactory.getEdgeDriverPath()))).usingAnyFreePort()).build();
        }
    };
    private static InternetExplorerDriverService ieDriverService;
    private static int actionDelay;

    static {
        actionDelay = -1;
    }

    public static WebDriver openWebDriver() throws Exception {
        try {
            WebDriver webDriver = null;
            webDriver = DriverFactory.isUsingExistingDriver() ? DriverFactory.startExistingBrowser() : DriverFactory.startNewBrowser(DriverFactory.getExecutedBrowser());
            DriverFactory.changeWebDriver(webDriver);
            return webDriver;
        }
        catch (Error e) {
            logger.logMessage(LogLevel.WARNING, e.getMessage());
            throw new StepFailedException((Throwable)e);
        }
    }

    private static void changeWebDriver(WebDriver webDriver) {
        localWebServerStorage.set(webDriver);
        RunConfiguration.storeDriver((Object)webDriver);
        DriverFactory.setTimeout();
        DriverFactory.logBrowserRunData(webDriver);
    }

    private static boolean isUsingExistingDriver() {
        return RunConfiguration.getDriverSystemProperties((String)EXISTING_DRIVER_PROPERTY) != null;
    }

    private static WebDriver startNewBrowser(DriverType executedBrowser) throws MalformedURLException, MobileDriverInitializeException, IOException, InterruptedException, AppiumStartException, Exception {
        WebUIDriverType driver = (WebUIDriverType)executedBrowser;
        if (driver == null) {
            throw new StepFailedException(StringConstants.DRI_ERROR_MSG_NO_BROWSER_SET);
        }
        if (localWebServerStorage.get() != null && ((RemoteWebDriver)localWebServerStorage.get()).getSessionId() != null) {
            logger.logWarning(StringConstants.DRI_LOG_WARNING_BROWSER_ALREADY_OPENED);
            DriverFactory.closeWebDriver();
        }
        logger.logInfo(MessageFormat.format(StringConstants.XML_LOG_STARTING_DRIVER_X, driver.toString()));
        Map driverPreferenceProps = RunConfiguration.getDriverPreferencesProperties((String)WEB_UI_DRIVER_PROPERTY);
        DesiredCapabilities desireCapibilities = null;
        if (driverPreferenceProps != null) {
            desireCapibilities = WebDriverPropertyUtil.toDesireCapabilities(driverPreferenceProps, driver);
        }
        WebDriver webDriver = null;
        switch (driver) {
            case FIREFOX_DRIVER: {
                webDriver = DriverFactory.createNewFirefoxDriver(desireCapibilities);
                break;
            }
            case IE_DRIVER: {
                webDriver = DriverFactory.createNewIEDriver(desireCapibilities);
                break;
            }
            case SAFARI_DRIVER: {
                webDriver = DriverFactory.createNewSafariDriver(desireCapibilities);
                break;
            }
            case CHROME_DRIVER: {
                webDriver = DriverFactory.createNewChromeDriver(desireCapibilities);
                break;
            }
            case REMOTE_WEB_DRIVER: 
            case KOBITON_WEB_DRIVER: {
                webDriver = DriverFactory.createNewRemoteWebDriver(driverPreferenceProps, desireCapibilities);
                break;
            }
            case ANDROID_DRIVER: 
            case IOS_DRIVER: {
                webDriver = WebMobileDriverFactory.createMobileDriver(driver);
                break;
            }
            case EDGE_DRIVER: {
                webDriver = DriverFactory.createNewEdgeDriver(driverPreferenceProps);
                break;
            }
            case REMOTE_FIREFOX_DRIVER: {
                webDriver = DriverFactory.createNewRemoteFirefoxDriver(desireCapibilities);
                break;
            }
            case REMOTE_CHROME_DRIVER: {
                webDriver = DriverFactory.createNewRemoteChromeDriver(desireCapibilities);
                break;
            }
            case HEADLESS_DRIVER: {
                webDriver = DriverFactory.createHeadlessChromeDriver(desireCapibilities);
                break;
            }
            case FIREFOX_HEADLESS_DRIVER: {
                webDriver = DriverFactory.createHeadlessFirefoxDriver(desireCapibilities);
                break;
            }
            default: {
                throw new StepFailedException(MessageFormat.format(StringConstants.DRI_ERROR_DRIVER_X_NOT_IMPLEMENTED, driver.getName()));
            }
        }
        DriverFactory.saveWebDriverSessionData(webDriver);
        return webDriver;
    }

    private static CSafariDriver createNewSafariDriver(DesiredCapabilities desireCapibilities) {
        return new CSafariDriver((Capabilities)desireCapibilities, DriverFactory.getActionDelay());
    }

    private static WebDriver createNewChromeDriver(DesiredCapabilities desireCapibilities) {
        return new CChromeDriver((Capabilities)DriverFactory.addCapbilitiesForChrome(desireCapibilities), DriverFactory.getActionDelay());
    }

    private static DesiredCapabilities addCapbilitiesForChrome(DesiredCapabilities desireCapibilities) {
        System.setProperty(CHROME_DRIVER_PATH_PROPERTY_KEY, DriverFactory.getChromeDriverPath());
        ProxyInformation proxyInformation = RunConfiguration.getProxyInformation();
        if (WebDriverProxyUtil.isManualSocks(proxyInformation)) {
            WebDriverPropertyUtil.addArgumentsForChrome(desireCapibilities, "--proxy-server=socks5://" + WebDriverProxyUtil.getProxyString(proxyInformation));
        } else {
            desireCapibilities.setCapability("proxy", DriverFactory.getDefaultProxy());
        }
        return desireCapibilities;
    }

    private static WebDriver createHeadlessChromeDriver(DesiredCapabilities desireCapibilities) {
        DesiredCapabilities chromeCapbilities = DriverFactory.addCapbilitiesForChrome(desireCapibilities);
        WebDriverPropertyUtil.addArgumentsForChrome(desireCapibilities, "--headless", "disable-gpu");
        return new CChromeDriver((Capabilities)chromeCapbilities, DriverFactory.getActionDelay());
    }

    private static Map<String, Object> getDefaultProxy() {
        return WebDriverProxyUtil.getSeleniumProxy(RunConfiguration.getProxyInformation());
    }

    private static WebDriver createNewRemoteWebDriver(Map<String, Object> driverPreferenceProps, DesiredCapabilities desireCapibilities) throws URISyntaxException, IOException, GeneralSecurityException {
        String remoteWebServerUrl = DriverFactory.getRemoteWebDriverServerUrl();
        String remoteWebServerType = DriverFactory.getRemoteWebDriverServerType();
        if (remoteWebServerType == null) {
            remoteWebServerType = REMOTE_WEB_DRIVER_TYPE_SELENIUM;
        }
        desireCapibilities.setCapability("proxy", DriverFactory.getDefaultProxy());
        HttpCommandExecutor executor = DriverFactory.getExecutorForRemoteDriver(remoteWebServerUrl);
        logger.logInfo(MessageFormat.format(StringConstants.XML_LOG_CONNECTING_TO_REMOTE_WEB_SERVER_X_WITH_TYPE_Y, remoteWebServerUrl, remoteWebServerType));
        if (!remoteWebServerType.equals(REMOTE_WEB_DRIVER_TYPE_APPIUM)) {
            return new CRemoteWebDriver((CommandExecutor)executor, (Capabilities)desireCapibilities, DriverFactory.getActionDelay());
        }
        Object platformName = desireCapibilities.getCapability(APPIUM_CAPABILITY_PLATFORM_NAME);
        if (platformName == null || !(platformName instanceof String)) {
            throw new StepFailedException(MessageFormat.format(StringConstants.DRI_MISSING_PROPERTY_X_FOR_APPIUM_REMOTE_WEB_DRIVER, APPIUM_CAPABILITY_PLATFORM_NAME));
        }
        if (APPIUM_CAPABILITY_PLATFORM_NAME_ADROID.equalsIgnoreCase((String)platformName)) {
            return new SwipeableAndroidDriver(executor, (Capabilities)WebDriverPropertyUtil.toDesireCapabilities(driverPreferenceProps, DesiredCapabilities.android(), false));
        }
        if (APPIUM_CAPABILITY_PLATFORM_NAME_IOS.equalsIgnoreCase((String)platformName)) {
            return new IOSDriver(executor, (Capabilities)WebDriverPropertyUtil.toDesireCapabilities(driverPreferenceProps, DesiredCapabilities.iphone(), false));
        }
        throw new StepFailedException(MessageFormat.format(StringConstants.DRI_PLATFORM_NAME_X_IS_NOT_SUPPORTED_FOR_APPIUM_REMOTE_WEB_DRIVER, platformName));
    }

    private static HttpCommandExecutor getExecutorForRemoteDriver(String remoteWebServerUrl) throws URISyntaxException, IOException, GeneralSecurityException {
        URL url = new URL(remoteWebServerUrl);
        ProxyInformation proxyInfo = RunConfiguration.getProxyInformation();
        HttpClientBuilder clientBuilder = HttpClientProxyBuilder.create((ProxyInformation)proxyInfo).getClientBuilder();
        HttpClient.Factory clientFactory = DriverFactory.getClientFactoryForRemoteDriverExecutor(clientBuilder);
        HttpCommandExecutor executor = new HttpCommandExecutor(new HashMap(), url, clientFactory);
        return executor;
    }

    private static HttpClient.Factory getClientFactoryForRemoteDriverExecutor(final HttpClientBuilder clientBuilder) {
        return new HttpClient.Factory(){

            public HttpClient createClient(URL url) {
                return new ApacheHttpClient((org.apache.http.client.HttpClient)clientBuilder.build(), url);
            }
        };
    }

    private static WebDriver createNewRemoteChromeDriver(DesiredCapabilities desireCapibilities) throws MalformedURLException, IOException, Exception {
        String chromeDebugHost = RunConfiguration.getDriverSystemProperty((String)WEB_UI_DRIVER_PROPERTY, (String)DEBUG_HOST, (String)DEFAULT_DEBUG_HOST);
        String chromeDebugPort = RunConfiguration.getDriverSystemProperty((String)WEB_UI_DRIVER_PROPERTY, (String)DEBUG_PORT, (String)DEFAULT_CHROME_DEBUG_PORT);
        System.setProperty(CHROME_DRIVER_PATH_PROPERTY_KEY, DriverFactory.getChromeDriverPath());
        desireCapibilities.merge((Capabilities)DesiredCapabilities.chrome());
        HashMap<String, String> chromeOptions = new HashMap<String, String>();
        chromeOptions.put("debuggerAddress", String.valueOf(chromeDebugHost) + ":" + chromeDebugPort);
        desireCapibilities.setCapability("goog:chromeOptions", chromeOptions);
        int chromeDriverPort = DriverFactory.determineNextFreePort(9515);
        URL chromeDriverUrl = new URL("http", chromeDebugHost, chromeDriverPort, "/");
        Runtime.getRuntime().exec(new String[]{System.getProperty(CHROME_DRIVER_PATH_PROPERTY_KEY), "--port=" + chromeDriverPort});
        DriverFactory.waitForRemoteBrowserReady(chromeDriverUrl);
        return new RemoteWebDriver(chromeDriverUrl, (Capabilities)desireCapibilities);
    }

    private static WebDriver createNewRemoteFirefoxDriver(DesiredCapabilities desireCapibilities) throws MalformedURLException, Exception {
        String fireFoxDebugHost = RunConfiguration.getDriverSystemProperty((String)WEB_UI_DRIVER_PROPERTY, (String)DEBUG_HOST, (String)DEFAULT_DEBUG_HOST);
        String firefoxDebugPort = RunConfiguration.getDriverSystemProperty((String)WEB_UI_DRIVER_PROPERTY, (String)DEBUG_PORT, (String)DEFAULT_FIREFOX_DEBUG_PORT);
        desireCapibilities.merge((Capabilities)DesiredCapabilities.firefox());
        URL firefoxDriverUrl = new URL("http", fireFoxDebugHost, Integer.parseInt(firefoxDebugPort), "/hub");
        RemoteWebDriver webDriver = new RemoteWebDriver(firefoxDriverUrl, (Capabilities)desireCapibilities);
        DriverFactory.waitForRemoteBrowserReady(firefoxDriverUrl);
        return webDriver;
    }

    private static WebDriver createNewEdgeDriver(Map<String, Object> driverPreferenceProps) throws IOException {
        EdgeDriverService edgeService = localEdgeDriverServiceStorage.get();
        if (!edgeService.isRunning()) {
            edgeService.start();
        }
        DesiredCapabilities desiredCapabilities = WebDriverPropertyUtil.toDesireCapabilities(driverPreferenceProps, DesiredCapabilities.edge(), false);
        desiredCapabilities.setCapability("proxy", DriverFactory.getDefaultProxy());
        return new CEdgeDriver(edgeService, (Capabilities)desiredCapabilities, DriverFactory.getActionDelay());
    }

    private static WebDriver createNewIEDriver(DesiredCapabilities desireCapibilities) {
        desireCapibilities.setCapability(CAP_IE_USE_PER_PROCESS_PROXY, "true");
        if (!WebDriverProxyUtil.isNoProxy(RunConfiguration.getProxyInformation())) {
            desireCapibilities.setCapability("proxy", DriverFactory.getDefaultProxy());
        }
        ieDriverService = (InternetExplorerDriverService)((InternetExplorerDriverService.Builder)((InternetExplorerDriverService.Builder)new InternetExploreDriverServiceBuilder().withLogLevel(InternetExplorerDriverLogLevel.TRACE).usingDriverExecutable(new File(DriverFactory.getIEDriverPath()))).withLogFile(new File(String.valueOf(RunConfiguration.getLogFolderPath()) + File.separator + IE_DRIVER_SERVER_LOG_FILE_NAME))).build();
        return new CInternetExplorerDriver(ieDriverService, (Capabilities)desireCapibilities, DriverFactory.getActionDelay());
    }

    private static WebDriver createNewFirefoxDriver(DesiredCapabilities desiredCapabilities) {
        int actionDelay = DriverFactory.getActionDelay();
        int firefoxMajorVersion = FirefoxExecutable.getFirefoxVersion(desiredCapabilities);
        desiredCapabilities.setCapability("proxy", DriverFactory.getDefaultProxy());
        if (firefoxMajorVersion >= 57) {
            return CGeckoDriver.from(desiredCapabilities, actionDelay);
        }
        if (firefoxMajorVersion >= 47) {
            return CFirefoxDriver47.from(desiredCapabilities, actionDelay);
        }
        return new CFirefoxDriver((Capabilities)desiredCapabilities, actionDelay);
    }

    private static WebDriver createHeadlessFirefoxDriver(DesiredCapabilities desiredCapibilities) {
        FirefoxOptions firefoxOptions = new FirefoxOptions((Capabilities)desiredCapibilities);
        firefoxOptions.setHeadless(true);
        return DriverFactory.createNewFirefoxDriver(new DesiredCapabilities(firefoxOptions.asMap()));
    }

    private static void saveWebDriverSessionData(WebDriver webDriver) {
        block21: {
            if (!(webDriver instanceof RemoteWebDriver) || webDriver instanceof ExistingRemoteWebDriver || webDriver instanceof SafariDriver) {
                return;
            }
            RemoteWebDriver remoteWebDriver = (RemoteWebDriver)webDriver;
            Socket myClient = null;
            PrintStream output = null;
            try {
                try {
                    myClient = new Socket(RunConfiguration.getSessionServerHost(), RunConfiguration.getSessionServerPort());
                    output = new PrintStream(myClient.getOutputStream());
                    output.println(remoteWebDriver.getSessionId());
                    output.println(DriverFactory.getWebDriverServerUrl(remoteWebDriver));
                    DriverType remoteDriverType = DriverFactory.getExecutedBrowser();
                    output.println(remoteDriverType);
                    output.println(RunConfiguration.getLogFolderPath());
                    if (remoteDriverType == WebUIDriverType.ANDROID_DRIVER) {
                        output.println(String.valueOf(WebMobileDriverFactory.getDeviceManufacturer()) + " " + WebMobileDriverFactory.getDeviceModel() + " " + WebMobileDriverFactory.getDeviceOSVersion());
                    } else if (remoteDriverType == WebUIDriverType.IOS_DRIVER) {
                        output.println(String.valueOf(WebMobileDriverFactory.getDeviceName()) + " " + WebMobileDriverFactory.getDeviceOSVersion());
                    }
                    output.flush();
                }
                catch (Exception exception) {
                    if (myClient != null) {
                        try {
                            myClient.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (output != null) {
                        output.close();
                    }
                    break block21;
                }
            }
            catch (Throwable throwable) {
                if (myClient != null) {
                    try {
                        myClient.close();
                    }
                    catch (IOException iOException) {}
                }
                if (output != null) {
                    output.close();
                }
                throw throwable;
            }
            if (myClient != null) {
                try {
                    myClient.close();
                }
                catch (IOException iOException) {}
            }
            if (output != null) {
                output.close();
            }
        }
    }

    public static String getWebDriverServerUrl(RemoteWebDriver remoteWebDriver) {
        CommandExecutor commandExecutor = remoteWebDriver.getCommandExecutor();
        if (commandExecutor instanceof HttpCommandExecutor) {
            return ((HttpCommandExecutor)commandExecutor).getAddressOfRemoteServer().toString();
        }
        if (commandExecutor instanceof ExtensionConnection) {
            return ((ExtensionConnection)commandExecutor).getAddressOfRemoteServer().toString();
        }
        return "";
    }

    protected static WebDriver startExistingBrowser() throws MalformedURLException, MobileDriverInitializeException, ConnectException {
        String remoteDriverType = RunConfiguration.getExisingSessionDriverType();
        String sessionId = RunConfiguration.getExisingSessionSessionId();
        String remoteServerUrl = RunConfiguration.getExisingSessionServerUrl();
        if (WebUIDriverType.ANDROID_DRIVER.toString().equals(remoteDriverType) || WebUIDriverType.IOS_DRIVER.toString().equals(remoteDriverType)) {
            return WebMobileDriverFactory.startExisitingMobileDriver(WebUIDriverType.fromStringValue(remoteDriverType), sessionId, remoteServerUrl);
        }
        return new ExistingRemoteWebDriver(new URL(remoteServerUrl), sessionId);
    }

    private static void logBrowserRunData(WebDriver webDriver) {
        if (webDriver == null) {
            return;
        }
        logger.logRunData("sessionId", ((RemoteWebDriver)webDriver).getSessionId().toString());
        logger.logRunData("browser", DriverFactory.getBrowserVersion(webDriver));
        logger.logRunData("platform", webDriver.getClass() == RemoteWebDriver.class ? ((RemoteWebDriver)webDriver).getCapabilities().getPlatform().toString() : System.getProperty("os.name"));
        logger.logRunData("seleniumVersion", new BuildInfo().getReleaseLabel());
        logger.logRunData("proxyInformation", RunConfiguration.getProxyInformation().toString());
    }

    private static String getBrowserVersion(WebDriver webDriver) {
        try {
            return WebUiCommonHelper.getBrowserAndVersion(webDriver);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static WebDriver openWebDriver(DriverType driver, Object options) throws Exception {
        block12: {
            try {
                if (driver instanceof WebUIDriverType) break block12;
                return null;
            }
            catch (Error e) {
                logger.logMessage(LogLevel.WARNING, e.getMessage());
                throw new StepFailedException((Throwable)e);
            }
        }
        DriverFactory.closeWebDriver();
        CSafariDriver webDriver = null;
        WebUIDriverType webUIDriver = (WebUIDriverType)driver;
        switch (webUIDriver) {
            case FIREFOX_DRIVER: {
                if (options instanceof FirefoxProfile) {
                    DesiredCapabilities desiredCapabilities = DesiredCapabilities.firefox();
                    desiredCapabilities.setCapability("firefox_profile", (Object)((FirefoxProfile)options));
                    webDriver = DriverFactory.createNewFirefoxDriver(desiredCapabilities);
                    break;
                }
                if (options instanceof DesiredCapabilities) {
                    System.setProperty("webdriver.gecko.driver", DriverFactory.getGeckoDriverPath());
                    webDriver = new CFirefoxDriver(GeckoDriverService.createDefaultService(), (Capabilities)((DesiredCapabilities)options));
                    break;
                }
                webDriver = new CFirefoxDriver((Capabilities)DesiredCapabilities.firefox(), DriverFactory.getActionDelay());
                break;
            }
            case IE_DRIVER: {
                System.setProperty(IE_DRIVER_PATH_PROPERTY_KEY, DriverFactory.getIEDriverPath());
                if (options instanceof DesiredCapabilities) {
                    webDriver = new InternetExplorerDriver(new InternetExplorerOptions((Capabilities)options));
                    break;
                }
                webDriver = new InternetExplorerDriver();
                break;
            }
            case SAFARI_DRIVER: {
                if (!(options instanceof DesiredCapabilities)) break;
                webDriver = DriverFactory.createNewSafariDriver((DesiredCapabilities)options);
                break;
            }
            case CHROME_DRIVER: {
                System.setProperty(CHROME_DRIVER_PATH_PROPERTY_KEY, DriverFactory.getChromeDriverPath());
                if (!(options instanceof DesiredCapabilities)) break;
                ChromeDriver chromeDriver = new ChromeDriver((Capabilities)((DesiredCapabilities)options));
                return chromeDriver;
            }
            default: {
                throw new StepFailedException(MessageFormat.format(StringConstants.DRI_ERROR_DRIVER_X_NOT_IMPLEMENTED, driver.getName()));
            }
        }
        localWebServerStorage.set((WebDriver)webDriver);
        DriverFactory.setTimeout();
        return webDriver;
    }

    private static void setTimeout() {
        WebDriver webDriver = localWebServerStorage.get();
        if (webDriver instanceof EdgeDriver) {
            return;
        }
        WebDriver.Timeouts timeouts = webDriver.manage().timeouts();
        timeouts.implicitlyWait(0L, TimeUnit.SECONDS);
        if (DriverFactory.isEnablePageLoadTimeout()) {
            timeouts.pageLoadTimeout((long)DriverFactory.getDefaultPageLoadTimeout(), TimeUnit.SECONDS);
        }
    }

    /*
     * Unable to fully structure code
     */
    public static WebDriver getWebDriver() throws StepFailedException, WebDriverException {
        block4: {
            try {
                DriverFactory.verifyWebDriver();
                break block4;
            }
            catch (BrowserNotOpenedException e) {
                var4_1 = RunConfiguration.getStoredDrivers();
                var3_2 = var4_1.length;
                var2_3 = 0;
                ** while (var2_3 < var3_2)
            }
lbl-1000:
            // 1 sources

            {
                driverObject = var4_1[var2_3];
                if (driverObject instanceof RemoteWebDriver) {
                    return (RemoteWebDriver)driverObject;
                }
                ++var2_3;
                continue;
            }
lbl14:
            // 1 sources

            throw e;
        }
        return DriverFactory.localWebServerStorage.get();
    }

    private static void verifyWebDriver() throws StepFailedException, WebDriverException {
        block3: {
            DriverFactory.startExistingBrowserIfPossible();
            DriverFactory.verifyWebDriverIsOpen();
            try {
                if (((RemoteWebDriver)localWebServerStorage.get()).getSessionId() == null) {
                    DriverFactory.switchToAvailableWindow();
                }
            }
            catch (WebDriverException e) {
                if (e instanceof NoSuchWindowException || e.getMessage() == null || e.getMessage().startsWith(JAVA_SCRIPT_ERROR_H_IS_NULL_MESSAGE)) break block3;
                throw e;
            }
        }
    }

    private static void verifyWebDriverIsOpen() throws WebDriverException {
        if (localWebServerStorage.get() == null) {
            throw new BrowserNotOpenedException();
        }
    }

    public static Alert getAlert() throws WebDriverException {
        DriverFactory.startExistingBrowserIfPossible();
        DriverFactory.verifyWebDriverIsOpen();
        Alert alert = null;
        if (DriverFactory.getExecutedBrowser() == WebUIDriverType.IE_DRIVER) {
            final WebDriver ieDriver = localWebServerStorage.get();
            Thread ieSafeThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        try {
                            ieDriver.switchTo().alert();
                        }
                        catch (Exception e) {
                            if (!(e instanceof NoSuchWindowException) && e.getMessage() != null && !e.getMessage().startsWith(DriverFactory.JAVA_SCRIPT_ERROR_H_IS_NULL_MESSAGE)) {
                                throw e;
                            }
                            DriverFactory.switchToAvailableWindow();
                            ieDriver.switchTo().alert();
                        }
                    }
                    catch (WebDriverException webDriverException) {}
                }
            });
            ieSafeThread.start();
            float count = 0.0f;
            while (ieSafeThread.isAlive()) {
                if (count > (float)DriverFactory.getWaitForIEHanging()) {
                    ieSafeThread.interrupt();
                    throw new StepFailedException(MessageFormat.format(StringConstants.DRI_MSG_UNABLE_REACH_WEB_DRI_TIMEOUT, RunConfiguration.getTimeOut()));
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
                count = (float)((double)count + 0.1);
            }
        }
        try {
            try {
                alert = localWebServerStorage.get().switchTo().alert();
            }
            catch (Exception e) {
                if (!(e instanceof NoSuchWindowException) && e.getMessage() != null && !e.getMessage().startsWith(JAVA_SCRIPT_ERROR_H_IS_NULL_MESSAGE)) {
                    throw e;
                }
                DriverFactory.switchToAvailableWindow();
                alert = localWebServerStorage.get().switchTo().alert();
            }
            return alert;
        }
        catch (NoAlertPresentException noAlertPresentException) {
            return null;
        }
    }

    public static boolean waitForAlert(int timeOut) {
        DriverFactory.startExistingBrowserIfPossible();
        DriverFactory.verifyWebDriverIsOpen();
        float count = 0.0f;
        long miliseconds = System.currentTimeMillis();
        while (count < (float)timeOut) {
            Alert alert = DriverFactory.getAlert();
            if (alert != null) {
                return true;
            }
            count += (float)((System.currentTimeMillis() - miliseconds) / 1000L);
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
            count = (float)((double)count + 0.5);
            miliseconds = System.currentTimeMillis();
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public static void switchToAvailableWindow() {
        block6: {
            DriverFactory.startExistingBrowserIfPossible();
            DriverFactory.verifyWebDriverIsOpen();
            try {
                DriverFactory.localWebServerStorage.get().switchTo().window("");
                break block6;
            }
            catch (WebDriverException e) {
                if (!(e instanceof NoSuchWindowException) && e.getMessage() != null && !e.getMessage().startsWith("[JavaScript Error: \"h is null\"")) {
                    throw e;
                }
                availableWindows = DriverFactory.localWebServerStorage.get().getWindowHandles();
                ** for (windowId : availableWindows)
            }
lbl-1000:
            // 1 sources

            {
                try {
                    DriverFactory.localWebServerStorage.get().switchTo().window(windowId);
                    return;
                }
                catch (WebDriverException exception) {
                    if (exception instanceof NoSuchWindowException || e.getMessage() == null || exception.getMessage().startsWith("[JavaScript Error: \"h is null\"")) continue;
                    throw exception;
                }
            }
        }
    }

    public static int getCurrentWindowIndex() {
        DriverFactory.startExistingBrowserIfPossible();
        DriverFactory.verifyWebDriverIsOpen();
        String currentWindowHandle = localWebServerStorage.get().getWindowHandle();
        Set availableWindowHandles = localWebServerStorage.get().getWindowHandles();
        int count = 0;
        for (String windowHandle : availableWindowHandles) {
            if (windowHandle.equals(currentWindowHandle)) {
                return count;
            }
            ++count;
        }
        throw new StepFailedException(StringConstants.XML_LOG_ERROR_CANNOT_FOUND_WINDOW_HANDLE);
    }

    private static void startExistingBrowserIfPossible() {
        if (DriverFactory.isUsingExistingDriver() && localWebServerStorage.get() == null) {
            try {
                WebDriver webDriver = DriverFactory.startExistingBrowser();
                DriverFactory.changeWebDriver(webDriver);
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (ConnectException connectException) {
            }
            catch (MobileDriverInitializeException mobileDriverInitializeException) {}
        }
    }

    private static String getIEDriverPath() {
        return RunConfiguration.getDriverSystemProperty((String)WEB_UI_DRIVER_PROPERTY, (String)IE_DRIVER_PATH_PROPERTY);
    }

    private static String getEdgeDriverPath() {
        return RunConfiguration.getDriverSystemProperty((String)WEB_UI_DRIVER_PROPERTY, (String)EDGE_DRIVER_PATH_PROPERTY);
    }

    public static String getChromeDriverPath() {
        return RunConfiguration.getDriverSystemProperty((String)WEB_UI_DRIVER_PROPERTY, (String)CHROME_DRIVER_PATH_PROPERTY);
    }

    public static String getGeckoDriverPath() {
        return RunConfiguration.getDriverSystemProperty((String)WEB_UI_DRIVER_PROPERTY, (String)"geckoDriverPath");
    }

    private static int getWaitForIEHanging() {
        if (DriverFactory.getExecutedBrowser() != WebUIDriverType.IE_DRIVER) {
            throw new IllegalArgumentException(StringConstants.XML_LOG_ERROR_BROWSER_NOT_IE);
        }
        return Integer.parseInt(RunConfiguration.getDriverSystemProperty((String)WEB_UI_DRIVER_PROPERTY, (String)WAIT_FOR_IE_HANGING_PROPERTY));
    }

    public static boolean isEnablePageLoadTimeout() {
        return RunConfiguration.getBooleanProperty((String)ENABLE_PAGE_LOAD_TIMEOUT, (Map)RunConfiguration.getExecutionGeneralProperties());
    }

    public static int getDefaultPageLoadTimeout() {
        return RunConfiguration.getIntProperty((String)DEFAULT_PAGE_LOAD_TIMEOUT, (Map)RunConfiguration.getExecutionGeneralProperties());
    }

    public static int getActionDelay() {
        if (actionDelay == -1) {
            actionDelay = 0;
            Map executionGeneralProperties = RunConfiguration.getExecutionGeneralProperties();
            if (executionGeneralProperties.containsKey(ACTION_DELAY)) {
                actionDelay = RunConfiguration.getIntProperty((String)ACTION_DELAY, (Map)executionGeneralProperties);
            }
            if (RunConfiguration.getPort() > 0) {
                logger.logInfo(MessageFormat.format(CoreWebuiMessageConstants.KW_MSG_ACTION_DELAY_X, actionDelay));
            }
        }
        return actionDelay;
    }

    public static boolean isIgnorePageLoadTimeoutException() {
        return RunConfiguration.getBooleanProperty((String)IGNORE_PAGE_LOAD_TIMEOUT_EXCEPTION, (Map)RunConfiguration.getExecutionGeneralProperties());
    }

    public static DriverType getExecutedBrowser() {
        WebUIDriverType webDriverType = null;
        if (DriverFactory.isUsingExistingDriver()) {
            webDriverType = WebUIDriverType.fromStringValue(RunConfiguration.getExisingSessionDriverType());
        }
        if (webDriverType != null) {
            return webDriverType;
        }
        String driverTypeString = RunConfiguration.getDriverSystemProperty((String)WEB_UI_DRIVER_PROPERTY, (String)EXECUTED_BROWSER_PROPERTY);
        if (driverTypeString != null) {
            webDriverType = WebUIDriverType.valueOf(driverTypeString);
        }
        if (webDriverType == null && RunConfiguration.getDriverSystemProperty((String)MOBILE_DRIVER_PROPERTY, (String)"devicePlatform") != null) {
            webDriverType = WebUIDriverType.valueOf(RunConfiguration.getDriverSystemProperty((String)MOBILE_DRIVER_PROPERTY, (String)"devicePlatform"));
        }
        return webDriverType;
    }

    public static String getRemoteWebDriverServerUrl() {
        return RunConfiguration.getDriverSystemProperty((String)WEB_UI_DRIVER_PROPERTY, (String)REMOTE_WEB_DRIVER_URL);
    }

    public static String getRemoteWebDriverServerType() {
        return RunConfiguration.getDriverSystemProperty((String)WEB_UI_DRIVER_PROPERTY, (String)REMOTE_WEB_DRIVER_TYPE);
    }

    public static void closeWebDriver() {
        WebDriver webDriver;
        block9: {
            DriverFactory.startExistingBrowserIfPossible();
            DriverType driverType = DriverFactory.getExecutedBrowser();
            if (driverType == WebUIDriverType.IE_DRIVER) {
                DriverFactory.quitIE();
                return;
            }
            webDriver = localWebServerStorage.get();
            if (webDriver != null && ((RemoteWebDriver)webDriver).getSessionId() != null) {
                try {
                    webDriver.quit();
                    if (!(driverType instanceof WebUIDriverType)) break block9;
                    switch ((WebUIDriverType)driverType) {
                        case ANDROID_DRIVER: 
                        case IOS_DRIVER: {
                            WebMobileDriverFactory.closeDriver();
                            break;
                        }
                        case EDGE_DRIVER: {
                            EdgeDriverService edgeDriverService = localEdgeDriverServiceStorage.get();
                            if (edgeDriverService.isRunning()) {
                                edgeDriverService.stop();
                            }
                            break;
                        }
                        default: {
                            break;
                        }
                    }
                }
                catch (UnreachableBrowserException unreachableBrowserException) {
                    logger.logWarning(StringConstants.DRI_LOG_WARNING_BROWSER_NOT_REACHABLE);
                }
            }
        }
        localWebServerStorage.set(null);
        RunConfiguration.removeDriver((Object)webDriver);
    }

    private static void quitIE() {
        try {
            WebDriver webDriver = localWebServerStorage.get();
            if (webDriver != null && ((RemoteWebDriver)webDriver).getSessionId() != null) {
                webDriver.quit();
            }
        }
        catch (UnreachableBrowserException unreachableBrowserException) {}
        DriverFactory.quitIEDriverServer();
    }

    private static void quitIEDriverServer() {
        if (ieDriverService == null) {
            return;
        }
        ieDriverService.stop();
    }

    private static void waitForRemoteBrowserReady(URL url) throws Exception {
        long waitUntil = System.currentTimeMillis() + 60000L;
        boolean connectable = false;
        while (!connectable) {
            try {
                url.openConnection().connect();
                connectable = true;
            }
            catch (IOException iOException) {}
            if (waitUntil < System.currentTimeMillis()) {
                throw new Exception(String.format("Unable to connect to browser on host %s and port %s after %s seconds.", url.getHost(), url.getPort(), 60000));
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * Unable to fully structure code
     */
    private static int determineNextFreePort(int port) {
        networkUtils = new NetworkUtils();
        newport = port;
        while (newport < port + 2000) {
            block13: {
                address = new InetSocketAddress(networkUtils.obtainLoopbackIp4Address(), newport);
                socket = null;
                socket = new Socket();
                socket.bind(address);
                var6_5 = newport;
                if (socket == null) break block13;
                try {
                    socket.close();
                }
                catch (IOException v0) {}
            }
            return var6_5;
            catch (IOException v1) {
                try {
                    ** if (socket == null) goto lbl-1000
                }
                catch (Throwable var5_6) {
                    if (socket != null) {
                        try {
                            socket.close();
                        }
                        catch (IOException v3) {}
                    }
                    throw var5_6;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        socket.close();
                    }
                    catch (IOException v2) {}
                }
lbl-1000:
                // 2 sources

                {
                }
            }
            ++newport;
        }
        throw new WebDriverException(String.format("Cannot find free port in the range %d to %d ", new Object[]{port, newport}));
    }
}

