/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.webui.common;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonReader;
import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.exception.StepFailedException;
import com.kms.katalon.core.helper.KeywordHelper;
import com.kms.katalon.core.logging.KeywordLogger;
import com.kms.katalon.core.testobject.ConditionType;
import com.kms.katalon.core.testobject.SelectorMethod;
import com.kms.katalon.core.testobject.TestObject;
import com.kms.katalon.core.testobject.TestObjectProperty;
import com.kms.katalon.core.testobject.TestObjectXpath;
import com.kms.katalon.core.util.internal.ExceptionsUtil;
import com.kms.katalon.core.webui.common.XPathBuilder;
import com.kms.katalon.core.webui.common.internal.BrokenTestObject;
import com.kms.katalon.core.webui.common.internal.BrokenTestObjects;
import com.kms.katalon.core.webui.constants.CoreWebuiMessageConstants;
import com.kms.katalon.core.webui.constants.StringConstants;
import com.kms.katalon.core.webui.driver.DriverFactory;
import com.kms.katalon.core.webui.exception.WebElementNotFoundException;
import java.awt.Rectangle;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchWindowException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Select;

public class WebUiCommonHelper
extends KeywordHelper {
    private static final KeywordLogger logger = KeywordLogger.getInstance(WebUiCommonHelper.class);
    public static final String CSS_LOCATOR_PROPERTY_NAME = "css";
    public static final String XPATH_LOCATOR_PROPERTY_NAME = "xpath";
    public static final String WEB_ELEMENT_TAG = "tag";
    public static final String WEB_ELEMENT_ATTRIBUTE_LINK_TEXT = "link_text";
    public static final String WEB_ELEMENT_ATTRIBUTE_TEXT = "text";
    public static final String WEB_ELEMENT_XPATH = "xpath";

    public static boolean isTextPresent(WebDriver webDriver, String text, boolean isRegex) throws WebDriverException, IllegalArgumentException {
        String regularExpressionLog = isRegex ? " using regular expression" : "";
        logger.logDebug(MessageFormat.format(StringConstants.COMM_EXC_CHECKING_TEXT_PRESENT, regularExpressionLog));
        if (text == null) {
            throw new IllegalArgumentException(StringConstants.COMM_EXC_TEXT_IS_NULL);
        }
        boolean isContained = false;
        WebElement bodyElement = webDriver.findElement(By.tagName((String)"body"));
        String pageText = bodyElement.getText();
        logger.logDebug(MessageFormat.format(StringConstants.COMM_LOG_INFO_FINDING_TEXT_ON_PAGE, text, regularExpressionLog));
        if (pageText != null && !pageText.isEmpty()) {
            if (isRegex) {
                Pattern pattern = Pattern.compile(text);
                Matcher matcher = pattern.matcher(pageText);
                if (matcher.find()) {
                    isContained = true;
                }
            } else {
                isContained = pageText.contains(text);
            }
        }
        return isContained;
    }

    public static boolean switchToWindowUsingTitle(WebDriver webDriver, String title, int timeOutInSeconds) throws WebDriverException, InterruptedException {
        float timeCount = 0.0f;
        while (timeCount < (float)timeOutInSeconds) {
            Set availableWindows = webDriver.getWindowHandles();
            for (String windowId : availableWindows) {
                if (!(webDriver = webDriver.switchTo().window(windowId)).getTitle().equals(title)) continue;
                return true;
            }
            Thread.sleep(200L);
            timeCount = (float)((double)timeCount + 0.2);
        }
        return false;
    }

    public static boolean closeWindowUsingTitle(WebDriver webDriver, String title) throws InterruptedException {
        float timeCount = 0.0f;
        while (timeCount < (float)RunConfiguration.getTimeOut()) {
            Set availableWindows = webDriver.getWindowHandles();
            for (String windowId : availableWindows) {
                if (!(webDriver = webDriver.switchTo().window(windowId)).getTitle().equals(title)) continue;
                webDriver.close();
                return true;
            }
            Thread.sleep(200L);
            timeCount = (float)((double)timeCount + 0.2);
        }
        return false;
    }

    public static boolean switchToWindowUsingUrl(WebDriver webDriver, String url) throws InterruptedException {
        float timeCount = 0.0f;
        while (timeCount < (float)RunConfiguration.getTimeOut()) {
            Set availableWindows = webDriver.getWindowHandles();
            for (String windowId : availableWindows) {
                if (!webDriver.switchTo().window(windowId).getCurrentUrl().equals(url)) continue;
                return true;
            }
            Thread.sleep(200L);
            timeCount = (float)((double)timeCount + 0.2);
        }
        return false;
    }

    public static boolean closeWindowUsingUrl(WebDriver webDriver, String url) throws InterruptedException {
        float timeCount = 0.0f;
        while (timeCount < (float)RunConfiguration.getTimeOut()) {
            Set availableWindows = webDriver.getWindowHandles();
            for (String windowId : availableWindows) {
                if (!webDriver.switchTo().window(windowId).getCurrentUrl().equals(url)) continue;
                webDriver.close();
                return true;
            }
            Thread.sleep(200L);
            timeCount = (float)((double)timeCount + 0.2);
        }
        return false;
    }

    public static boolean switchToWindowUsingIndex(WebDriver webDriver, int index) throws InterruptedException {
        float timeCount = 0.0f;
        while (timeCount < (float)RunConfiguration.getTimeOut()) {
            ArrayList availableWindows = new ArrayList(webDriver.getWindowHandles());
            if (index >= 0 && index < availableWindows.size()) {
                webDriver.switchTo().window((String)availableWindows.get(index));
                return true;
            }
            Thread.sleep(200L);
            timeCount = (float)((double)timeCount + 0.2);
        }
        return false;
    }

    public static boolean closeWindowUsingIndex(WebDriver webDriver, int index) throws InterruptedException {
        float timeCount = 0.0f;
        while (timeCount < (float)RunConfiguration.getTimeOut()) {
            ArrayList availableWindows = new ArrayList(webDriver.getWindowHandles());
            if (index >= 0 && index < availableWindows.size()) {
                webDriver.switchTo().window((String)availableWindows.get(index));
                webDriver.close();
                return true;
            }
            Thread.sleep(200L);
            timeCount = (float)((double)timeCount + 0.2);
        }
        return false;
    }

    public static void checkSelectIndex(Integer[] indexes, Select select) throws IllegalArgumentException {
        logger.logDebug(StringConstants.COMM_LOG_INFO_CHECKING_INDEX_PARAMS);
        List allSelectOptions = select.getOptions();
        if (allSelectOptions.size() > 0) {
            Integer[] integerArray = indexes;
            int n = indexes.length;
            int n2 = 0;
            while (n2 < n) {
                int index = integerArray[n2];
                if (index < 0 || index >= allSelectOptions.size()) {
                    throw new IllegalArgumentException(MessageFormat.format(StringConstants.COMM_EXC_INVALID_INDEX, index, allSelectOptions.size() - 1));
                }
                ++n2;
            }
        }
    }

    public static void selectOrDeselectAllOptions(Select select, boolean isSelect, TestObject to) {
        if (isSelect) {
            logger.logDebug(MessageFormat.format(StringConstants.KW_LOG_INFO_SELECTING_ALL_OPT_ON_OBJ, to.getObjectId()));
        } else {
            logger.logDebug(MessageFormat.format(StringConstants.KW_LOG_INFO_DESELECTING_ALL_OPTS_ON_OBJ, to.getObjectId()));
        }
        int index = 0;
        while (index < select.getOptions().size()) {
            if (isSelect) {
                select.selectByIndex(index);
                logger.logDebug(MessageFormat.format(StringConstants.KW_LOG_INFO_OPT_W_INDEX_X_IS_SELECTED, index));
            } else {
                select.deselectByIndex(index);
                logger.logDebug(MessageFormat.format(StringConstants.KW_LOG_INFO_DESELECTED_OPT_IDX_X, index));
            }
            ++index;
        }
    }

    public static void selectOrDeselectOptionsByIndex(Select select, Integer[] indexes, boolean isSelect, TestObject to) {
        WebUiCommonHelper.checkSelectIndex(indexes, select);
        if (isSelect) {
            logger.logDebug(MessageFormat.format(StringConstants.KW_LOG_INFO_SELECTING_OBJ_OPTS_W_INDEX_IN, to.getObjectId(), WebUiCommonHelper.integerArrayToString((Integer[])indexes)));
        } else {
            logger.logDebug(MessageFormat.format(StringConstants.KW_LOG_INFO_DESELECTING_OPTS_ON_OBJ_W_IDX, to.getObjectId(), WebUiCommonHelper.integerArrayToString((Integer[])indexes)));
        }
        Integer[] integerArray = indexes;
        int n = indexes.length;
        int n2 = 0;
        while (n2 < n) {
            int index = integerArray[n2];
            if (isSelect) {
                select.selectByIndex(index);
                logger.logDebug(MessageFormat.format(StringConstants.KW_LOG_INFO_OPT_W_INDEX_X_IS_SELECTED, index));
            } else {
                select.deselectByIndex(index);
                logger.logDebug(MessageFormat.format(StringConstants.KW_LOG_INFO_DESELECTED_OPT_IDX_X, index));
            }
            ++n2;
        }
    }

    public static boolean selectOrDeselectOptionsByValue(Select select, String value, boolean isRegex, boolean isSelect, TestObject to, String regularExpressionLog) {
        if (isSelect) {
            logger.logDebug(MessageFormat.format(StringConstants.KW_LOG_INFO_SELECTING_OPTS_ON_OBJ_X_W_VAL_Y, to.getObjectId(), value, regularExpressionLog));
        } else {
            logger.logDebug(MessageFormat.format(StringConstants.KW_LOG_INFO_DESELECTING_OPTS_ON_OBJ_W_VAL, to.getObjectId(), value, regularExpressionLog));
        }
        if (isRegex) {
            return WebUiCommonHelper.selectOrDeselectOptionsByValueByRegularExpression(select, value, isSelect, regularExpressionLog);
        }
        if (isSelect) {
            select.selectByValue(value);
        } else {
            select.deselectByValue(value);
        }
        return true;
    }

    private static boolean selectOrDeselectOptionsByValueByRegularExpression(Select select, String value, boolean isSelect, String regularExpressionLog) {
        List allOptions = select.getOptions();
        boolean isMatched = false;
        int index = 0;
        while (index < allOptions.size()) {
            String optionValue = ((WebElement)allOptions.get(index)).getAttribute("value");
            if (optionValue != null && WebUiCommonHelper.match((String)optionValue, (String)value, (boolean)true)) {
                if (isSelect) {
                    select.selectByIndex(index);
                    logger.logDebug(MessageFormat.format(StringConstants.KW_LOG_INFO_SELECTED_OPT_AT_INDEX_W_VAL, index, optionValue, regularExpressionLog));
                } else {
                    select.deselectByIndex(index);
                    logger.logDebug(MessageFormat.format(StringConstants.KW_LOG_INFO_OPT_AT_IDX_X_W_VAL_Y_IS_SELECTED, index, optionValue, regularExpressionLog));
                }
                isMatched = true;
            }
            ++index;
        }
        return isMatched;
    }

    public static boolean selectOrDeselectOptionsByLabel(Select select, String label, boolean isRegex, boolean isSelect, TestObject to, String regularExpressionLog) {
        if (isSelect) {
            logger.logDebug(MessageFormat.format(StringConstants.KW_LOG_INFO_SELECTING_OPTS_ON_OBJ_X_W_LBL_Y, to.getObjectId(), label, regularExpressionLog));
        } else {
            logger.logDebug(MessageFormat.format(StringConstants.KW_LOG_INFO_DESELECTING_OPTS_ON_OBJ_X_W_LBL_Y, to.getObjectId(), label, regularExpressionLog));
        }
        if (isRegex) {
            return WebUiCommonHelper.selectOrDeselectOptionsByLabelWithRegularExpression(select, label, isSelect, regularExpressionLog);
        }
        if (isSelect) {
            select.selectByVisibleText(label);
        } else {
            select.deselectByVisibleText(label);
        }
        return true;
    }

    private static boolean selectOrDeselectOptionsByLabelWithRegularExpression(Select select, String label, boolean isSelect, String regularExpressionLog) {
        List allOptions = select.getOptions();
        boolean isMatched = false;
        int index = 0;
        while (index < allOptions.size()) {
            String optionValue = ((WebElement)allOptions.get(index)).getText();
            if (optionValue != null && WebUiCommonHelper.match((String)optionValue, (String)label, (boolean)true)) {
                if (isSelect) {
                    select.selectByIndex(index);
                    logger.logDebug(MessageFormat.format(StringConstants.KW_LOG_INFO_OPT_AT_IDX_X_W_LBL_TXT_Y_IS_SELECTED, index, optionValue, regularExpressionLog));
                } else {
                    select.deselectByIndex(index);
                    logger.logDebug(MessageFormat.format(StringConstants.KW_LOG_INFO_OPT_AT_IDX_X_W_LBL_TXT_Y_IS_DESELECTED, index, optionValue, regularExpressionLog));
                }
                isMatched = true;
            }
            ++index;
        }
        return isMatched;
    }

    public static int getNumberOfOptionByLabel(Select select, String label, boolean isRegex, String objectId) {
        int count = 0;
        String regularExpressionLog = isRegex ? " using regular expression" : "";
        logger.logDebug(MessageFormat.format(StringConstants.COMM_LOG_INFO_COUNTING_NUM_OPTS_W_LBL_PRESENT_ON_OBJ, label, objectId, regularExpressionLog));
        List allOptions = select.getOptions();
        int index = 0;
        while (index < allOptions.size()) {
            String optionLabel = ((WebElement)allOptions.get(index)).getText();
            if (optionLabel != null && KeywordHelper.match((String)optionLabel, (String)label, (boolean)isRegex)) {
                ++count;
                logger.logDebug(MessageFormat.format(StringConstants.COMM_LOG_INFO_OPT_AT_INDEX_W_LBL_IS_PRESENT, index, optionLabel, regularExpressionLog));
            }
            ++index;
        }
        return count;
    }

    public static int getNumberOfOptionByValue(Select select, String value, boolean isRegex, String objectId) {
        int count = 0;
        String regularExpressionLog = isRegex ? " using regular expression" : "";
        logger.logDebug(MessageFormat.format(StringConstants.COMM_LOG_INFO_COUNTING_NUM_OPTS_W_VAL_PRESENT_ON_OBJ, value, objectId, regularExpressionLog));
        List allOptions = select.getOptions();
        int index = 0;
        while (index < allOptions.size()) {
            String optionValue = ((WebElement)allOptions.get(index)).getAttribute("value");
            if (optionValue != null && KeywordHelper.match((String)optionValue, (String)value, (boolean)isRegex)) {
                ++count;
                logger.logDebug(MessageFormat.format(StringConstants.COMM_LOG_INFO_OPT_AT_INDEX_W_VAL_IS_PRESENT, index, optionValue, regularExpressionLog));
            }
            ++index;
        }
        return count;
    }

    public static int getNumberOfSelectedOptionByLabel(Select select, String label, boolean isRegex, String objectId) {
        int count = 0;
        String regularExpressionLog = isRegex ? " using regular expression" : "";
        logger.logDebug(MessageFormat.format(StringConstants.COMM_LOG_INFO_COUNTING_NUM_OPTS_W_LBL_SELECTED_ON_OBJ, label, objectId, regularExpressionLog));
        List allOptions = select.getOptions();
        List allSelectedOptions = select.getAllSelectedOptions();
        int index = 0;
        while (index < allOptions.size()) {
            String optionLabel = ((WebElement)allOptions.get(index)).getText();
            if (optionLabel != null && KeywordHelper.match((String)optionLabel, (String)label, (boolean)isRegex) && allSelectedOptions.contains(allOptions.get(index))) {
                ++count;
                logger.logDebug(MessageFormat.format(StringConstants.COMM_LOG_INFO_OPT_AT_INDEX_W_LBL_IS_SELECTED, index, optionLabel, regularExpressionLog));
            }
            ++index;
        }
        return count;
    }

    public static int getNumberOfNotSelectedOptionByLabel(Select select, String label, boolean isRegex, String objectId) {
        int count = 0;
        String regularExpressionLog = isRegex ? " using regular expression" : "";
        logger.logDebug(MessageFormat.format(StringConstants.COMM_LOG_INFO_COUNTING_NUM_OPTS_W_LBL_NOT_SELECTED_ON_OBJ, label, objectId, regularExpressionLog));
        List allOptions = select.getOptions();
        List allSelectedOptions = select.getAllSelectedOptions();
        int index = 0;
        while (index < allOptions.size()) {
            String optionLabel = ((WebElement)allOptions.get(index)).getText();
            if (optionLabel != null && KeywordHelper.match((String)optionLabel, (String)label, (boolean)isRegex) && !allSelectedOptions.contains(allOptions.get(index))) {
                ++count;
                logger.logDebug(MessageFormat.format(StringConstants.COMM_LOG_INFO_OPT_AT_INDEX_W_LBL_IS_NOT_SELECTED, index, optionLabel, regularExpressionLog));
            }
            ++index;
        }
        return count;
    }

    public static int getNumberOfSelectedOptionByValue(Select select, String value, boolean isRegex, String objectId) {
        int count = 0;
        String regularExpressionLog = isRegex ? " using regular expression" : "";
        logger.logDebug(MessageFormat.format(StringConstants.COMM_LOG_INFO_COUNTING_NUM_OPTS_W_VAL_SELECTED_ON_OBJ, value, objectId, regularExpressionLog));
        List allOptions = select.getOptions();
        List allSelectedOptions = select.getAllSelectedOptions();
        int index = 0;
        while (index < allOptions.size()) {
            String optionValue = ((WebElement)allOptions.get(index)).getAttribute("value");
            if (optionValue != null && KeywordHelper.match((String)optionValue, (String)value, (boolean)isRegex) && allSelectedOptions.contains(allOptions.get(index))) {
                ++count;
                logger.logDebug(MessageFormat.format(StringConstants.COMM_LOG_INFO_OPT_AT_INDEX_W_VAL_IS_SELECTED, index, optionValue, regularExpressionLog));
            }
            ++index;
        }
        return count;
    }

    public static int getNumberOfNotSelectedOptionByValue(Select select, String value, boolean isRegex, String objectId) {
        int count = 0;
        String regularExpressionLog = isRegex ? " using regular expression" : "";
        logger.logDebug(MessageFormat.format(StringConstants.COMM_LOG_INFO_COUNTING_NUM_OPTS_W_VAL_NOT_SELECTED_ON_OBJ, value, objectId, regularExpressionLog));
        List allOptions = select.getOptions();
        List allSelectedOptions = select.getAllSelectedOptions();
        int index = 0;
        while (index < allOptions.size()) {
            String optionValue = ((WebElement)allOptions.get(index)).getAttribute("value");
            if (optionValue != null && KeywordHelper.match((String)optionValue, (String)value, (boolean)isRegex) && !allSelectedOptions.contains(allOptions.get(index))) {
                ++count;
                logger.logDebug(MessageFormat.format(StringConstants.COMM_LOG_INFO_OPT_AT_INDEX_W_VAL_IS_NOT_SELECTED, index, optionValue, regularExpressionLog));
            }
            ++index;
        }
        return count;
    }

    public static int getNumberOfSelectedOptionByIndex(Select select, Integer[] indexes, String objectId) throws IllegalArgumentException {
        logger.logDebug(MessageFormat.format(StringConstants.COMM_LOG_INFO_COUNTING_NUM_OPTS_W_INDEX_RANGE_SELECTED_ON_OBJ, WebUiCommonHelper.integerArrayToString((Integer[])indexes), objectId));
        int count = 0;
        List allSelectedOptions = select.getAllSelectedOptions();
        Integer[] integerArray = indexes;
        int n = indexes.length;
        int n2 = 0;
        while (n2 < n) {
            int index = integerArray[n2];
            if (allSelectedOptions.contains(select.getOptions().get(index))) {
                ++count;
                logger.logDebug(MessageFormat.format(StringConstants.COMM_LOG_INFO_OPT_AT_INDEX_IS_SELECTED, index));
            }
            ++n2;
        }
        return count;
    }

    public static int getNumberOfNotSelectedOptionByIndex(Select select, Integer[] indexes, String objectId) {
        logger.logDebug(MessageFormat.format(StringConstants.COMM_LOG_INFO_COUNTING_NUM_OPTS_W_INDEX_RANGE_NOT_SELECTED_ON_OBJ, WebUiCommonHelper.integerArrayToString((Integer[])indexes), objectId));
        int count = 0;
        List allSelectedOptions = select.getAllSelectedOptions();
        Integer[] integerArray = indexes;
        int n = indexes.length;
        int n2 = 0;
        while (n2 < n) {
            int index = integerArray[n2];
            if (!allSelectedOptions.contains(select.getOptions().get(index))) {
                ++count;
                logger.logDebug(MessageFormat.format(StringConstants.COMM_LOG_INFO_OPT_AT_INDEX_IS_NOT_SELECTED, index));
            }
            ++n2;
        }
        return count;
    }

    public static void focusOnBrowser() throws WebDriverException, StepFailedException {
        ((JavascriptExecutor)DriverFactory.getWebDriver()).executeScript("window.focus()", new Object[0]);
    }

    public static By buildLocator(TestObject to) {
        SelectorMethod selectorMethod = to.getSelectorMethod();
        switch (selectorMethod) {
            case BASIC: {
                String cssLocatorValue = WebUiCommonHelper.findActiveEqualsObjectProperty(to, CSS_LOCATOR_PROPERTY_NAME);
                if (cssLocatorValue != null) {
                    return By.cssSelector((String)cssLocatorValue);
                }
                return WebUiCommonHelper.buildXpath(to);
            }
            case CSS: {
                return By.cssSelector((String)((String)to.getSelectorCollection().get(selectorMethod)));
            }
            case XPATH: {
                if (to.getSelectorCollection().isEmpty()) {
                    to.setSelectorValue(selectorMethod, ((TestObjectXpath)to.getXpaths().get(0)).getValue());
                }
                return By.xpath((String)((String)to.getSelectorCollection().get(selectorMethod)));
            }
        }
        return null;
    }

    public static By buildUnionXpath(TestObject to) {
        return WebUiCommonHelper.buildXpath(to, XPathBuilder.AggregationType.UNION, to.getProperties());
    }

    public static String getSelectorValue(TestObject to) {
        SelectorMethod selectorMethod = to.getSelectorMethod();
        switch (selectorMethod) {
            case BASIC: {
                String cssLocatorValue = WebUiCommonHelper.findActiveEqualsObjectProperty(to, CSS_LOCATOR_PROPERTY_NAME);
                if (cssLocatorValue != null) {
                    return cssLocatorValue;
                }
                XPathBuilder xpathBuilder = new XPathBuilder(to.getActiveProperties());
                return xpathBuilder.build();
            }
            case XPATH: {
                String ret = (String)to.getSelectorCollection().get(selectorMethod);
                if (ret == null && to.getXpaths() != null && !to.getXpaths().isEmpty()) {
                    ret = ((TestObjectXpath)to.getXpaths().get(0)).getValue();
                    to.setSelectorValue(selectorMethod, ret);
                }
                return ret;
            }
            case CSS: {
                return (String)to.getSelectorCollection().get(selectorMethod);
            }
        }
        return (String)to.getSelectorCollection().get(selectorMethod);
    }

    public static String findActiveEqualsObjectProperty(TestObject to, String propertyName) {
        for (TestObjectProperty property : to.getActiveProperties()) {
            if (!property.getName().equals(propertyName) || property.getCondition() != ConditionType.EQUALS) continue;
            return property.getValue();
        }
        return null;
    }

    private static By buildXpath(TestObject to) {
        return WebUiCommonHelper.buildXpath(to, XPathBuilder.AggregationType.INTERSECT, to.getActiveProperties());
    }

    private static By buildXpath(TestObject to, XPathBuilder.AggregationType aggregationType, List<TestObjectProperty> properties) {
        XPathBuilder xpathBuilder = new XPathBuilder(properties);
        return By.xpath((String)xpathBuilder.build(aggregationType));
    }

    private static List<Map.Entry<String, By>> buildXpathsFromXpathBasedConditions(TestObject to) {
        XPathBuilder xpathBuilder = new XPathBuilder(to.getProperties());
        return xpathBuilder.buildXpathBasedLocators().stream().map(entry -> new AbstractMap.SimpleEntry<String, By>((String)entry.getKey(), By.xpath((String)((String)entry.getValue())))).collect(Collectors.toList());
    }

    public static String getBrowserAndVersion(WebDriver webDriver) {
        return (String)((JavascriptExecutor)webDriver).executeScript("return navigator.sayswho= (function() { var ua= navigator.userAgent, tem, M= ua.match(/(opera|chrome|safari|firefox|msie|trident)\\/?\\s*(\\.?\\d+(\\.\\d+)*)/i) || []; if (/trident/i.test(M[1])) {     tem=  /\\brv[ :]+(\\d+)/g.exec(ua) || [];     return 'IE '+(tem[1] || ''); } if(M[1]=== 'Chrome') {     tem= ua.match(/\\b(OPR|Edge)\\/(\\d+)/);     if(tem!= null) return tem.slice(1).join(' ').replace('OPR', 'Opera'); } M= M[2]? [M[1], M[2]]: [navigator.appName, navigator.appVersion, '-?']; if((tem= ua.match(/version\\/(\\d+)/i))!= null) M.splice(1, 1, tem[1]); return M.join(' ').replace('MSIE', 'IE');})();", new Object[0]);
    }

    public static int getViewportWidth(WebDriver webDriver) {
        Long longValue = (Long)((JavascriptExecutor)DriverFactory.getWebDriver()).executeScript("return Math.max(document.documentElement.clientWidth, window.innerWidth || 0);", new Object[0]);
        return longValue.intValue();
    }

    public static int getViewportHeight(WebDriver webDriver) {
        Long longValue = (Long)((JavascriptExecutor)DriverFactory.getWebDriver()).executeScript("return Math.max(document.documentElement.clientHeight, window.innerHeight || 0);", new Object[0]);
        return longValue.intValue();
    }

    public static Rectangle getElementRect(WebDriver webDriver, WebElement element) {
        JavascriptExecutor javascriptExecutor = (JavascriptExecutor)webDriver;
        Number left = (Number)javascriptExecutor.executeScript("return arguments[0].getBoundingClientRect().left", new Object[]{element});
        Number right = (Number)javascriptExecutor.executeScript("return arguments[0].getBoundingClientRect().right", new Object[]{element});
        Number top = (Number)javascriptExecutor.executeScript("return arguments[0].getBoundingClientRect().top", new Object[]{element});
        Number bottom = (Number)javascriptExecutor.executeScript("return arguments[0].getBoundingClientRect().bottom", new Object[]{element});
        return new Rectangle(left.intValue(), top.intValue(), right.intValue() - left.intValue(), bottom.intValue() - top.intValue());
    }

    public static boolean isElementVisibleInViewport(WebDriver driver, TestObject testObject, int timeOut) throws IllegalArgumentException, StepFailedException, WebElementNotFoundException {
        WebUiCommonHelper.checkTestObjectParameter((TestObject)testObject);
        TestObject parentObject = testObject != null ? testObject.getParentObject() : null;
        ArrayList<TestObject> frames = new ArrayList<TestObject>();
        while (parentObject != null) {
            frames.add(parentObject);
            parentObject = parentObject.getParentObject();
        }
        boolean isSwitchIntoFrame = false;
        double xOffset = 0.0;
        double yOffset = 0.0;
        try {
            if (frames.size() > 0) {
                logger.logDebug(MessageFormat.format(StringConstants.KW_LOG_INFO_OBJ_X_HAS_PARENT_FRAME, testObject.getObjectId()));
                int i = frames.size() - 1;
                while (i >= 0) {
                    TestObject frameObject = (TestObject)frames.get(i);
                    logger.logDebug(MessageFormat.format(StringConstants.KW_LOG_INFO_SWITCHING_TO_IFRAME_X, frameObject.getObjectId()));
                    WebElement frameElement = WebUiCommonHelper.findWebElement(frameObject, timeOut);
                    if (frameElement != null) {
                        logger.logDebug(MessageFormat.format(StringConstants.KW_LOG_INFO_CHECKING_TO_IFRAME_X_IN_VIEWPORT, frameObject.getObjectId()));
                        Rectangle elementRect = WebUiCommonHelper.getElementRect(driver, frameElement);
                        elementRect.setRect(elementRect.getX() + xOffset, elementRect.getY() + yOffset, elementRect.getWidth(), elementRect.getHeight());
                        logger.logDebug(MessageFormat.format("Element position in viewport: x = {0}, y = {1}, width = {2}, height = {3}", elementRect.getX(), elementRect.getY(), elementRect.getWidth(), elementRect.getHeight()));
                        Rectangle documentRect = new Rectangle(0, 0, WebUiCommonHelper.getViewportWidth(driver), WebUiCommonHelper.getViewportHeight(driver));
                        logger.logDebug(MessageFormat.format("Viewport infomation: width = {0}, height = {1}", documentRect.getWidth(), documentRect.getHeight()));
                        if (!documentRect.intersects(elementRect)) {
                            logger.logDebug(MessageFormat.format(StringConstants.KW_MSG_PARENT_OBJECT_IS_NOT_VISIBLE_IN_VIEWPORT, frameObject.getObjectId()));
                            return false;
                        }
                        xOffset += (double)frameElement.getLocation().getX();
                        yOffset += (double)frameElement.getLocation().getY();
                        driver.switchTo().frame(frameElement);
                        isSwitchIntoFrame = true;
                        logger.logDebug(MessageFormat.format(StringConstants.KW_LOG_INFO_SWITCHED_TO_IFRAME_X, frameObject.getObjectId()));
                    }
                    --i;
                }
            }
            WebElement foundElement = WebUiCommonHelper.findWebElement(testObject, timeOut);
            boolean bl = WebUiCommonHelper.isElementVisibleInViewport(driver, foundElement);
            return bl;
        }
        finally {
            if (isSwitchIntoFrame) {
                WebUiCommonHelper.switchToDefaultContent();
            }
        }
    }

    public static boolean isElementVisibleInViewport(WebDriver driver, WebElement element) {
        Rectangle elementRect = WebUiCommonHelper.getElementRect(driver, element);
        logger.logDebug(MessageFormat.format("Element position in viewport: x = {0}, y = {1}, width = {2}, height = {3}", elementRect.getX(), elementRect.getY(), elementRect.getWidth(), elementRect.getHeight()));
        Rectangle documentRect = new Rectangle(0, 0, WebUiCommonHelper.getViewportWidth(driver), WebUiCommonHelper.getViewportHeight(driver));
        logger.logDebug(MessageFormat.format("Viewport infomation: width = {0}, height = {1}", documentRect.getWidth(), documentRect.getHeight()));
        return documentRect.intersects(elementRect);
    }

    /*
     * Exception decompiling
     */
    public static List<WebElement> findWebElements(TestObject testObject, int timeOut) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static List<WebElement> findWebElementsByOtherMethods(WebDriver webDriver, boolean objectInsideShadowDom, TestObject testObject, Boolean smartXPathsEnabled) {
        return WebUiCommonHelper.findWebElementsByAutoApplyNeighborXpaths(webDriver, objectInsideShadowDom, testObject, smartXPathsEnabled);
    }

    private static List<WebElement> findWebElementsByAutoApplyNeighborXpaths(WebDriver webDriver, boolean objectInsideShadowDom, TestObject testObject, Boolean smartXPathsEnabled) {
        if (objectInsideShadowDom) {
            return Collections.emptyList();
        }
        logger.logInfo(StringConstants.KW_LOG_INFO_SMART_XPATHS_SUPPORT_START);
        logger.logInfo("");
        logger.logInfo(StringConstants.KW_LOG_INFO_SMART_XPATHS_USING);
        List<Object> elementsFoundBeforeNeighborXPaths = new ArrayList<WebElement>();
        List allXPaths = testObject.getXpaths();
        Optional<TestObjectXpath> workingNeighborXPath = allXPaths.stream().filter(xpath -> xpath.getName().equals("xpath:neighbor")).findFirst();
        int firstNeighborXPathIndex = allXPaths.size() - 1;
        if (workingNeighborXPath.isPresent()) {
            firstNeighborXPathIndex = allXPaths.indexOf(workingNeighborXPath.get());
        }
        int i = 0;
        while (i <= firstNeighborXPathIndex) {
            TestObjectXpath thisXPath = (TestObjectXpath)allXPaths.get(i);
            By byThisXPath = By.xpath((String)thisXPath.getValue());
            List elementsFoundByThisXPath = webDriver.findElements(byThisXPath);
            if (elementsFoundByThisXPath != null && elementsFoundByThisXPath.size() > 0) {
                logger.logInfo(MessageFormat.format(StringConstants.KW_LOG_INFO_FOUND_WEB_ELEMENT_WITH_SMART_XPATHS, thisXPath.getValue()));
                elementsFoundBeforeNeighborXPaths = elementsFoundByThisXPath;
                String jsAutoHealingPath = String.valueOf(RunConfiguration.getProjectDir()) + "/Reports/smart_xpath/waiting-for-approval.json";
                BrokenTestObject brokenTestObject = WebUiCommonHelper.buildBrokenTestObject(testObject, thisXPath.getValue());
                BrokenTestObjects existingBrokenTestObjects = WebUiCommonHelper.readExistingBrokenTestObjects(jsAutoHealingPath);
                if (existingBrokenTestObjects == null) break;
                existingBrokenTestObjects.getBrokenTestObjects().add(brokenTestObject);
                WebUiCommonHelper.writeBrokenTestObjects(existingBrokenTestObjects, jsAutoHealingPath);
                break;
            }
            ++i;
        }
        if (elementsFoundBeforeNeighborXPaths.size() > 0 && smartXPathsEnabled.booleanValue()) {
            logger.logInfo(StringConstants.KW_LOG_INFO_SMART_XPATHS_AUTO_UPDATE_AND_CONTINUE_EXECUTION);
            logger.logInfo("");
            logger.logInfo(StringConstants.KW_LOG_INFO_SMART_XPATHS_SUPPORT_END);
            return elementsFoundBeforeNeighborXPaths;
        }
        if (elementsFoundBeforeNeighborXPaths.size() == 0) {
            logger.logInfo(StringConstants.KW_LOG_INFO_NOT_FOUND_WEB_ELEMENT_WITH_SMART_XPATHS);
        }
        logger.logInfo("");
        logger.logInfo(StringConstants.KW_LOG_INFO_SMART_XPATHS_SUPPORT_END);
        return Collections.emptyList();
    }

    private static void writeBrokenTestObjects(BrokenTestObjects brokenTestObjects, String filePath) {
        try {
            FileWriter writer = new FileWriter(filePath);
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            gson.toJson((Object)brokenTestObjects, (Appendable)writer);
            ((Writer)writer).flush();
            ((Writer)writer).close();
        }
        catch (Exception e) {
            KeywordLogger.getInstance(WebUiCommonHelper.class).logError(e.getMessage());
        }
    }

    private static BrokenTestObjects readExistingBrokenTestObjects(String filePath) {
        try {
            Gson gson = new Gson();
            JsonReader reader = new JsonReader((Reader)new FileReader(filePath));
            return (BrokenTestObjects)gson.fromJson(reader, BrokenTestObjects.class);
        }
        catch (Exception e) {
            KeywordLogger.getInstance(WebUiCommonHelper.class).logError(e.getMessage());
            return null;
        }
    }

    private static BrokenTestObject buildBrokenTestObject(TestObject testObject, String newXPath) {
        String oldXPath = (String)testObject.getSelectorCollection().get(testObject.getSelectorMethod());
        BrokenTestObject brokenTestObject = new BrokenTestObject();
        brokenTestObject.setTestObjectId(testObject.getObjectId());
        brokenTestObject.setApproved(false);
        brokenTestObject.setBrokenXPath(oldXPath);
        brokenTestObject.setProposedXPath(newXPath);
        return brokenTestObject;
    }

    private static List<WebElement> findWebElementsUsingHeuristicMethod(WebDriver webDriver, boolean objectInsideShadowDom, TestObject testObject) {
        if (objectInsideShadowDom) {
            return Collections.emptyList();
        }
        By unionLocator = WebUiCommonHelper.buildUnionXpath(testObject);
        List webElements = webDriver.findElements(unionLocator);
        if (webElements == null || webElements.isEmpty()) {
            return Collections.emptyList();
        }
        WebElement bestMatchElement = WebUiCommonHelper.findBestMatchElement(webDriver, testObject, webElements);
        return Arrays.asList(bestMatchElement);
    }

    private static WebElement findBestMatchElement(WebDriver webDriver, TestObject testObject, List<WebElement> webElements) {
        Map matchesLookup = webElements.stream().collect(Collectors.toMap(Function.identity(), webElement -> WebUiCommonHelper.getSatisfiedConditions(testObject, webElement)));
        List<Map.Entry<String, By>> xpaths = WebUiCommonHelper.buildXpathsFromXpathBasedConditions(testObject);
        for (Map.Entry<String, By> entry : xpaths) {
            String propertyName = entry.getKey();
            By locator = entry.getValue();
            List webElementsMatchingTextCondition = webDriver.findElements(locator);
            for (WebElement webElement2 : webElementsMatchingTextCondition) {
                List matches = matchesLookup.get(webElement2);
                if (matches == null) continue;
                matches.add(propertyName);
            }
        }
        Map.Entry bestMatchEntry = Collections.max(matchesLookup.entrySet(), (left, right) -> ((List)left.getValue()).size() - ((List)right.getValue()).size());
        WebElement bestMatchElement = (WebElement)bestMatchEntry.getKey();
        List matchingAttributes = bestMatchEntry.getValue();
        logger.logDebug(MessageFormat.format(StringConstants.KW_LOG_INFO_FINDING_WEB_ELEMENT_USING_HEURISTIC_METHOD, matchingAttributes));
        return bestMatchElement;
    }

    private static List<String> getSatisfiedConditions(TestObject testObject, WebElement webElement) {
        List expectedProperties = testObject.getProperties();
        ArrayList<String> satisfiedConditions = new ArrayList<String>();
        for (TestObjectProperty expectedProperty : expectedProperties) {
            boolean matches;
            String propertyName = expectedProperty.getName();
            XPathBuilder.PropertyType propertyType = XPathBuilder.PropertyType.nameOf(propertyName);
            block0 : switch (propertyType) {
                case TAG: {
                    String expectedTag = expectedProperty.getValue();
                    String actualTag = webElement.getTagName();
                    matches = expectedTag.equalsIgnoreCase(actualTag);
                    break;
                }
                case ATTRIBUTE: {
                    String expectedPropertyValue = expectedProperty.getValue();
                    String actualPropertyValue = webElement.getAttribute(propertyName);
                    switch (expectedProperty.getCondition()) {
                        case EQUALS: {
                            matches = expectedPropertyValue.equals(actualPropertyValue);
                            break block0;
                        }
                        case NOT_EQUAL: {
                            matches = !expectedPropertyValue.equals(actualPropertyValue);
                            break block0;
                        }
                        case CONTAINS: {
                            matches = expectedPropertyValue.contains(actualPropertyValue);
                            break block0;
                        }
                        case NOT_CONTAIN: {
                            matches = !expectedPropertyValue.contains(actualPropertyValue);
                            break block0;
                        }
                        case STARTS_WITH: {
                            matches = expectedPropertyValue.startsWith(actualPropertyValue);
                            break block0;
                        }
                        case ENDS_WITH: {
                            matches = expectedPropertyValue.endsWith(actualPropertyValue);
                            break block0;
                        }
                        case MATCHES_REGEX: {
                            matches = expectedPropertyValue.matches(actualPropertyValue);
                            break block0;
                        }
                        case NOT_MATCH_REGEX: {
                            matches = !expectedPropertyValue.matches(actualPropertyValue);
                            break block0;
                        }
                    }
                    matches = false;
                    break;
                }
                default: {
                    matches = false;
                }
            }
            if (!matches) continue;
            satisfiedConditions.add(propertyName);
        }
        return satisfiedConditions;
    }

    private static List<WebElement> doFindElementsDefault(TestObject testObject, int timeOut, WebDriver webDriver, By locator) throws WebElementNotFoundException {
        List webElements = webDriver.findElements(locator);
        if (webElements != null && webElements.size() > 0) {
            logger.logDebug(MessageFormat.format(StringConstants.KW_LOG_INFO_FINDING_WEB_ELEMENT_W_ID_SUCCESS, webElements.size(), testObject.getObjectId(), locator.toString(), timeOut));
        }
        return webElements;
    }

    private static List<WebElement> doFindElementsInsideShadowDom(TestObject testObject, int timeOut, WebDriver webDriver, String cssLocator, TestObject parentObject, WebElement shadowRootElement) throws WebElementNotFoundException {
        Object shadowRootElementSandbox = ((JavascriptExecutor)webDriver).executeScript("return arguments[0].shadowRoot;", new Object[]{shadowRootElement});
        if (shadowRootElementSandbox == null) {
            throw new StepFailedException(MessageFormat.format(CoreWebuiMessageConstants.MSG_FAILED_WEB_ELEMENT_X_IS_NOT_SHADOW_ROOT, parentObject));
        }
        List webElements = (List)((JavascriptExecutor)webDriver).executeScript("return arguments[0].querySelectorAll('" + cssLocator + "');", new Object[]{shadowRootElementSandbox});
        if (webElements != null && webElements.size() > 0) {
            logger.logDebug(MessageFormat.format(StringConstants.KW_LOG_INFO_FINDING_WEB_ELEMENT_W_ID_SUCCESS, webElements.size(), testObject.getObjectId(), cssLocator, timeOut));
        }
        return webElements;
    }

    public static WebElement findWebElement(TestObject testObject, int timeOut) throws WebElementNotFoundException {
        List<WebElement> elements = WebUiCommonHelper.findWebElements(testObject, timeOut);
        if (elements != null && elements.size() > 0) {
            return elements.get(0);
        }
        throw new WebElementNotFoundException(testObject.getObjectId(), WebUiCommonHelper.buildLocator(testObject));
    }

    public static void switchToDefaultContent() throws StepFailedException {
        try {
            if (DriverFactory.getAlert() != null) {
                logger.logWarning(StringConstants.KW_LOG_WARNING_SWITCHING_TO_DEFAULT_CONTENT_FAILED_BC_ALERT_ON_PAGE);
                return;
            }
            logger.logDebug(StringConstants.KW_LOG_INFO_SWITCHING_TO_DEFAULT_CONTENT);
            DriverFactory.getWebDriver().switchTo().defaultContent();
        }
        catch (NoSuchWindowException noSuchWindowException) {
        }
        catch (WebDriverException e) {
            logger.logWarning(MessageFormat.format(StringConstants.KW_LOG_WARNING_SWITCHING_TO_DEFAULT_CONTENT_FAILED_BC_OF_X, ExceptionsUtil.getMessageForThrowable((Throwable)e)));
        }
    }

    public static boolean switchToParentFrame(TestObject testObject, int timeOut) throws WebElementNotFoundException {
        TestObject parentObject = testObject != null ? testObject.getParentObject() : null;
        boolean isParentShadowRoot = testObject.isParentObjectShadowRoot();
        ArrayList<TestObject> parentObjects = new ArrayList<TestObject>();
        while (parentObject != null && !isParentShadowRoot) {
            parentObjects.add(parentObject);
            isParentShadowRoot = parentObject.isParentObjectShadowRoot();
            parentObject = parentObject.getParentObject();
        }
        if (parentObjects.size() <= 0) {
            return false;
        }
        logger.logDebug(MessageFormat.format(StringConstants.KW_LOG_INFO_OBJ_X_HAS_PARENT_FRAME, testObject.getObjectId()));
        WebDriver webDriver = DriverFactory.getWebDriver();
        int i = parentObjects.size() - 1;
        while (i >= 0) {
            TestObject currentParentObject = (TestObject)parentObjects.get(i);
            if (!WebUiCommonHelper.switchToParentFrame(timeOut, webDriver, currentParentObject)) {
                return false;
            }
            --i;
        }
        return true;
    }

    private static boolean switchToParentFrame(int timeOut, WebDriver webDriver, TestObject currentParentObject) throws WebElementNotFoundException {
        logger.logDebug(MessageFormat.format(StringConstants.KW_LOG_INFO_SWITCHING_TO_IFRAME_X, currentParentObject.getObjectId()));
        WebElement frameElement = WebUiCommonHelper.findWebElement(currentParentObject, timeOut);
        if (frameElement == null) {
            return false;
        }
        webDriver.switchTo().frame(frameElement);
        logger.logDebug(MessageFormat.format(StringConstants.KW_LOG_INFO_SWITCHED_TO_IFRAME_X, currentParentObject.getObjectId()));
        return true;
    }

    public static boolean switchToParentFrame(TestObject testObject) throws WebElementNotFoundException {
        return WebUiCommonHelper.switchToParentFrame(testObject, RunConfiguration.getTimeOut());
    }
}

