/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.webui.common;

import com.kms.katalon.core.webui.common.Result;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class ExecuteCommandAction {
    private String command;
    private Process process;
    private List<String> outputs = new ArrayList<String>();
    private List<String> errors = new ArrayList<String>();

    public ExecuteCommandAction(String command) {
        this.command = command;
    }

    public Result execute() {
        this.buildProcess(this.command);
        Result result = new Result();
        if (this.errors.size() > 0) {
            result.setMessage(this.getErrorMessage());
        }
        result.setReturnValue(this.outputs);
        return result;
    }

    private String getErrorMessage() {
        String error = "";
        for (String err : this.errors) {
            error = String.valueOf(error) + err + " ";
        }
        return error;
    }

    private void buildProcess(String command) {
        try {
            String workingDirectory = this.getWorkingDirectory();
            this.process = workingDirectory != null ? Runtime.getRuntime().exec(command, null, new File(workingDirectory)) : Runtime.getRuntime().exec(command);
            StreamGobbler errorGobbler = new StreamGobbler(this.process.getErrorStream(), "ERROR");
            StreamGobbler outputGobbler = new StreamGobbler(this.process.getInputStream(), "OUTPUT");
            errorGobbler.start();
            outputGobbler.start();
            System.out.println("START : " + command);
            this.process.waitFor();
        }
        catch (Exception e) {
            this.errors.add(e.getMessage());
        }
    }

    private String getWorkingDirectory() {
        return null;
    }

    private class StreamGobbler
    extends Thread {
        InputStream in;
        String type;

        public StreamGobbler(InputStream in, String type) {
            this.in = in;
            this.type = type;
        }

        @Override
        public void run() {
            try {
                InputStreamReader isr = new InputStreamReader(this.in);
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    if ("output".equalsIgnoreCase(this.type)) {
                        ExecuteCommandAction.this.outputs.add(line);
                        continue;
                    }
                    if ("error".equalsIgnoreCase(this.type)) {
                        ExecuteCommandAction.this.errors.add(line);
                        continue;
                    }
                    System.out.println(String.valueOf(this.type) + ">" + line);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

