/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.webui.common;

import com.kms.katalon.core.testobject.ConditionType;
import com.kms.katalon.core.testobject.TestObject;
import com.kms.katalon.core.testobject.TestObjectProperty;
import com.kms.katalon.core.webui.common.WebUiCommonHelper;
import org.apache.commons.lang3.StringUtils;

public class CssLocatorBuilder {
    private static final String CSS_LOCATOR_PROPERTY_NAME = "css";

    public static String buildCssSelectorLocator(TestObject to) {
        String cssLocatorValue = WebUiCommonHelper.findActiveEqualsObjectProperty(to, CSS_LOCATOR_PROPERTY_NAME);
        if (cssLocatorValue != null) {
            return cssLocatorValue;
        }
        StringBuilder cssBuilder = new StringBuilder();
        cssBuilder.append(CssLocatorBuilder.buildTagSection(to));
        for (TestObjectProperty property : to.getActiveProperties()) {
            String propertyName = property.getName();
            String value = property.getValue();
            ConditionType conditionType = property.getCondition();
            if ("tag".equals(propertyName) || "xpath".equals(propertyName) || CSS_LOCATOR_PROPERTY_NAME.equals(propertyName) || StringUtils.isEmpty((CharSequence)value) || conditionType == ConditionType.MATCHES_REGEX || conditionType == ConditionType.NOT_MATCH_REGEX) continue;
            cssBuilder.append(CssLocatorBuilder.getPrefix(property));
            cssBuilder.append("[" + propertyName + CssLocatorBuilder.getOperator(property) + "\"" + value + "\"]");
            cssBuilder.append(CssLocatorBuilder.getSuffix(property));
        }
        String result = cssBuilder.toString();
        if (StringUtils.isEmpty((CharSequence)result)) {
            return null;
        }
        return result;
    }

    private static String buildTagSection(TestObject to) {
        TestObjectProperty tagProperty = CssLocatorBuilder.findActiveObjectProperty(to, "tag");
        if (tagProperty == null || StringUtils.isEmpty((CharSequence)tagProperty.getValue()) || tagProperty.getCondition() != ConditionType.EQUALS && tagProperty.getCondition() != ConditionType.NOT_EQUAL) {
            return "*";
        }
        StringBuilder locatorString = new StringBuilder();
        locatorString.append(CssLocatorBuilder.getPrefix(tagProperty));
        locatorString.append(tagProperty.getValue());
        locatorString.append(CssLocatorBuilder.getSuffix(tagProperty));
        return locatorString.toString();
    }

    private static TestObjectProperty findActiveObjectProperty(TestObject to, String propertyName) {
        for (TestObjectProperty property : to.getActiveProperties()) {
            if (!property.getName().equals(propertyName)) continue;
            return property;
        }
        return null;
    }

    private static String getOperator(TestObjectProperty property) {
        switch (property.getCondition()) {
            case CONTAINS: 
            case NOT_CONTAIN: {
                return "~=";
            }
            case ENDS_WITH: {
                return "$=";
            }
            case EQUALS: 
            case NOT_EQUAL: {
                return "=";
            }
            case STARTS_WITH: {
                return "^=";
            }
        }
        return "=";
    }

    private static String getSuffix(TestObjectProperty property) {
        switch (property.getCondition()) {
            case NOT_EQUAL: 
            case NOT_CONTAIN: {
                return ")";
            }
        }
        return "";
    }

    private static String getPrefix(TestObjectProperty property) {
        switch (property.getCondition()) {
            case NOT_EQUAL: 
            case NOT_CONTAIN: {
                return ":not(";
            }
        }
        return "";
    }
}

