/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.webui.setting;

import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.setting.BundleSettingStore;
import com.kms.katalon.core.testobject.SelectorMethod;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.execution.webui.constants.StringConstants;
import com.kms.katalon.util.collections.Pair;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.framework.FrameworkUtil;

public class WebUiExecutionSettingStore
extends BundleSettingStore {
    public static final boolean EXECUTION_DEFAULT_IGNORE_PAGELOAD_TIMEOUT_EXCEPTION = false;
    public static final boolean EXECUTION_DEFAULT_ENABLE_PAGE_LOAD_TIMEOUT = false;
    public static final int EXECUTION_DEFAULT_ACTION_DELAY = 0;
    public static final int EXECUTION_DEFAULT_PAGE_LOAD_TIMEOUT = 30;
    public static final int EXECUTION_DEFAULT_WAIT_FOR_IE_HANGING = 600;
    public static final String DEFAULT_SELECTING_CAPTURED_OBJECT_PROPERTIES = "id,true;name,true;alt,true;checked,true;form,true;href,true;placeholder,true;selected,true;src,true;title,true;type,true;text,true;linked_text,true";
    public static final String DEFAULT_SELECTING_CAPTURED_OBJECT_XPATHS = "xpath:attributes,true;xpath:idRelative,true;dom:name,true;xpath:link,true;xpath:neighbor,true;xpath:href,true;xpath:img,true;xpath:position,true;";
    public static final String DEFAULT_SELECTING_CAPTURED_OBJECT_SELECTOR_METHOD = "BASIC";

    public static WebUiExecutionSettingStore getStore() {
        ProjectEntity projectEntity = ProjectController.getInstance().getCurrentProject();
        if (projectEntity == null) {
            return null;
        }
        return new WebUiExecutionSettingStore(projectEntity);
    }

    public WebUiExecutionSettingStore(ProjectEntity projectEntity) {
        super(projectEntity.getFolderLocation(), FrameworkUtil.getBundle(WebUiExecutionSettingStore.class).getSymbolicName(), false);
    }

    public boolean getEnablePageLoadTimeout() throws IOException {
        return this.getBoolean("execution.default.webUi.enablePageLoadTimeout", false);
    }

    public void setEnablePageLoadTimeout(boolean pageLoadTimeoutEnabled) throws IOException {
        this.setProperty("execution.default.webUi.enablePageLoadTimeout", pageLoadTimeoutEnabled);
    }

    public boolean getIgnorePageLoadTimeout() throws IOException {
        return this.getBoolean("execution.default.webUi.ignorePageLoadTimeOutException", false);
    }

    public void setIgnorePageLoadTimeout(boolean pageLoadTimeoutIgnored) throws IOException {
        this.setProperty("execution.default.webUi.ignorePageLoadTimeOutException", pageLoadTimeoutIgnored);
    }

    public int getPageLoadTimeout() throws IOException {
        return this.getInt("execution.default.webUi.pageLoadTimeout", 30);
    }

    public void setPageLoadTimeout(int pageLoadTimeout) throws IOException {
        this.setProperty("execution.default.webUi.pageLoadTimeout", pageLoadTimeout);
    }

    public int getActionDelay() throws IOException {
        return this.getInt("execution.default.webUi.actionDelay", 0);
    }

    public void setActionDelay(int actionDelay) throws IOException {
        this.setProperty("execution.default.webUi.actionDelay", actionDelay);
    }

    public int getIEHangTimeout() throws IOException {
        return this.getInt("execution.default.waitForIEHanging", 600);
    }

    public void setIEHangTimeout(int timeout) throws IOException {
        this.setProperty("execution.default.waitForIEHanging", timeout);
    }

    public void setDefaultIEHangTimeout() throws IOException {
        this.setProperty("execution.default.waitForIEHanging", 600);
    }

    public void setDefaultCapturedTestObjectAttributeLocators() throws IOException {
        this.setProperty("execution.default.selectingCapturedObjectProperties", DEFAULT_SELECTING_CAPTURED_OBJECT_PROPERTIES);
    }

    public void setCapturedTestObjectAttributeLocators(List<Pair<String, Boolean>> locators) throws IOException {
        this.setProperty("execution.default.selectingCapturedObjectProperties", this.flattenStringBooleanList(locators));
    }

    public List<Pair<String, Boolean>> getCapturedTestObjectAttributeLocators() throws IOException {
        return this.parseStringBooleanString(this.getString("execution.default.selectingCapturedObjectProperties", DEFAULT_SELECTING_CAPTURED_OBJECT_PROPERTIES));
    }

    public List<Pair<String, Boolean>> getCapturedTestObjectXpathLocators() throws IOException {
        return this.parseStringBooleanString(this.getString("execution.default.selectingCapturedObjectXpaths", DEFAULT_SELECTING_CAPTURED_OBJECT_XPATHS));
    }

    public List<Pair<String, Boolean>> getDefaultCapturedObjectXpathLocators() throws IOException {
        return this.parseStringBooleanString(this.getString(DEFAULT_SELECTING_CAPTURED_OBJECT_XPATHS, DEFAULT_SELECTING_CAPTURED_OBJECT_XPATHS));
    }

    public void setDefaultCapturedTestObjectXpathLocators() throws IOException {
        this.setProperty("execution.default.selectingCapturedObjectXpaths", DEFAULT_SELECTING_CAPTURED_OBJECT_XPATHS);
    }

    public void setCapturedTestObjectXpathLocators(List<Pair<String, Boolean>> locators) throws IOException {
        this.setProperty("execution.default.selectingCapturedObjectXpaths", this.flattenStringBooleanList(locators));
    }

    public void setDefaultCapturedTestObjectSelectorMethods() throws IOException {
        this.setProperty("execution.default.selectingCapturedObjectSelectorMethod", DEFAULT_SELECTING_CAPTURED_OBJECT_SELECTOR_METHOD);
    }

    public void setCapturedTestObjectSelectorMethod(SelectorMethod selectorMethod) throws IOException {
        this.setProperty("execution.default.selectingCapturedObjectSelectorMethod", selectorMethod.toString());
    }

    public SelectorMethod getCapturedTestObjectSelectorMethod() throws IOException {
        return this.parseSelectorMethodString(this.getString("execution.default.selectingCapturedObjectSelectorMethod", DEFAULT_SELECTING_CAPTURED_OBJECT_SELECTOR_METHOD));
    }

    private String flattenStringBooleanList(List<Pair<String, Boolean>> list) {
        if (list == null || list.isEmpty()) {
            return StringConstants.EMPTY;
        }
        return list.stream().map(i -> String.valueOf((String)i.getLeft()) + "," + i.getRight()).collect(Collectors.joining(";"));
    }

    private List<Pair<String, Boolean>> parseStringBooleanString(String str) {
        if (str == null || str.isEmpty()) {
            return Collections.emptyList();
        }
        return Stream.of(str.split(";")).map(i -> i.split(",")).map(i -> new Pair((Object)i[0], (Object)Boolean.valueOf(i[1]))).collect(Collectors.toList());
    }

    private SelectorMethod parseSelectorMethodString(String str) {
        if (str == null || str.isEmpty()) {
            return SelectorMethod.BASIC;
        }
        return SelectorMethod.valueOf((String)str);
    }
}

