/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.webui.driver;

import com.kms.katalon.execution.classpath.ClassPathResolver;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.PosixFilePermission;
import java.util.HashSet;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class SeleniumWebDriverProvider {
    private static final String DRIVERS_FOLDER_NAME = "resources" + File.separator + "drivers";

    public static File getDriverDirectory() throws IOException {
        block15: {
            Bundle bundleExec = Platform.getBundle((String)"com.kms.katalon.core.webui");
            File bundleFile = FileLocator.getBundleFile((Bundle)bundleExec);
            if (!bundleFile.isDirectory()) break block15;
            String osResourcesFolderName = "";
            switch (Platform.getOS()) {
                case "win32": {
                    if (Platform.getOSArch().equals("x86_64")) {
                        osResourcesFolderName = "win64";
                        break;
                    }
                    osResourcesFolderName = "win32";
                    break;
                }
                case "linux": {
                    if (Platform.getOSArch().equals("x86_64")) {
                        osResourcesFolderName = "linux64";
                        break;
                    }
                    osResourcesFolderName = "linux32";
                    break;
                }
                case "macosx": {
                    osResourcesFolderName = "macosx";
                }
            }
            return new File(bundleFile + File.separator + "os_resources" + File.separator + osResourcesFolderName + File.separator + DRIVERS_FOLDER_NAME);
        }
        return new File(ClassPathResolver.getConfigurationFolder() + File.separator + DRIVERS_FOLDER_NAME);
    }

    private static void makeFileExecutable(String filePath) throws IOException {
        File file = new File(filePath);
        if (file.exists() && file.isFile()) {
            HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
            PosixFilePermission[] posixFilePermissionArray = PosixFilePermission.values();
            int n = posixFilePermissionArray.length;
            int n2 = 0;
            while (n2 < n) {
                PosixFilePermission permission = posixFilePermissionArray[n2];
                perms.add(permission);
                ++n2;
            }
            Files.setPosixFilePermissions(file.toPath(), perms);
        }
    }

    public static String getChromeDriverPath() {
        try {
            switch (Platform.getOS()) {
                case "win32": {
                    return SeleniumWebDriverProvider.getChromeDriverPathForWindows();
                }
                case "linux": {
                    return SeleniumWebDriverProvider.getChromeDriverPathForLinux();
                }
                case "macosx": {
                    return SeleniumWebDriverProvider.getChromeDriverPathForMac();
                }
            }
        }
        catch (IOException iOException) {}
        return "";
    }

    private static String getChromeDriverPathForLinux() throws IOException {
        String chromeDriverPath = String.valueOf(SeleniumWebDriverProvider.getDriverDirectory().getAbsolutePath()) + File.separator;
        chromeDriverPath = Platform.getOSArch().equals("x86_64") ? String.valueOf(chromeDriverPath) + "chromedriver_linux64" + File.separator + "chromedriver" : String.valueOf(chromeDriverPath) + "chromedriver_linux32" + File.separator + "chromedriver";
        return chromeDriverPath;
    }

    private static String getChromeDriverPathForWindows() throws IOException {
        return String.valueOf(SeleniumWebDriverProvider.getDriverDirectory().getAbsolutePath()) + File.separator + "chromedriver_win32" + File.separator + "chromedriver.exe";
    }

    private static String getChromeDriverPathForMac() throws IOException {
        String chromeDriverPath = String.valueOf(SeleniumWebDriverProvider.getDriverDirectory().getAbsolutePath()) + File.separator + "chromedriver_mac" + File.separator + "chromedriver";
        SeleniumWebDriverProvider.makeFileExecutable(chromeDriverPath);
        return chromeDriverPath;
    }

    public static String getIEDriverPath() {
        try {
            String ieDriverPath = String.valueOf(SeleniumWebDriverProvider.getDriverDirectory().getAbsolutePath()) + File.separator;
            ieDriverPath = Platform.getOSArch().equals("x86_64") ? String.valueOf(ieDriverPath) + "iedriver_win64" + File.separator + "IEDriverServer.exe" : String.valueOf(ieDriverPath) + "iedriver_win32" + File.separator + "IEDriverServer.exe";
            return ieDriverPath;
        }
        catch (IOException iOException) {
            return "";
        }
    }

    public static String getEdgeDriverPath() {
        try {
            return String.valueOf(SeleniumWebDriverProvider.getDriverDirectory().getAbsolutePath()) + File.separator + "edgedriver" + File.separator + "MicrosoftWebDriver.exe";
        }
        catch (IOException iOException) {
            return "";
        }
    }

    public static String getGeckoDriverPath() throws IOException {
        switch (Platform.getOS()) {
            case "win32": {
                return String.valueOf(SeleniumWebDriverProvider.getDriverDirectory().getAbsolutePath()) + File.separator + "firefox_win64" + File.separator + "geckodriver.exe";
            }
            case "linux": {
                String geckoDriverPath = String.valueOf(SeleniumWebDriverProvider.getDriverDirectory().getAbsolutePath()) + File.separator + "firefox_linux64" + File.separator + "geckodriver";
                SeleniumWebDriverProvider.makeFileExecutable(geckoDriverPath);
                return geckoDriverPath;
            }
            case "macosx": {
                String geckoDriverPath = String.valueOf(SeleniumWebDriverProvider.getDriverDirectory().getAbsolutePath()) + File.separator + "firefox_mac" + File.separator + "geckodriver";
                SeleniumWebDriverProvider.makeFileExecutable(geckoDriverPath);
                return geckoDriverPath;
            }
        }
        return "";
    }
}

