/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.webui.driver;

import com.kms.katalon.core.driver.DriverType;
import com.kms.katalon.core.webui.driver.WebUIDriverType;
import com.kms.katalon.execution.webui.driver.WebUiDriverConnector;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class RemoteWebDriverConnector
extends WebUiDriverConnector {
    protected String remoteServerUrl;
    protected RemoteWebDriverConnectorType remoteWebDriverConnectorType;

    public RemoteWebDriverConnector(String configurationFolderPath) throws IOException {
        super(configurationFolderPath);
    }

    public DriverType getDriverType() {
        return WebUIDriverType.REMOTE_WEB_DRIVER;
    }

    public String getRemoteServerUrl() {
        return this.remoteServerUrl;
    }

    public void setRemoteServerUrl(String remoteServerUrl) {
        this.remoteServerUrl = remoteServerUrl;
    }

    public Map<String, Object> getSystemProperties() {
        Map propertyMap = super.getSystemProperties();
        propertyMap.put("remoteWebDriverUrl", this.getRemoteServerUrl());
        propertyMap.put("remoteWebDriverType", this.getRemoteWebDriverConnectorType().name());
        return propertyMap;
    }

    protected void loadDriverProperties() throws IOException {
        super.loadDriverProperties();
        this.remoteServerUrl = this.driverProperties.get("remoteWebDriverUrl") instanceof String ? (String)this.driverProperties.get("remoteWebDriverUrl") : "";
        this.remoteWebDriverConnectorType = this.driverProperties.get("remoteWebDriverType") instanceof String ? RemoteWebDriverConnectorType.valueOf((String)this.driverProperties.get("remoteWebDriverType")) : RemoteWebDriverConnectorType.Selenium;
        this.driverProperties.remove("remoteWebDriverUrl");
        this.driverProperties.remove("remoteWebDriverType");
    }

    public Map<String, Object> getUserConfigProperties() {
        return super.getUserConfigProperties();
    }

    public void saveUserConfigProperties() throws IOException {
        this.driverProperties.put("remoteWebDriverUrl", this.getRemoteServerUrl());
        this.driverProperties.put("remoteWebDriverType", this.getRemoteWebDriverConnectorType().name());
        super.saveUserConfigProperties();
    }

    public String toString() {
        HashMap<String, Object> tempMap = new HashMap<String, Object>(this.getUserConfigProperties());
        tempMap.put("remoteWebDriverUrl", this.getRemoteServerUrl());
        tempMap.put("remoteWebDriverType", this.getRemoteWebDriverConnectorType().name());
        return ((Object)tempMap).toString();
    }

    public RemoteWebDriverConnectorType getRemoteWebDriverConnectorType() {
        return this.remoteWebDriverConnectorType;
    }

    public void setRemoteWebDriverConnectorType(RemoteWebDriverConnectorType remoteWebDriverConnectorType) {
        this.remoteWebDriverConnectorType = remoteWebDriverConnectorType;
    }

    public RemoteWebDriverConnector clone() {
        try {
            RemoteWebDriverConnector remoteDriverConnector = new RemoteWebDriverConnector(this.getParentFolderPath());
            remoteDriverConnector.setRemoteServerUrl(this.getRemoteServerUrl());
            remoteDriverConnector.setRemoteWebDriverConnectorType(this.getRemoteWebDriverConnectorType());
            remoteDriverConnector.driverProperties = (Map)this.cloneDriverPropertyValue(this.getUserConfigProperties());
            return remoteDriverConnector;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static enum RemoteWebDriverConnectorType {
        Selenium,
        Appium;


        public static String[] stringValues() {
            RemoteWebDriverConnectorType[] values = RemoteWebDriverConnectorType.values();
            String[] stringValues = new String[values.length];
            int i = 0;
            while (i < values.length) {
                stringValues[i] = values[i].name();
                ++i;
            }
            return stringValues;
        }

        public static int indexOf(RemoteWebDriverConnectorType remoteType) {
            RemoteWebDriverConnectorType[] values = RemoteWebDriverConnectorType.values();
            int index = 0;
            while (index < values.length) {
                if (values[index] == remoteType) {
                    return index;
                }
                ++index;
            }
            return -1;
        }
    }
}

