/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.webui.configuration.contributor;

import com.kms.katalon.core.webui.driver.WebUIDriverType;
import com.kms.katalon.entity.testsuite.RunConfigurationDescription;
import com.kms.katalon.execution.configuration.IRunConfiguration;
import com.kms.katalon.execution.console.entity.ConsoleOption;
import com.kms.katalon.execution.console.entity.StringConsoleOption;
import com.kms.katalon.execution.exception.ExecutionException;
import com.kms.katalon.execution.webui.configuration.RemoteWebRunConfiguration;
import com.kms.katalon.execution.webui.configuration.contributor.WebUIRunConfigurationContributor;
import com.kms.katalon.execution.webui.constants.StringConstants;
import com.kms.katalon.execution.webui.driver.RemoteWebDriverConnector;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class RemoteWebRunConfigurationContributor
extends WebUIRunConfigurationContributor {
    public static final String REMOTE_CONFIGURATION_KEY = "remoteWebDriverUrl";
    public static final String REMOTE_CONFIGURATION_TYPE_KEY = "remoteWebDriverType";
    private static final RemoteWebDriverConnector.RemoteWebDriverConnectorType DEFAULT_REMOTE_WEB_DRIVER_CONNECTOR_TYPE = RemoteWebDriverConnector.RemoteWebDriverConnectorType.Selenium;
    private String remoteWebDriverUrl = "";
    private RemoteWebDriverConnector.RemoteWebDriverConnectorType remoteWebDriverType = DEFAULT_REMOTE_WEB_DRIVER_CONNECTOR_TYPE;
    public static final StringConsoleOption REMOTE_WEB_DRIVER_URL_CONSOLE_OPTION = new StringConsoleOption(){

        public String getOption() {
            return RemoteWebRunConfigurationContributor.REMOTE_CONFIGURATION_KEY;
        }

        public boolean isRequired() {
            return false;
        }
    };
    public static final StringConsoleOption REMOTE_WEB_DRIVER_CONNECTOR_TYPE_CONSOLE_OPTION = new StringConsoleOption(){

        public String getOption() {
            return RemoteWebRunConfigurationContributor.REMOTE_CONFIGURATION_TYPE_KEY;
        }

        public String getDefaultArgumentValue() {
            return DEFAULT_REMOTE_WEB_DRIVER_CONNECTOR_TYPE.toString();
        }

        public boolean isRequired() {
            return false;
        }
    };

    public String getId() {
        return WebUIDriverType.REMOTE_WEB_DRIVER.toString();
    }

    public IRunConfiguration getRunConfiguration(String projectDir) throws IOException, ExecutionException {
        RemoteWebRunConfiguration runConfiguration = new RemoteWebRunConfiguration(projectDir);
        this.remoteWebDriverUrl = StringUtils.isNotBlank((String)this.remoteWebDriverUrl) ? this.remoteWebDriverUrl : runConfiguration.getRemoteServerUrl();
        RemoteWebDriverConnector.RemoteWebDriverConnectorType remoteWebDriverConnectorType = this.remoteWebDriverType = this.remoteWebDriverType != null ? this.remoteWebDriverType : runConfiguration.getRemoteWebDriverConnectorType();
        if (StringUtils.isBlank((String)this.remoteWebDriverUrl)) {
            throw new ExecutionException(StringConstants.REMOTE_WEB_DRIVER_ERR_NO_URL_AVAILABLE);
        }
        if (this.remoteWebDriverType == null) {
            throw new ExecutionException(StringConstants.REMOTE_WEB_DRIVER_ERR_NO_TYPE_AVAILABLE);
        }
        runConfiguration.setRemoteServerUrl(this.remoteWebDriverUrl);
        runConfiguration.setRemoteWebDriverConnectorType(this.remoteWebDriverType);
        return runConfiguration;
    }

    public IRunConfiguration getRunConfiguration(String projectDir, RunConfigurationDescription runConfigurationDescription) throws IOException, ExecutionException, InterruptedException {
        if (runConfigurationDescription != null && runConfigurationDescription.getRunConfigurationData() != null) {
            Map runConfigurationData = runConfigurationDescription.getRunConfigurationData();
            this.remoteWebDriverUrl = this.getRemoteWebDriverUrl(runConfigurationData);
            this.remoteWebDriverType = this.getRemoteWebDriverType(runConfigurationData);
        }
        return super.getRunConfiguration(projectDir, runConfigurationDescription);
    }

    public int getPreferredOrder() {
        return 5;
    }

    @Override
    public List<ConsoleOption<?>> getConsoleOptionList() {
        ArrayList consoleOptionList = new ArrayList();
        consoleOptionList.add((ConsoleOption<?>)REMOTE_WEB_DRIVER_URL_CONSOLE_OPTION);
        consoleOptionList.add((ConsoleOption<?>)REMOTE_WEB_DRIVER_CONNECTOR_TYPE_CONSOLE_OPTION);
        return consoleOptionList;
    }

    @Override
    public void setArgumentValue(ConsoleOption<?> consoleOption, String argumentValue) throws Exception {
        if (StringUtils.isBlank((String)argumentValue)) {
            return;
        }
        if (consoleOption == REMOTE_WEB_DRIVER_URL_CONSOLE_OPTION) {
            this.remoteWebDriverUrl = argumentValue.trim();
            return;
        }
        if (consoleOption == REMOTE_WEB_DRIVER_CONNECTOR_TYPE_CONSOLE_OPTION) {
            this.remoteWebDriverType = RemoteWebDriverConnector.RemoteWebDriverConnectorType.valueOf(argumentValue);
        }
    }

    @Override
    public List<ConsoleOption<?>> getConsoleOptions(final RunConfigurationDescription runConfigurationDescription) {
        return Arrays.asList(new StringConsoleOption(){

            public String getOption() {
                return RemoteWebRunConfigurationContributor.REMOTE_CONFIGURATION_TYPE_KEY;
            }

            public String getDefaultArgumentValue() {
                return DEFAULT_REMOTE_WEB_DRIVER_CONNECTOR_TYPE.toString();
            }

            public boolean isRequired() {
                return false;
            }

            public String getValue() {
                return RemoteWebRunConfigurationContributor.this.getRemoteWebDriverType(runConfigurationDescription.getRunConfigurationData()).name();
            }
        }, new StringConsoleOption(){

            public String getOption() {
                return RemoteWebRunConfigurationContributor.REMOTE_CONFIGURATION_KEY;
            }

            public boolean isRequired() {
                return false;
            }

            public String getValue() {
                return RemoteWebRunConfigurationContributor.this.getRemoteWebDriverUrl(runConfigurationDescription.getRunConfigurationData());
            }
        });
    }

    private RemoteWebDriverConnector.RemoteWebDriverConnectorType getRemoteWebDriverType(Map<String, String> runConfigurationData) {
        return RemoteWebDriverConnector.RemoteWebDriverConnectorType.valueOf(runConfigurationData.get(REMOTE_CONFIGURATION_TYPE_KEY));
    }

    private String getRemoteWebDriverUrl(Map<String, String> runConfigurationData) {
        return runConfigurationData.get(REMOTE_CONFIGURATION_KEY);
    }
}

