/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.report.provider;

import com.kms.katalon.composer.report.provider.ReportTestCaseTableViewer;
import com.kms.katalon.core.logging.model.ILogRecord;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class ReportTestCaseTableViewerFilter
extends ViewerFilter {
    public static final int INFO = 1;
    public static final int PASSED = 2;
    public static final int FAILED = 4;
    public static final int ERROR = 8;
    public static final int INCOMPLETE = 16;
    public static final int WARNING = 32;
    private boolean showInfo;
    private boolean showPassed;
    private boolean showFailed;
    private boolean showError;
    private boolean showIncomplete;
    private boolean showWarning;

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        ReportTestCaseTableViewer tablerView = (ReportTestCaseTableViewer)viewer;
        ILogRecord logRecord = (ILogRecord)element;
        if (!this.isElementMatchFilter(element)) {
            return false;
        }
        String searchString = tablerView.getSearchedString();
        if (StringUtils.isEmpty((String)searchString)) {
            return true;
        }
        if (StringUtils.isEmpty((String)logRecord.getName())) {
            return false;
        }
        String testCaseId = logRecord.getName();
        String testCaseName = testCaseId.substring(testCaseId.lastIndexOf("/") + 1, testCaseId.length());
        return testCaseName.toLowerCase().contains(searchString.toLowerCase().trim());
    }

    protected boolean isElementMatchFilter(Object element) {
        return (this.getLogValue((ILogRecord)element) & this.getFilterValue()) != 0;
    }

    protected int getLogValue(ILogRecord logRecord) {
        if (logRecord.getStatus() == null) {
            return 1;
        }
        switch (logRecord.getStatus().getStatusValue()) {
            case INCOMPLETE: {
                return 16;
            }
            case ERROR: {
                return 8;
            }
            case FAILED: {
                return 4;
            }
            case PASSED: {
                return 2;
            }
            case WARNING: {
                return 32;
            }
        }
        return 1;
    }

    protected int getFilterValue() {
        int filterInfo = this.showInfo ? 1 : 0;
        int filterPassed = this.showPassed ? 2 : 0;
        int filterFailed = this.showFailed ? 4 : 0;
        int filterError = this.showError ? 8 : 0;
        int filterIncomplete = this.showIncomplete ? 16 : 0;
        int filterWarning = this.showWarning ? 32 : 0;
        return filterInfo & 1 | filterPassed & 2 | filterFailed & 4 | filterError & 8 | filterIncomplete & 0x10 | filterWarning & 0x20;
    }

    public boolean isInfoShown() {
        return this.showInfo;
    }

    public void showInfo(boolean showInfo) {
        this.showInfo = showInfo;
    }

    public boolean isPassedShown() {
        return this.showPassed;
    }

    public void showPassed(boolean showPassed) {
        this.showPassed = showPassed;
    }

    public boolean isErrorShown() {
        return this.showError;
    }

    public void showError(boolean showError) {
        this.showError = showError;
    }

    public boolean isFailedShown() {
        return this.showFailed;
    }

    public void showFailed(boolean showFailed) {
        this.showFailed = showFailed;
    }

    public boolean isIncompleteShown() {
        return this.showIncomplete;
    }

    public void showIncomplete(boolean showIncomplete) {
        this.showIncomplete = showIncomplete;
    }

    public boolean isWarningShown() {
        return this.showWarning;
    }

    public void showWarning(boolean showWarning) {
        this.showWarning = showWarning;
    }
}

