/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.report.provider;

import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.report.constants.ImageConstants;
import com.kms.katalon.composer.report.parts.ReportPartTestLogView;
import com.kms.katalon.composer.report.provider.ReportTestStepTreeViewer;
import com.kms.katalon.core.logging.model.ILogRecord;
import com.kms.katalon.core.logging.model.MessageLogRecord;
import com.kms.katalon.core.logging.model.TestStatus;
import com.kms.katalon.core.logging.model.TestStepLogRecord;
import com.kms.katalon.core.util.internal.DateUtil;
import com.kms.katalon.core.util.internal.PathUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;

public class ReportPartTestStepLabelProvider
extends StyledCellLabelProvider {
    public static final int CLMN_TEST_LOG_ITEM_IDX = 0;
    public static final int CLMN_TEST_LOG_DESCRIPTION_IDX = 1;
    public static final int CLMN_TEST_LOG_ELAPSED_IDX = 2;
    public static final int CLMN_TEST_LOG_ATTACHMENT_IDX = 3;
    private int columnIndex;
    private ReportPartTestLogView reportPart;

    public ReportPartTestStepLabelProvider(int columnIndex, ReportPartTestLogView part) {
        this.columnIndex = columnIndex;
        this.reportPart = part;
    }

    private Image getImageForItemColumn(ILogRecord logRecord) {
        TestStatus testStatus = logRecord.getStatus();
        if (testStatus == null) {
            return null;
        }
        switch (testStatus.getStatusValue()) {
            case ERROR: {
                return ImageConstants.IMG_16_ERROR;
            }
            case FAILED: {
                return ImageConstants.IMG_16_FAILED;
            }
            case PASSED: {
                return ImageConstants.IMG_16_PASSED;
            }
            case INCOMPLETE: {
                return ImageConstants.IMG_16_INCOMPLETE;
            }
            case WARNING: {
                return ImageConstants.IMG_16_WARNING;
            }
            case INFO: {
                return ImageConstants.IMG_16_INFO;
            }
            case NOT_RUN: {
                return ImageConstants.IMG_16_NOT_RUN;
            }
        }
        return null;
    }

    private Image getImageForAttachmentColumn(ILogRecord logRecord) {
        if (!(logRecord instanceof MessageLogRecord)) {
            return null;
        }
        MessageLogRecord messageLog = (MessageLogRecord)logRecord;
        return StringUtils.isNotEmpty((CharSequence)messageLog.getAttachment()) ? ImageConstants.IMG_16_ATTACHMENT : null;
    }

    private boolean isValidElement(Object element) {
        return element instanceof ILogRecord && this.columnIndex >= 0 && this.columnIndex <= 3;
    }

    public Image getImage(Object element) {
        if (!this.isValidElement(element)) {
            return null;
        }
        ILogRecord logRecord = (ILogRecord)element;
        if (this.columnIndex == 0) {
            return this.getImageForItemColumn(logRecord);
        }
        if (this.columnIndex == 3) {
            return this.getImageForAttachmentColumn(logRecord);
        }
        return null;
    }

    public String getText(Object element) {
        if (!this.isValidElement(element)) {
            return "";
        }
        ILogRecord logRecord = (ILogRecord)element;
        switch (this.columnIndex) {
            case 0: {
                if (logRecord instanceof MessageLogRecord) {
                    return ((MessageLogRecord)element).getMessage();
                }
                String testStepName = ((ILogRecord)element).getName();
                if (logRecord instanceof TestStepLogRecord) {
                    String indexString = ((TestStepLogRecord)logRecord).getIndexString();
                    return String.valueOf(StringUtils.isNotEmpty((CharSequence)indexString) ? String.valueOf(indexString) + "." : "") + " " + testStepName;
                }
                return testStepName;
            }
            case 1: {
                return logRecord.getDescription() != null ? StringEscapeUtils.unescapeJava((String)logRecord.getDescription()) : "";
            }
            case 2: {
                if (logRecord.getStartTime() <= 0L || logRecord.getEndTime() <= 0L) break;
                return DateUtil.getElapsedTime((long)logRecord.getStartTime(), (long)logRecord.getEndTime());
            }
            case 3: {
                break;
            }
        }
        return "";
    }

    private StyledString getStyleString(Object element) {
        StyledString styledString = new StyledString();
        switch (this.columnIndex) {
            case 2: {
                styledString.append(this.getText(element), StyledString.COUNTER_STYLER);
                break;
            }
            default: {
                styledString.append(this.getText(element));
            }
        }
        return styledString;
    }

    public void update(ViewerCell cell) {
        if (cell.getElement() != null) {
            ReportTestStepTreeViewer tableViewer;
            String searchedString;
            StyledString styledString = this.getStyleString(cell.getElement());
            cell.setText(styledString.toString());
            cell.setImage(this.getImage(cell.getElement()));
            ArrayList<StyleRange> range = new ArrayList<StyleRange>();
            range.addAll(Arrays.asList(styledString.getStyleRanges()));
            if (!(this.columnIndex != 0 && this.columnIndex != 1 || (searchedString = (tableViewer = (ReportTestStepTreeViewer)this.getViewer()).getSearchedString().toLowerCase().trim()).isEmpty())) {
                Matcher m = Pattern.compile(Pattern.quote(searchedString)).matcher(cell.getText().toLowerCase());
                while (m.find()) {
                    StyleRange myStyledRange = new StyleRange(m.start(), searchedString.length(), null, ColorUtil.getHighlightBackgroundColor());
                    range.add(myStyledRange);
                }
            }
            cell.setStyleRanges(range.toArray(new StyleRange[0]));
        }
        super.update(cell);
    }

    public String getToolTipText(Object element) {
        if (element == null) {
            return null;
        }
        return this.getText((ILogRecord)element);
    }

    public Image getToolTipImage(Object element) {
        if (this.columnIndex == 3 && element instanceof MessageLogRecord && this.reportPart.getReport() != null) {
            MessageLogRecord messageLog = (MessageLogRecord)element;
            return new Image((Device)this.getColumn().getViewer().getControl().getDisplay(), PathUtil.relativeToAbsolutePath((String)messageLog.getAttachment(), (String)this.reportPart.getReport().getLocation()));
        }
        return null;
    }
}

