/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.report.provider;

import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.report.constants.ImageConstants;
import com.kms.katalon.composer.report.provider.ReportTestCaseTableViewer;
import com.kms.katalon.core.logging.model.ILogRecord;
import com.kms.katalon.core.util.internal.DateUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Image;

public class ReportPartTestCaseLabelProvider
extends StyledCellLabelProvider {
    public static final int CLMN_TEST_CASE_ORDER = 0;
    public static final int CLMN_TEST_CASE_NAME = 1;
    public static final int CLMN_TEST_CASE_VIDEO = 2;
    public static final int CLMN_TEST_CASE_INTEGRATION = 3;

    public Image getImage(Object element, int columnIndex) {
        if (element == null || !(element instanceof ILogRecord)) {
            return null;
        }
        switch (columnIndex) {
            case 1: {
                ILogRecord logRecord = (ILogRecord)element;
                switch (logRecord.getStatus().getStatusValue()) {
                    case ERROR: {
                        return ImageConstants.IMG_16_ERROR;
                    }
                    case FAILED: {
                        return ImageConstants.IMG_16_FAILED;
                    }
                    case PASSED: {
                        return ImageConstants.IMG_16_PASSED;
                    }
                    case INCOMPLETE: {
                        return ImageConstants.IMG_16_INCOMPLETE;
                    }
                }
            }
        }
        return null;
    }

    private int getOrder(ILogRecord[] testCaseLogRecords, ILogRecord testCaseLogRecord) {
        int index = 0;
        while (index < testCaseLogRecords.length) {
            if (testCaseLogRecord.equals(testCaseLogRecords[index])) {
                return index + 1;
            }
            ++index;
        }
        return 0;
    }

    private StyledString getText(ILogRecord logRecord, int columnIndex) {
        StyledString styledString = new StyledString();
        switch (columnIndex) {
            case 0: {
                styledString.append(Integer.toString(this.getOrder((ILogRecord[])this.getViewer().getInput(), logRecord)));
                break;
            }
            case 1: {
                String testCaseId = logRecord.getName();
                String testCaseName = testCaseId.substring(testCaseId.lastIndexOf("/") + 1, testCaseId.length());
                styledString.append(testCaseName);
                String eslapsedTime = DateUtil.getElapsedTime((long)logRecord.getStartTime(), (long)logRecord.getEndTime());
                if (StringUtils.isBlank((String)eslapsedTime)) break;
                styledString.append(" (" + eslapsedTime + ")", StyledString.COUNTER_STYLER);
                break;
            }
        }
        return styledString;
    }

    public void update(ViewerCell cell) {
        if (cell.getElement() != null) {
            ReportTestCaseTableViewer tableViewer;
            String searchedString;
            cell.setImage(this.getImage(cell.getElement(), cell.getColumnIndex()));
            ArrayList<StyleRange> range = new ArrayList<StyleRange>();
            StyledString styledString = this.getText((ILogRecord)cell.getElement(), cell.getColumnIndex());
            cell.setText(styledString.toString());
            range.addAll(Arrays.asList(styledString.getStyleRanges()));
            if (cell.getColumnIndex() == 1 && !(searchedString = (tableViewer = (ReportTestCaseTableViewer)this.getViewer()).getSearchedString().toLowerCase().trim()).isEmpty()) {
                Matcher m = Pattern.compile(Pattern.quote(searchedString)).matcher(cell.getText().toLowerCase());
                while (m.find()) {
                    StyleRange myStyledRange = new StyleRange(m.start(), searchedString.length(), null, ColorUtil.getHighlightBackgroundColor());
                    range.add(myStyledRange);
                }
            }
            cell.setStyleRanges(range.toArray(new StyleRange[0]));
        }
        super.update(cell);
    }

    public String getToolTipText(Object element) {
        return null;
    }
}

