/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.report.provider;

import com.kms.katalon.composer.components.impl.providers.TypeCheckedStyleCellLabelProvider;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.util.ImageUtil;
import com.kms.katalon.composer.execution.collection.collector.TestExecutionGroupCollector;
import com.kms.katalon.composer.execution.collection.provider.TestExecutionConfigurationProvider;
import com.kms.katalon.composer.report.constants.StringConstants;
import com.kms.katalon.composer.report.provider.ReportItemDescriptionLabelProvider;
import com.kms.katalon.core.logging.model.TestSuiteLogRecord;
import com.kms.katalon.entity.report.ReportItemDescription;
import com.kms.katalon.entity.testsuite.RunConfigurationDescription;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import java.net.MalformedURLException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class ReportCollectionTableLabelProvider
extends TypeCheckedStyleCellLabelProvider<ReportItemDescription>
implements ReportItemDescriptionLabelProvider {
    public static final int CLM_NO_IDX = 0;
    public static final int CLM_ID_IDX = 1;
    public static final int CLM_EVN_IDX = 2;
    public static final int CLM_STATUS_IDX = 3;
    public static final int CLM_FAILED_TESTS_IDX = 4;
    public static final int CLM_ACTION_IDX = 5;

    public ReportCollectionTableLabelProvider(int columnIndex) {
        super(columnIndex);
    }

    protected Class<ReportItemDescription> getElementType() {
        return ReportItemDescription.class;
    }

    protected Image getImage(ReportItemDescription element) {
        switch (this.columnIndex) {
            case 2: {
                return this.getImageForRunConfigurationColumn(element.getRunConfigDescription());
            }
        }
        return null;
    }

    protected String getText(ReportItemDescription element) {
        List input = (List)this.getViewer().getInput();
        switch (this.columnIndex) {
            case 0: {
                return Integer.toString(input.indexOf(element) + 1);
            }
            case 1: {
                TestSuiteEntity testSuite = this.getTestSuite(element);
                return testSuite != null ? testSuite.getIdForDisplay() : "";
            }
            case 2: {
                return element.getRunConfigDescription().getRunConfigurationId();
            }
            case 3: {
                TestSuiteLogRecord logRecord = this.getTestSuiteLogRecord(element.getReportLocation());
                if (logRecord == null) {
                    return StringConstants.NOT_STARTED;
                }
                if (logRecord.getTotalIncompleteTestCases() > 0) {
                    return StringConstants.INCOMPLETE;
                }
                return StringConstants.COMPLETE;
            }
            case 4: {
                TestSuiteLogRecord logRecord = this.getTestSuiteLogRecord(element.getReportLocation());
                if (logRecord == null) {
                    return "";
                }
                int numPassed = logRecord.getTotalFailedTestCases() + logRecord.getTotalErrorTestCases();
                return String.valueOf(Integer.toString(numPassed)) + "/" + logRecord.getTotalTestCases();
            }
        }
        return "";
    }

    private Image getImageForRunConfigurationColumn(RunConfigurationDescription configuration) {
        TestExecutionConfigurationProvider executionProvider = TestExecutionGroupCollector.getInstance().getExecutionProvider(configuration);
        try {
            return executionProvider != null ? ImageUtil.loadImage((String)executionProvider.getImageUrlAsString()) : null;
        }
        catch (MalformedURLException e) {
            LoggerSingleton.logError((Throwable)e);
            return null;
        }
    }

    protected Color getBackground(Color background, ReportItemDescription element) {
        TestSuiteLogRecord logRecord = this.getTestSuiteLogRecord(element.getReportLocation());
        switch (this.columnIndex) {
            case 3: {
                return this.getBackgroundForStatusColumn(background, logRecord);
            }
            case 4: {
                return this.getBackgroundForFailedTestsColumn(background, logRecord);
            }
        }
        return super.getBackground(background, (Object)element);
    }

    private Color getBackgroundForFailedTestsColumn(Color background, TestSuiteLogRecord logRecord) {
        if (logRecord == null) {
            return background;
        }
        if (logRecord.getTotalFailedTestCases() + logRecord.getTotalErrorTestCases() > 0) {
            return ColorUtil.getFailedStatusBackgroundColor();
        }
        return background;
    }

    private Color getBackgroundForStatusColumn(Color background, TestSuiteLogRecord logRecord) {
        if (logRecord == null) {
            return ColorUtil.getDisabledItemBackgroundColor();
        }
        if (logRecord.getTotalIncompleteTestCases() > 0) {
            return ColorUtil.getIncompleteStatusBackgroundColor();
        }
        return background;
    }

    protected String getElementToolTipText(ReportItemDescription element) {
        return StringUtils.defaultIfEmpty((String)this.getText(element), null);
    }
}

