/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.report.preference;

import com.kms.katalon.composer.components.dialogs.PreferencePageWithHelp;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.report.constants.ComposerReportMessageConstants;
import com.kms.katalon.composer.report.constants.StringConstants;
import com.kms.katalon.constants.DocumentationMessageConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.helper.screenrecorder.VideoFileFormat;
import com.kms.katalon.core.helper.screenrecorder.VideoQuality;
import com.kms.katalon.core.setting.VideoRecorderSetting;
import com.kms.katalon.execution.setting.ExecutionSettingStore;
import java.io.IOException;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ReportSettingPage
extends PreferencePageWithHelp {
    private static final String[] VIDEO_FORMAT_ITEMS = Arrays.asList(VideoFileFormat.values()).stream().map(format -> format.toString()).collect(Collectors.toList()).toArray(new String[0]);
    private static final String[] VIDEO_QUALITY_ITEMS = Arrays.asList(VideoQuality.values()).stream().map(format -> format.getReadableName()).collect(Collectors.toList()).toArray(new String[0]);
    private Composite container;
    private Button btnCheckButton;
    private Button btnEnableVideoRecorder;
    private Combo cbbVideoFormat;
    private Combo cbbVideoQuality;
    private Button btnRecordIfPassed;
    private Button btnRecordIfFailed;
    private Composite videoRecorderComposite;
    private ExecutionSettingStore store = new ExecutionSettingStore(ProjectController.getInstance().getCurrentProject());

    protected Control createContents(Composite parent) {
        this.container = new Composite(parent, 0);
        this.container.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.container.setLayout((Layout)new GridLayout(1, false));
        this.btnCheckButton = new Button(this.container, 32);
        this.btnCheckButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnCheckButton.setText(StringConstants.PAGE_TXT_ENABLE_TAKE_SCREENSHOT);
        Group grpVideoRecorder = new Group(this.container, 0);
        GridLayout glGrpVideoRecorder = new GridLayout();
        grpVideoRecorder.setLayout((Layout)glGrpVideoRecorder);
        grpVideoRecorder.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        grpVideoRecorder.setText(ComposerReportMessageConstants.PREF_TITLE_VIDEO_RECORDER);
        this.btnEnableVideoRecorder = new Button((Composite)grpVideoRecorder, 32);
        this.btnEnableVideoRecorder.setText(ComposerReportMessageConstants.PREF_CHCK_ENABLE_VIDEO_RECORDER);
        this.videoRecorderComposite = new Composite((Composite)grpVideoRecorder, 0);
        this.videoRecorderComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout videoRecorderLayout = new GridLayout(2, false);
        videoRecorderLayout.horizontalSpacing = 15;
        videoRecorderLayout.marginLeft = 5;
        this.videoRecorderComposite.setLayout((Layout)videoRecorderLayout);
        this.btnRecordIfPassed = new Button(this.videoRecorderComposite, 32);
        this.btnRecordIfPassed.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        this.btnRecordIfPassed.setText(ComposerReportMessageConstants.PREF_CHCK_RECORD_IF_PASSED);
        this.btnRecordIfFailed = new Button(this.videoRecorderComposite, 32);
        this.btnRecordIfFailed.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        this.btnRecordIfFailed.setText(ComposerReportMessageConstants.PREF_CHCK_RECORD_IF_FAILED);
        Label lblFormat = new Label(this.videoRecorderComposite, 0);
        lblFormat.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        lblFormat.setText(ComposerReportMessageConstants.PREF_LBL_VIDEO_FORMAT);
        this.cbbVideoFormat = new Combo(this.videoRecorderComposite, 8);
        GridData gdCbbVideoFormat = new GridData(16384, 0x1000000, false, false, 1, 1);
        gdCbbVideoFormat.widthHint = 200;
        this.cbbVideoFormat.setLayoutData((Object)gdCbbVideoFormat);
        this.cbbVideoFormat.setItems(VIDEO_FORMAT_ITEMS);
        Label lblQuality = new Label(this.videoRecorderComposite, 0);
        lblQuality.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        lblQuality.setText(ComposerReportMessageConstants.PREF_LBL_VIDEO_QUALITY);
        this.cbbVideoQuality = new Combo(this.videoRecorderComposite, 8);
        GridData gdCbbVideoQuality = new GridData(16384, 0x1000000, false, false, 1, 1);
        gdCbbVideoQuality.widthHint = 200;
        this.cbbVideoQuality.setLayoutData((Object)gdCbbVideoQuality);
        this.cbbVideoQuality.setItems(VIDEO_QUALITY_ITEMS);
        this.registerControlModifyListeners();
        this.updateInput();
        return this.container;
    }

    private void registerControlModifyListeners() {
        this.btnEnableVideoRecorder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ControlUtils.recursiveSetEnabled((Control)ReportSettingPage.this.videoRecorderComposite, (boolean)ReportSettingPage.this.btnEnableVideoRecorder.getSelection());
            }
        });
    }

    private void updateInput() {
        try {
            this.btnCheckButton.setSelection(this.store.getScreenCaptureOption());
            VideoRecorderSetting videoSetting = this.store.getVideoRecorderSetting();
            this.btnEnableVideoRecorder.setSelection(videoSetting.isEnable());
            this.btnRecordIfPassed.setSelection(videoSetting.isAllowedRecordIfPassed());
            this.btnRecordIfFailed.setSelection(videoSetting.isAllowedRecordIfFailed());
            this.cbbVideoFormat.select(videoSetting.getVideoFormat().ordinal());
            this.cbbVideoQuality.select(videoSetting.getVideoQuality().ordinal());
            ControlUtils.recursiveSetEnabled((Control)this.videoRecorderComposite, (boolean)this.btnEnableVideoRecorder.getSelection());
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
            MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)StringConstants.PAGE_ERROR_MSG_UNABLE_TO_READ_SETTINGS, (String)e.getMessage());
        }
    }

    protected void performDefaults() {
        this.updateInput();
        super.performApply();
    }

    public boolean performOk() {
        if (this.container == null || this.container.isDisposed()) {
            return true;
        }
        try {
            this.store.setScreenCaptureOption(this.btnCheckButton.getSelection());
            VideoRecorderSetting videoSetting = new VideoRecorderSetting();
            videoSetting.setEnable(this.btnEnableVideoRecorder.getSelection());
            videoSetting.setAllowedRecordIfPassed(this.btnRecordIfPassed.getSelection());
            videoSetting.setAllowedRecordIfFailed(this.btnRecordIfFailed.getSelection());
            videoSetting.setVideoFormat(VideoFileFormat.values()[this.cbbVideoFormat.getSelectionIndex()]);
            videoSetting.setVideoQuality(VideoQuality.values()[this.cbbVideoQuality.getSelectionIndex()]);
            this.store.setVideoRecorderSetting(videoSetting);
            return true;
        }
        catch (IOException e) {
            MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)StringConstants.PAGE_ERROR_MSG_UNABLE_TO_UPDATE_SETTINGS, (String)e.getMessage());
            return false;
        }
    }

    public boolean hasDocumentation() {
        return true;
    }

    public String getDocumentationUrl() {
        return DocumentationMessageConstants.SETTING_REPORT;
    }
}

