/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.report.parts;

import com.kms.katalon.composer.components.controls.HelpToolBarForMPart;
import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.util.EntityPartUtil;
import com.kms.katalon.composer.components.impl.util.EventUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.part.IComposerPartEvent;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.integration.analytics.constants.ComposerAnalyticsStringConstants;
import com.kms.katalon.composer.integration.analytics.dialog.AuthenticationDialog;
import com.kms.katalon.composer.integration.analytics.dialog.UploadSelectionDialog;
import com.kms.katalon.composer.report.constants.ComposerReportMessageConstants;
import com.kms.katalon.composer.report.constants.ImageConstants;
import com.kms.katalon.composer.report.constants.StringConstants;
import com.kms.katalon.composer.report.handlers.AnalyticsAuthorizationHandler;
import com.kms.katalon.composer.report.integration.ReportComposerIntegrationFactory;
import com.kms.katalon.composer.report.lookup.LogRecordLookup;
import com.kms.katalon.composer.report.parts.ReportPartTestLogView;
import com.kms.katalon.composer.report.parts.integration.ReportTestCaseIntegrationViewBuilder;
import com.kms.katalon.composer.report.parts.integration.TestCaseLogDetailsIntegrationView;
import com.kms.katalon.composer.report.provider.HyperlinkTestCaseVideoLabelProvider;
import com.kms.katalon.composer.report.provider.ReportPartTestCaseLabelProvider;
import com.kms.katalon.composer.report.provider.ReportTestCaseTableViewer;
import com.kms.katalon.composer.report.provider.ReportTestCaseTableViewerFilter;
import com.kms.katalon.composer.resources.image.ImageManager;
import com.kms.katalon.composer.testcase.constants.ComposerTestcaseMessageConstants;
import com.kms.katalon.constants.DocumentationMessageConstants;
import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.ReportController;
import com.kms.katalon.controller.TestSuiteController;
import com.kms.katalon.core.logging.model.ILogRecord;
import com.kms.katalon.core.logging.model.TestSuiteLogRecord;
import com.kms.katalon.core.reporting.ReportUtil;
import com.kms.katalon.core.util.internal.DateUtil;
import com.kms.katalon.entity.IEntity;
import com.kms.katalon.entity.report.ReportEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.execution.util.ExecutionUtil;
import com.kms.katalon.integration.analytics.entity.AnalyticsProject;
import com.kms.katalon.integration.analytics.entity.AnalyticsTeam;
import com.kms.katalon.integration.analytics.entity.AnalyticsTokenInfo;
import com.kms.katalon.integration.analytics.exceptions.AnalyticsApiExeception;
import com.kms.katalon.integration.analytics.report.AnalyticsReportService;
import com.kms.katalon.integration.analytics.setting.AnalyticsSettingStore;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import com.kms.katalon.tracking.service.Trackings;
import com.kms.katalon.util.CryptoUtil;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class ReportPart
implements EventHandler,
IComposerPartEvent {
    private static final String BTN_SHOW_TEST_CASE_DETAILS = ComposerReportMessageConstants.BTN_SHOW_TEST_CASE_DETAILS;
    private static final String BTN_HIDE_TEST_CASE_DETAILS = ComposerReportMessageConstants.BTN_HIDE_TEST_CASE_DETAILS;
    private static AnalyticsTokenInfo tokenInfo;
    @Inject
    private IEventBroker eventBroker;
    private StyledText txtTestSuiteId;
    private StyledText txtHostName;
    private StyledText txtOS;
    private StyledText txtPlatform;
    private StyledText txtStartTime;
    private StyledText txtEndTime;
    private StyledText txtRunTime;
    private StyledText txtKatalonVersion;
    private StyledText txtTotalTestCase;
    private StyledText txtTCPasses;
    private StyledText txtTCFailures;
    private StyledText txtTCIncompleted;
    private StyledText txtTCErrors;
    private TestSuiteLogRecord testSuiteLogRecord;
    private ReportTestCaseTableViewer testCaseTableViewer;
    private Text txtTestCaseSearch;
    private CLabel lblTestCaseSearch;
    private ReportTestCaseTableViewerFilter testCaseTableFilter;
    private Button btnFilterTestCasePassed;
    private Button btnFilterTestCaseFailed;
    private Button btnFilterTestCaseError;
    private Button btnFilterTestCaseIncomplete;
    private ToolItem btnShowHideTestCaseDetails;
    private ToolItem btnUploadToAnalytics;
    private TableViewer runDataTable;
    private TableViewer executionSettingTable;
    private ReportPartTestLogView testLogView;
    private Map<String, TestCaseLogDetailsIntegrationView> integratingCompositeMap;
    private int selectedTestCaseRecordIndex;
    private boolean isSearching;
    private ReportEntity report;
    @Inject
    private Shell shell;
    @Inject
    private MPart mpart;
    private SashForm sashForm;
    private SashForm sashFormSummary;
    private Composite compositeTestCaseFilterSelection;
    private AnalyticsReportService analyticsReportService = new AnalyticsReportService();
    private MenuItem uploadMenuItem;
    private List<TableViewerColumn> testCaseIntergrationColumn;
    private TableColumnLayout tclCompositeTestCaseTableDetails;

    @PostConstruct
    public void init(Composite parent, ReportEntity report, MPart part) {
        this.report = report;
        this.setTestSuiteLogRecord(LogRecordLookup.getInstance().getTestSuiteLogRecord(report, (IProgressMonitor)new NullProgressMonitor()));
        this.testLogView = new ReportPartTestLogView(this);
        this.isSearching = false;
        this.registerListeners();
        new HelpToolBarForMPart(part, DocumentationMessageConstants.REPORT_TEST_SUITE);
        this.createControls(parent);
        this.registerControlModifyListeners();
        this.updateInput();
        this.setPartLabel(report.getDisplayName());
    }

    private void registerControlModifyListeners() {
        this.testCaseTableViewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ILogRecord selectedLogRecord = ReportPart.this.getSelectedTestCaseLogRecord();
                if (selectedLogRecord == null) {
                    return;
                }
                ReportPart.this.testLogView.updateSelectedTestCase(selectedLogRecord);
            }
        });
        this.btnFilterTestCasePassed.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReportPart.this.testCaseTableFilter.showPassed(ReportPart.this.btnFilterTestCasePassed.getSelection());
                ReportPart.this.testCaseTableViewer.refresh();
                ReportPart.this.testLogView.updateSelectedTestCase(ReportPart.this.getSelectedTestCaseLogRecord());
            }
        });
        this.btnFilterTestCaseFailed.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReportPart.this.testCaseTableFilter.showFailed(ReportPart.this.btnFilterTestCaseFailed.getSelection());
                ReportPart.this.testCaseTableViewer.refresh();
                ReportPart.this.testLogView.updateSelectedTestCase(ReportPart.this.getSelectedTestCaseLogRecord());
            }
        });
        this.btnFilterTestCaseError.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReportPart.this.testCaseTableFilter.showError(ReportPart.this.btnFilterTestCaseError.getSelection());
                ReportPart.this.testCaseTableViewer.refresh();
                ReportPart.this.testLogView.updateSelectedTestCase(ReportPart.this.getSelectedTestCaseLogRecord());
            }
        });
        this.btnFilterTestCaseIncomplete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReportPart.this.testCaseTableFilter.showIncomplete(ReportPart.this.btnFilterTestCaseIncomplete.getSelection());
                ReportPart.this.testCaseTableViewer.refresh();
                ReportPart.this.testLogView.updateSelectedTestCase(ReportPart.this.getSelectedTestCaseLogRecord());
            }
        });
        this.btnShowHideTestCaseDetails.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReportPart.this.setTestCaseDetailsVisible(BTN_SHOW_TEST_CASE_DETAILS.equals(ReportPart.this.btnShowHideTestCaseDetails.getText()));
            }
        });
        this.txtTestCaseSearch.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    ReportPart.this.filterTestLogBySearchedText();
                }
            }
        });
        this.lblTestCaseSearch.addListener(4, new Listener(){

            public void handleEvent(org.eclipse.swt.widgets.Event event) {
                if (ReportPart.this.isSearching) {
                    ReportPart.this.txtTestCaseSearch.setText("");
                }
                ReportPart.this.filterTestLogBySearchedText();
            }
        });
        this.testCaseTableViewer.getTable().addListener(3, new Listener(){

            public void handleEvent(org.eclipse.swt.widgets.Event event) {
                if (event.button == 3) {
                    ReportPart.this.createTestCaseTableContextMenuByIntegrationViews();
                }
            }
        });
        this.testLogView.registerControlModifyListener();
    }

    private void createTestCaseTableContextMenuByIntegrationViews() {
        Table testCaseTable = this.testCaseTableViewer.getTable();
        if (testCaseTable.getMenu() != null) {
            testCaseTable.getMenu().dispose();
        }
        Menu contextMenu = new Menu((Control)testCaseTable);
        testCaseTable.setMenu(contextMenu);
        for (TestCaseLogDetailsIntegrationView integrationView : this.integratingCompositeMap.values()) {
            if (integrationView == null) continue;
            integrationView.createTableContextMenu(contextMenu, this.testCaseTableViewer.getSelection());
        }
    }

    public void clearMouseDownListener(StyledText styleText) {
        while (styleText.getListeners(3).length > 1) {
            styleText.removeListener(3, styleText.getListeners(3)[styleText.getListeners(3).length - 1]);
        }
    }

    private void registerTxtTestSuiteClickListener() {
        StyleRange range = new StyleRange();
        range.start = 0;
        range.length = this.txtTestSuiteId.getText().length();
        range.underline = true;
        range.data = this.txtTestSuiteId.getText();
        range.underlineStyle = 4;
        this.txtTestSuiteId.setStyleRanges(new StyleRange[]{range});
        this.txtTestSuiteId.addListener(3, new Listener(){

            public void handleEvent(org.eclipse.swt.widgets.Event event) {
                try {
                    TestSuiteEntity testSuite;
                    int offset = ReportPart.this.txtTestSuiteId.getOffsetAtLocation(new Point(event.x, event.y));
                    StyleRange style = ReportPart.this.txtTestSuiteId.getStyleRangeAtOffset(offset);
                    if (style != null && style.underline && style.underlineStyle == 4 && (testSuite = TestSuiteController.getInstance().getTestSuiteByDisplayId((String)style.data, ProjectController.getInstance().getCurrentProject())) != null) {
                        EventBrokerSingleton.getInstance().getEventBroker().post("TESTSUITE/OPEN", (Object)testSuite);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (Exception exception) {
                    MessageDialog.openWarning(null, (String)"Warning", (String)"Test suite not found.");
                }
            }
        });
    }

    public void updateReportAndInput(final ReportEntity report) {
        this.report = report;
        if (report == null) {
            return;
        }
        try {
            new ProgressMonitorDialog(this.shell).run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    ReportPart.this.setTestSuiteLogRecord(LogRecordLookup.getInstance().getTestSuiteLogRecord(report, monitor));
                    UISynchronizeService.syncExec(() -> ReportPart.this.updateInput());
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public void updateInput() {
        try {
            if (this.testSuiteLogRecord == null) {
                this.closeThisPart();
                return;
            }
            try {
                TestSuiteEntity testSuite = ReportController.getInstance().getTestSuiteByReport(this.report);
                this.clearMouseDownListener(this.txtTestSuiteId);
                if (testSuite != null) {
                    this.txtTestSuiteId.setText(testSuite.getIdForDisplay());
                    this.registerTxtTestSuiteClickListener();
                } else {
                    this.txtTestSuiteId.setText(this.testSuiteLogRecord.getSource());
                }
            }
            catch (Exception exception) {
                this.txtTestSuiteId.setText(this.testSuiteLogRecord.getSource());
            }
            if (this.testSuiteLogRecord.getHostName() != null && !this.testSuiteLogRecord.getHostName().isEmpty()) {
                this.txtHostName.setText(this.testSuiteLogRecord.getHostName());
            } else {
                this.txtHostName.setText(ReportUtil.getHostName());
            }
            if (this.testSuiteLogRecord.getOs() != null && !this.testSuiteLogRecord.getOs().isEmpty()) {
                this.txtOS.setText(this.testSuiteLogRecord.getOs());
            } else {
                this.txtOS.setText(ReportUtil.getOs());
            }
            this.txtKatalonVersion.setText(this.testSuiteLogRecord.getAppVersion());
            if (this.testSuiteLogRecord.getBrowser() != null && !this.testSuiteLogRecord.getBrowser().isEmpty()) {
                this.txtPlatform.setText(this.testSuiteLogRecord.getBrowser());
            } else {
                this.txtPlatform.setText(this.testSuiteLogRecord.getDevicePlatform());
            }
            int totalTestCases = this.testSuiteLogRecord.getTotalTestCases();
            this.txtTotalTestCase.setText(Integer.toString(totalTestCases));
            this.txtTCPasses.setText(Integer.toString(this.testSuiteLogRecord.getTotalPassedTestCases()));
            this.txtTCFailures.setText(Integer.toString(this.testSuiteLogRecord.getTotalFailedTestCases()));
            this.txtTCErrors.setText(Integer.toString(this.testSuiteLogRecord.getTotalErrorTestCases()));
            this.txtTCIncompleted.setText(Integer.toString(this.testSuiteLogRecord.getTotalIncompleteTestCases()));
            this.txtStartTime.setText(DateUtil.getDateTimeFormatted((long)this.testSuiteLogRecord.getStartTime()));
            this.txtEndTime.setText(DateUtil.getDateTimeFormatted((long)this.testSuiteLogRecord.getEndTime()));
            StyledString styleStringElapsed = new StyledString(DateUtil.getElapsedTime((long)this.testSuiteLogRecord.getStartTime(), (long)this.testSuiteLogRecord.getEndTime()), StyledString.COUNTER_STYLER);
            this.txtRunTime.setText(styleStringElapsed.getString());
            this.txtRunTime.setStyleRanges(styleStringElapsed.getStyleRanges());
            this.integratingCompositeMap = new HashMap<String, TestCaseLogDetailsIntegrationView>();
            for (ReportTestCaseIntegrationViewBuilder builder : ReportComposerIntegrationFactory.getInstance().getSortedBuilder()) {
                TestCaseLogDetailsIntegrationView integrationDetails;
                if (!builder.isIntegrationEnabled(ProjectController.getInstance().getCurrentProject()) || (integrationDetails = builder.getIntegrationDetails(this.report, this.testSuiteLogRecord)) == null) continue;
                this.integratingCompositeMap.put(builder.getName(), integrationDetails);
            }
            this.createIntegrationColumns();
            this.createTestCaseTableContextMenuByIntegrationViews();
            this.testCaseTableViewer.setInput(this.testSuiteLogRecord.getChildRecords());
            this.testLogView.loadTestCaseIntegrationToolbar(this.report, this.testSuiteLogRecord);
            this.runDataTable.setInput(this.testSuiteLogRecord.getRunData() != null ? this.testSuiteLogRecord.getRunData().entrySet() : null);
            this.runDataTable.refresh();
            File executionSettingFile = ReportController.getInstance().getExecutionSettingFile(this.report.getLocation());
            this.executionSettingTable.setInput(ExecutionUtil.readRunConfigSettingFromFile((String)executionSettingFile.getAbsolutePath()).entrySet());
            this.executionSettingTable.refresh();
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private void closeThisPart() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                EntityPartUtil.closePart((IEntity)ReportPart.this.getReport());
            }
        });
    }

    private void setTestSuiteLogRecord(TestSuiteLogRecord logRecord) {
        this.testSuiteLogRecord = logRecord;
    }

    public TestSuiteLogRecord getTestSuiteLogRecord() {
        return this.testSuiteLogRecord;
    }

    public ILogRecord getSelectedTestCaseLogRecord() {
        StructuredSelection selection = (StructuredSelection)this.testCaseTableViewer.getSelection();
        if (selection == null || selection.size() != 1) {
            return null;
        }
        return (ILogRecord)selection.getFirstElement();
    }

    private void createCompositeTestCaseFilter(Composite compositeTestCaseTree) {
        Composite compositeTestCaseFilter = new Composite(compositeTestCaseTree, 0);
        GridLayout gl_compositeTestCaseFilter = new GridLayout(1, false);
        gl_compositeTestCaseFilter.marginHeight = 0;
        compositeTestCaseFilter.setLayout((Layout)gl_compositeTestCaseFilter);
        compositeTestCaseFilter.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.compositeTestCaseFilterSelection = new Composite(compositeTestCaseFilter, 0);
        this.compositeTestCaseFilterSelection.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.compositeTestCaseFilterSelection.setLayout((Layout)new GridLayout(6, false));
        this.btnFilterTestCasePassed = new Button(this.compositeTestCaseFilterSelection, 32);
        this.btnFilterTestCasePassed.setText("Passed");
        this.btnFilterTestCasePassed.setImage(ImageConstants.IMG_16_PASSED);
        this.btnFilterTestCasePassed.setSelection(true);
        this.btnFilterTestCaseFailed = new Button(this.compositeTestCaseFilterSelection, 32);
        this.btnFilterTestCaseFailed.setText("Failed");
        this.btnFilterTestCaseFailed.setImage(ImageConstants.IMG_16_FAILED);
        this.btnFilterTestCaseFailed.setSelection(true);
        this.btnFilterTestCaseError = new Button(this.compositeTestCaseFilterSelection, 32);
        this.btnFilterTestCaseError.setText("Error");
        this.btnFilterTestCaseError.setImage(ImageConstants.IMG_16_ERROR);
        this.btnFilterTestCaseError.setSelection(true);
        this.btnFilterTestCaseIncomplete = new Button(this.compositeTestCaseFilterSelection, 32);
        this.btnFilterTestCaseIncomplete.setText("Incomplete");
        this.btnFilterTestCaseIncomplete.setImage(ImageConstants.IMG_16_INCOMPLETE);
        this.btnFilterTestCaseIncomplete.setSelection(true);
        Label spacer = new Label(this.compositeTestCaseFilterSelection, 0);
        spacer.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ToolBar tbShowHideDetails = new ToolBar(this.compositeTestCaseFilterSelection, 0x820000);
        this.createKatalonAnalyticsMenu(tbShowHideDetails);
        this.btnShowHideTestCaseDetails = new ToolItem(tbShowHideDetails, 0);
        this.btnShowHideTestCaseDetails.setText(BTN_SHOW_TEST_CASE_DETAILS);
        this.btnShowHideTestCaseDetails.setImage(ImageManager.getImage((String)"move_left_16.png"));
        Composite compositeTableTestCaseSearch = new Composite(compositeTestCaseFilter, 2048);
        compositeTableTestCaseSearch.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        compositeTableTestCaseSearch.setBackground(ColorUtil.getWhiteBackgroundColor());
        GridLayout gl_compositeTableTestCaseSearch = new GridLayout(2, false);
        gl_compositeTableTestCaseSearch.marginWidth = 0;
        gl_compositeTableTestCaseSearch.marginHeight = 0;
        compositeTableTestCaseSearch.setLayout((Layout)gl_compositeTableTestCaseSearch);
        this.txtTestCaseSearch = new Text(compositeTableTestCaseSearch, 0);
        this.txtTestCaseSearch.setMessage(StringConstants.PA_SEARCH_TEXT_DEFAULT_VALUE);
        GridData gd_txtTestCaseSearch = new GridData(768);
        gd_txtTestCaseSearch.grabExcessVerticalSpace = true;
        gd_txtTestCaseSearch.verticalAlignment = 0x1000000;
        this.txtTestCaseSearch.setLayoutData((Object)gd_txtTestCaseSearch);
        Canvas canvasTestCaseSearch = new Canvas(compositeTableTestCaseSearch, 0);
        canvasTestCaseSearch.setLayout((Layout)new FillLayout(256));
        this.lblTestCaseSearch = new CLabel((Composite)canvasTestCaseSearch, 0);
        this.lblTestCaseSearch.setCursor(new Cursor((Device)Display.getCurrent(), 21));
        this.updateStatusSearchLabel();
    }

    private ScopedPreferenceStore getPreferenceStore() {
        return PreferenceStoreManager.getPreferenceStore((String)"com.kms.katalon.activation.dialog");
    }

    private void createKatalonAnalyticsMenu(ToolBar toolBar) {
        final AnalyticsSettingStore analyticsSettingStore = new AnalyticsSettingStore(ProjectController.getInstance().getCurrentProject().getFolderLocation());
        final ScopedPreferenceStore preferenceStore = this.getPreferenceStore();
        this.btnUploadToAnalytics = new ToolItem(toolBar, 4);
        this.btnUploadToAnalytics.setText(ComposerReportMessageConstants.BTN_KATALON_ANALYTICS);
        this.btnUploadToAnalytics.setImage(ImageManager.getImage((String)"katalon_analytics_16.png"));
        final Menu katalonAnalyticsMenu = new Menu((Control)this.btnUploadToAnalytics.getParent().getShell());
        MenuItem accessKAMenuItem = new MenuItem(katalonAnalyticsMenu, 8);
        this.uploadMenuItem = new MenuItem(katalonAnalyticsMenu, 8);
        accessKAMenuItem.setText(ComposerReportMessageConstants.BTN_ACCESSKA);
        accessKAMenuItem.setID(0);
        accessKAMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                block7: {
                    Trackings.trackOpenKAIntegration((String)"report");
                    if (ReportPart.this.analyticsReportService.isIntegrationEnabled()) {
                        String tokenInfo = null;
                        String analyticsEmail = null;
                        String preferenceEmail = null;
                        try {
                            analyticsEmail = analyticsSettingStore.getEmail(analyticsSettingStore.isEncryptionEnabled());
                            preferenceEmail = CryptoUtil.decode((CryptoUtil.CrytoInfo)CryptoUtil.getDefault((String)preferenceStore.getString("email")));
                        }
                        catch (IOException | GeneralSecurityException e2) {
                            LoggerSingleton.logError((Throwable)e2);
                        }
                        try {
                            tokenInfo = analyticsSettingStore.getToken(true);
                            if (preferenceEmail.equals(analyticsEmail) && preferenceEmail != null && tokenInfo != null) {
                                Program.launch((String)(String.valueOf(ComposerTestcaseMessageConstants.KA_HOMEPAGE) + "token=" + tokenInfo));
                                break block7;
                            }
                            Program.launch((String)ComposerTestcaseMessageConstants.KA_HOMEPAGE_NOTOKEN);
                        }
                        catch (IOException | GeneralSecurityException e1) {
                            LoggerSingleton.logError((Throwable)e1);
                        }
                    } else {
                        ReportPart.this.startIntegrating(analyticsSettingStore);
                    }
                }
            }
        });
        this.uploadMenuItem.setText(ComposerTestcaseMessageConstants.BTN_UPLOAD);
        this.uploadMenuItem.setID(1);
        this.uploadMenuItem.setEnabled(this.analyticsReportService.isIntegrationEnabled());
        this.uploadMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Trackings.trackOpenKAIntegration((String)"report");
                ReportPart.this.uploadToKA();
            }
        });
        this.btnUploadToAnalytics.setData((Object)katalonAnalyticsMenu);
        this.btnUploadToAnalytics.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Rectangle rect = ReportPart.this.btnUploadToAnalytics.getBounds();
                Point pt = ReportPart.this.btnUploadToAnalytics.getParent().toDisplay(new Point(rect.x, rect.y));
                katalonAnalyticsMenu.setLocation(pt.x, pt.y + rect.height);
                katalonAnalyticsMenu.setVisible(true);
                katalonAnalyticsMenu.setVisible(true);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private HashMap<String, String> getCredentialInfo(AnalyticsSettingStore analyticsSettingStore) {
        String authenticationDialogOpened = "false";
        ScopedPreferenceStore preferenceStore = this.getPreferenceStore();
        String preferenceEmail = preferenceStore.getString("email");
        String preferencePassword = preferenceStore.getString("password");
        boolean encryptionEnabled = true;
        HashMap<String, String> credentialInfo = new HashMap<String, String>();
        try {
            String serverUrl = analyticsSettingStore.getServerEndpoint(analyticsSettingStore.isEncryptionEnabled());
            String analyticsEmail = analyticsSettingStore.getEmail(analyticsSettingStore.isEncryptionEnabled());
            String analyticsPassword = analyticsSettingStore.getPassword(analyticsSettingStore.isEncryptionEnabled());
            if (StringUtils.isEmpty((String)serverUrl)) {
                serverUrl = "https://analytics.katalon.com";
            }
            if (StringUtils.isEmpty((String)analyticsPassword) && !StringUtils.isEmpty((String)preferencePassword)) {
                analyticsEmail = CryptoUtil.decode((CryptoUtil.CrytoInfo)CryptoUtil.getDefault((String)preferenceEmail));
                analyticsPassword = CryptoUtil.decode((CryptoUtil.CrytoInfo)CryptoUtil.getDefault((String)preferencePassword));
                analyticsSettingStore.enableEncryption(encryptionEnabled);
                analyticsSettingStore.setEmail(analyticsEmail, encryptionEnabled);
                analyticsSettingStore.setPassword(analyticsPassword, encryptionEnabled);
                analyticsSettingStore.setServerEndPoint(serverUrl, encryptionEnabled);
                analyticsSettingStore.enableIntegration(true);
                preferenceStore.setValue("password", "");
            }
            if (StringUtils.isEmpty((String)analyticsPassword) || StringUtils.isEmpty((String)analyticsEmail)) {
                AuthenticationDialog authenticationDialog = new AuthenticationDialog(this.shell, true);
                int resultCode = authenticationDialog.open();
                if (resultCode == 1) {
                    return null;
                }
                tokenInfo = authenticationDialog.getTokenInfo();
                authenticationDialogOpened = "true";
                analyticsPassword = analyticsSettingStore.getPassword(analyticsSettingStore.isEncryptionEnabled());
                analyticsEmail = analyticsSettingStore.getEmail(analyticsSettingStore.isEncryptionEnabled());
            }
            credentialInfo.put("analyticsEmail", analyticsEmail);
            credentialInfo.put("analyticsPassword", analyticsPassword);
            credentialInfo.put("serverUrl", serverUrl);
            credentialInfo.put("authenticationDialogOpened", authenticationDialogOpened);
            return credentialInfo;
        }
        catch (IOException | GeneralSecurityException e) {
            LoggerSingleton.logError((Throwable)e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void startIntegrating(AnalyticsSettingStore analyticsSettingStore) {
        int teamCount = 1;
        int projectCount = 0;
        List<AnalyticsTeam> teams = null;
        List<AnalyticsProject> projects = null;
        HashMap<String, String> credentialInfo = this.getCredentialInfo(analyticsSettingStore);
        if (credentialInfo == null) {
            return;
        }
        String analyticsEmail = credentialInfo.get("analyticsEmail");
        String analyticsPassword = credentialInfo.get("analyticsPassword");
        String serverUrl = credentialInfo.get("serverUrl");
        Boolean authenticationDialogOpened = Boolean.valueOf(credentialInfo.get("authenticationDialogOpened"));
        if (!StringUtils.isEmpty((String)analyticsPassword) && !authenticationDialogOpened.booleanValue()) {
            tokenInfo = AnalyticsAuthorizationHandler.getToken(serverUrl, analyticsEmail, analyticsPassword, analyticsSettingStore);
        }
        if (tokenInfo == null) {
            AuthenticationDialog authenticationDialog = new AuthenticationDialog(this.shell, true);
            int resultCode = authenticationDialog.open();
            if (resultCode == 1) {
                return;
            }
            tokenInfo = authenticationDialog.getTokenInfo();
            authenticationDialogOpened = true;
        }
        teams = AnalyticsAuthorizationHandler.getTeams(serverUrl, analyticsEmail, analyticsPassword, tokenInfo, new ProgressMonitorDialog(this.shell));
        teamCount = teams.size();
        projects = AnalyticsAuthorizationHandler.getProjects(serverUrl, analyticsEmail, analyticsPassword, teams.get(0), tokenInfo, new ProgressMonitorDialog(this.shell));
        projectCount = projects.size();
        UploadSelectionDialog uploadSelectionDialog = new UploadSelectionDialog(this.shell, teams, projects);
        try {
            if (projectCount > 0 || teamCount > 1) {
                analyticsSettingStore.enableIntegration(true);
                int returnCode = uploadSelectionDialog.open();
                if (returnCode != 2) {
                    analyticsSettingStore.enableIntegration(false);
                    return;
                }
                this.uploadToKA();
            } else if (projectCount == 0 && teamCount == 1 && authenticationDialogOpened.booleanValue()) {
                AnalyticsAuthorizationHandler.createDefaultProject(analyticsSettingStore, serverUrl, teams.get(0), tokenInfo, new ProgressMonitorDialog(this.shell));
                analyticsSettingStore.enableIntegration(true);
                this.uploadToKA();
            } else {
                AuthenticationDialog authenticationDialog = new AuthenticationDialog(this.shell, false);
                int returnCode = authenticationDialog.open();
                if (returnCode != 2) {
                    analyticsSettingStore.enableIntegration(false);
                    return;
                }
                AnalyticsAuthorizationHandler.createDefaultProject(analyticsSettingStore, serverUrl, teams.get(0), tokenInfo, new ProgressMonitorDialog(this.shell));
                analyticsSettingStore.enableIntegration(true);
                this.uploadToKA();
            }
            if (analyticsSettingStore.getProject() != null && analyticsSettingStore.getTeam() != null) {
                Program.launch((String)(String.valueOf(ComposerTestcaseMessageConstants.KA_HOMEPAGE) + "teamId=" + analyticsSettingStore.getTeam().getId() + "&projectId=" + analyticsSettingStore.getProject().getId() + "&type=EXECUTION&token=" + tokenInfo.getAccess_token()));
                return;
            }
            analyticsSettingStore.enableIntegration(false);
            return;
        }
        catch (Exception ex) {
            LoggerSingleton.logError((Throwable)ex);
            MultiStatusErrorDialog.showErrorDialog((Throwable)ex, (String)ComposerAnalyticsStringConstants.ERROR, (String)ex.getMessage());
            try {
                analyticsSettingStore.enableIntegration(false);
                return;
            }
            catch (IOException e1) {
                LoggerSingleton.logError((Throwable)e1);
            }
        }
    }

    private void uploadToKA() {
        try {
            new ProgressMonitorDialog(this.shell).run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    try {
                        monitor.beginTask(ComposerReportMessageConstants.REPORT_MSG_UPLOADING_TO_ANALYTICS, 2);
                        monitor.subTask(ComposerReportMessageConstants.REPORT_MSG_UPLOADING_TO_ANALYTICS_SENDING);
                        ReportPart.this.analyticsReportService.upload(ReportPart.this.testSuiteLogRecord.getLogFolder());
                        UISynchronizeService.syncExec(() -> ReportPart.this.uploadMenuItem.setEnabled(ReportPart.this.analyticsReportService.isIntegrationEnabled()));
                        monitor.worked(1);
                        monitor.subTask(ComposerReportMessageConstants.REPORT_MSG_UPLOADING_TO_ANALYTICS_SUCCESSFULLY);
                        monitor.worked(2);
                    }
                    catch (AnalyticsApiExeception ex) {
                        LoggerSingleton.logError((Throwable)ex);
                        MultiStatusErrorDialog.showErrorDialog((Throwable)ex, (String)ComposerAnalyticsStringConstants.ERROR, (String)ComposerReportMessageConstants.REPORT_ERROR_MSG_UNABLE_TO_UPLOAD_REPORT);
                    }
                }
            });
        }
        catch (Exception ex) {
            LoggerSingleton.logError((Throwable)ex);
            MultiStatusErrorDialog.showErrorDialog((Throwable)ex, (String)ComposerAnalyticsStringConstants.ERROR, (String)ComposerReportMessageConstants.REPORT_ERROR_MSG_UNABLE_TO_UPLOAD_REPORT);
        }
    }

    private void filterTestLogBySearchedText() {
        this.isSearching = !this.txtTestCaseSearch.getText().isEmpty();
        this.testCaseTableViewer.setSearchedString(this.txtTestCaseSearch.getText());
        this.testCaseTableViewer.refresh(true);
        this.updateStatusSearchLabel();
    }

    private void updateStatusSearchLabel() {
        if (this.isSearching) {
            this.lblTestCaseSearch.setImage(com.kms.katalon.composer.components.impl.constants.ImageConstants.IMG_16_CLOSE_SEARCH);
            this.lblTestCaseSearch.setToolTipText(GlobalStringConstants.CLEAR);
        } else {
            this.lblTestCaseSearch.setImage(com.kms.katalon.composer.components.impl.constants.ImageConstants.IMG_16_SEARCH);
            this.lblTestCaseSearch.setToolTipText(GlobalStringConstants.SEARCH);
        }
    }

    private void createCompositeTestCaseTableDetails(Composite compositeTestCaseTable) {
        Composite compositeTestCaseTableDetails = new Composite(compositeTestCaseTable, 0);
        compositeTestCaseTableDetails.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.tclCompositeTestCaseTableDetails = new TableColumnLayout();
        compositeTestCaseTableDetails.setLayout((Layout)this.tclCompositeTestCaseTableDetails);
        this.testCaseTableViewer = new ReportTestCaseTableViewer(compositeTestCaseTableDetails, 65538);
        Table table = this.testCaseTableViewer.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TableViewerColumn tableViewerColumnOrder = new TableViewerColumn((TableViewer)this.testCaseTableViewer, 0);
        TableColumn tblclmnTCOrder = tableViewerColumnOrder.getColumn();
        tblclmnTCOrder.setText("No.");
        tableViewerColumnOrder.setLabelProvider((CellLabelProvider)new ReportPartTestCaseLabelProvider());
        this.tclCompositeTestCaseTableDetails.setColumnData((Widget)tblclmnTCOrder, (ColumnLayoutData)new ColumnWeightData(0, 40));
        TableViewerColumn tableViewerColumnName = new TableViewerColumn((TableViewer)this.testCaseTableViewer, 0);
        TableColumn tblclmnTCName = tableViewerColumnName.getColumn();
        tblclmnTCName.setText("Name");
        tableViewerColumnName.setLabelProvider((CellLabelProvider)new ReportPartTestCaseLabelProvider());
        this.tclCompositeTestCaseTableDetails.setColumnData((Widget)tblclmnTCName, (ColumnLayoutData)new ColumnWeightData(80, 0));
        TableViewerColumn tableViewerColumnVideo = new TableViewerColumn((TableViewer)this.testCaseTableViewer, 0);
        TableColumn tblclmnTCVideo = tableViewerColumnVideo.getColumn();
        tblclmnTCVideo.setText("Video");
        tableViewerColumnVideo.setLabelProvider((CellLabelProvider)new HyperlinkTestCaseVideoLabelProvider(this));
        this.tclCompositeTestCaseTableDetails.setColumnData((Widget)tblclmnTCVideo, (ColumnLayoutData)new ColumnWeightData(0, 50));
        this.testCaseTableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.testCaseTableViewer.getTable().setToolTipText("");
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.testCaseTableViewer);
        this.testCaseTableFilter = new ReportTestCaseTableViewerFilter();
        this.testCaseTableFilter.showPassed(this.btnFilterTestCasePassed.getSelection());
        this.testCaseTableFilter.showFailed(this.btnFilterTestCaseFailed.getSelection());
        this.testCaseTableFilter.showError(this.btnFilterTestCaseError.getSelection());
        this.testCaseTableFilter.showIncomplete(this.btnFilterTestCaseIncomplete.getSelection());
        this.testCaseTableViewer.addFilter(this.testCaseTableFilter);
    }

    private void createIntegrationColumns() {
        if (this.testCaseIntergrationColumn != null && !this.testCaseIntergrationColumn.isEmpty()) {
            this.testCaseIntergrationColumn.stream().forEach(viewerColumn -> {
                viewerColumn.setLabelProvider(new CellLabelProvider(){

                    public void update(ViewerCell cell) {
                    }
                });
                viewerColumn.getColumn().dispose();
            });
            this.testCaseTableViewer.refresh();
        }
        this.testCaseIntergrationColumn = new ArrayList<TableViewerColumn>();
        for (ReportTestCaseIntegrationViewBuilder builder : ReportComposerIntegrationFactory.getInstance().getSortedBuilder()) {
            if (!builder.isIntegrationEnabled(ProjectController.getInstance().getCurrentProject())) continue;
            TableViewerColumn viewerColumn2 = (TableViewerColumn)builder.getTestCaseIntegrationColumn(this.report, this.testSuiteLogRecord).createIntegrationColumn((ColumnViewer)this.testCaseTableViewer, this.testCaseTableViewer.getTable().getColumnCount());
            this.tclCompositeTestCaseTableDetails.setColumnData((Widget)viewerColumn2.getColumn(), (ColumnLayoutData)new ColumnWeightData(0, 32));
            this.testCaseIntergrationColumn.add(viewerColumn2);
        }
        this.testCaseTableViewer.getTable().getParent().layout(true, true);
        this.testCaseTableViewer.refresh();
    }

    private void createCompositeTestCaseTable(Composite sashFormSummary) {
        Composite compositeTestCaseTable = new Composite(sashFormSummary, 2048);
        compositeTestCaseTable.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        GridLayout glCompositeTestCaseTable = new GridLayout(1, false);
        glCompositeTestCaseTable.marginHeight = 0;
        glCompositeTestCaseTable.marginWidth = 0;
        compositeTestCaseTable.setLayout((Layout)glCompositeTestCaseTable);
        Composite compositeTestCaseTableHeader = new Composite(compositeTestCaseTable, 0);
        GridLayout gl_compositeTestCaseTableHeader = new GridLayout(1, false);
        compositeTestCaseTableHeader.setLayout((Layout)gl_compositeTestCaseTableHeader);
        compositeTestCaseTableHeader.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        Label lblTestCaseTable = new Label(compositeTestCaseTableHeader, 0);
        lblTestCaseTable.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        lblTestCaseTable.setText("Test Cases Table");
        this.setLabelToBeBold(lblTestCaseTable);
        this.createCompositeTestCaseFilter(compositeTestCaseTable);
        this.createCompositeTestCaseTableDetails(compositeTestCaseTable);
    }

    private void createCompositeSummary(Composite sashFormSummary) {
        CTabFolder tabFolder = new CTabFolder(sashFormSummary, 0);
        tabFolder.setLayoutData((Object)new GridData(4, 1024, true, false, 1, 1));
        tabFolder.setSelectionBackground(Display.getCurrent().getSystemColor(35));
        this.createSummaryTabControl(tabFolder);
        this.createExecutionSettingTabControls(tabFolder);
        this.createRunDataTabControls(tabFolder);
        tabFolder.setSelection(0);
    }

    private void createSummaryTabControl(CTabFolder tabFolder) {
        CTabItem tbtmSummary = new CTabItem(tabFolder, 0);
        tbtmSummary.setText(StringConstants.TITLE_SUMMARY);
        ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)tabFolder, 2816);
        scrolledComposite.setLayoutData((Object)new GridData(4, 1024, true, false, 1, 1));
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setMinSize(420, 200);
        scrolledComposite.setBackground(ColorUtil.getWhiteBackgroundColor());
        Composite compositeSummary = new Composite((Composite)scrolledComposite, 0);
        compositeSummary.setLayoutData((Object)new GridData(4, 1024, true, false, 1, 1));
        GridLayout gl_compositeSummary = new GridLayout(1, false);
        gl_compositeSummary.horizontalSpacing = 0;
        gl_compositeSummary.verticalSpacing = 0;
        gl_compositeSummary.marginHeight = 0;
        gl_compositeSummary.marginWidth = 0;
        gl_compositeSummary.marginRight = 10;
        compositeSummary.setLayout((Layout)gl_compositeSummary);
        compositeSummary.setBackground(ColorUtil.getWhiteBackgroundColor());
        scrolledComposite.setContent((Control)compositeSummary);
        tbtmSummary.setControl((Control)scrolledComposite);
        Composite compositeSummaryDetails = new Composite(compositeSummary, 0);
        compositeSummaryDetails.setBackground(ColorUtil.getWhiteBackgroundColor());
        GridLayout gl_compositeSummaryDetails = new GridLayout(4, false);
        gl_compositeSummaryDetails.verticalSpacing = 7;
        gl_compositeSummaryDetails.horizontalSpacing = 15;
        compositeSummaryDetails.setLayout((Layout)gl_compositeSummaryDetails);
        compositeSummaryDetails.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Label lblTestSuiteId = new Label(compositeSummaryDetails, 0);
        lblTestSuiteId.setText("Test Suite ID");
        this.setLabelToBeBold(lblTestSuiteId);
        lblTestSuiteId.setBackground(ColorUtil.getWhiteBackgroundColor());
        this.txtTestSuiteId = new StyledText(compositeSummaryDetails, 0);
        this.txtTestSuiteId.setLayoutData((Object)new GridData(4, 128, true, false, 3, 1));
        Label lblHostName = new Label(compositeSummaryDetails, 0);
        lblHostName.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        lblHostName.setText(StringConstants.LBL_HOST_NAME);
        this.setLabelToBeBold(lblHostName);
        lblHostName.setBackground(ColorUtil.getWhiteBackgroundColor());
        this.txtHostName = new StyledText(compositeSummaryDetails, 8);
        this.txtHostName.setEditable(false);
        this.txtHostName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblOS = new Label(compositeSummaryDetails, 0);
        lblOS.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        lblOS.setText(StringConstants.LBL_OS);
        this.setLabelToBeBold(lblOS);
        lblOS.setBackground(ColorUtil.getWhiteBackgroundColor());
        this.txtOS = new StyledText(compositeSummaryDetails, 8);
        this.txtOS.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblKatalonVersion = new Label(compositeSummaryDetails, 0);
        lblKatalonVersion.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        lblKatalonVersion.setText(StringConstants.LBL_KATALON_VERSION);
        this.setLabelToBeBold(lblKatalonVersion);
        lblKatalonVersion.setBackground(ColorUtil.getWhiteBackgroundColor());
        this.txtKatalonVersion = new StyledText(compositeSummaryDetails, 8);
        this.txtKatalonVersion.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblPlatform = new Label(compositeSummaryDetails, 0);
        lblPlatform.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        lblPlatform.setText(StringConstants.LBL_PLATFORM);
        this.setLabelToBeBold(lblPlatform);
        lblPlatform.setBackground(ColorUtil.getWhiteBackgroundColor());
        this.txtPlatform = new StyledText(compositeSummaryDetails, 8);
        this.txtPlatform.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblStart = new Label(compositeSummaryDetails, 0);
        lblStart.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        lblStart.setText(StringConstants.REPORT_TABLE_START_TIME_COLUMN_HEADER);
        this.setLabelToBeBold(lblStart);
        lblStart.setBackground(ColorUtil.getWhiteBackgroundColor());
        this.txtStartTime = new StyledText(compositeSummaryDetails, 8);
        this.txtStartTime.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblEnd = new Label(compositeSummaryDetails, 0);
        lblEnd.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        lblEnd.setText(StringConstants.REPORT_TABLE_END_TIME_COLUMN_HEADER);
        this.setLabelToBeBold(lblEnd);
        lblEnd.setBackground(ColorUtil.getWhiteBackgroundColor());
        this.txtEndTime = new StyledText(compositeSummaryDetails, 8);
        this.txtEndTime.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblRuntime = new Label(compositeSummaryDetails, 0);
        lblRuntime.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        lblRuntime.setText(StringConstants.REPORT_TABLE_ELAPSED_TIME_COLUMN_HEADER);
        this.setLabelToBeBold(lblRuntime);
        lblRuntime.setBackground(ColorUtil.getWhiteBackgroundColor());
        this.txtRunTime = new StyledText(compositeSummaryDetails, 8);
        this.txtRunTime.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        new Label(compositeSummaryDetails, 0);
        new Label(compositeSummaryDetails, 0);
        Label lblTotalTC = new Label(compositeSummaryDetails, 0);
        lblTotalTC.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        lblTotalTC.setText("Total TC");
        this.setLabelToBeBold(lblTotalTC);
        lblTotalTC.setBackground(ColorUtil.getWhiteBackgroundColor());
        this.txtTotalTestCase = new StyledText(compositeSummaryDetails, 8);
        this.txtTotalTestCase.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        new Label(compositeSummaryDetails, 0);
        new Label(compositeSummaryDetails, 0);
        Label lblPassed = new Label(compositeSummaryDetails, 0);
        lblPassed.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        lblPassed.setText("Passed");
        this.setLabelToBeBold(lblPassed);
        lblPassed.setForeground(ColorUtil.getPassedLogBackgroundColor());
        lblPassed.setBackground(ColorUtil.getWhiteBackgroundColor());
        this.txtTCPasses = new StyledText(compositeSummaryDetails, 8);
        this.txtTCPasses.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        this.txtTCPasses.setForeground(ColorUtil.getPassedLogBackgroundColor());
        Label lblFailed = new Label(compositeSummaryDetails, 0);
        lblFailed.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        lblFailed.setText("Failed");
        this.setLabelToBeBold(lblFailed);
        lblFailed.setForeground(ColorUtil.getFailedLogBackgroundColor());
        lblFailed.setBackground(ColorUtil.getWhiteBackgroundColor());
        this.txtTCFailures = new StyledText(compositeSummaryDetails, 8);
        this.txtTCFailures.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        this.txtTCFailures.setForeground(ColorUtil.getFailedLogBackgroundColor());
        Label lblError = new Label(compositeSummaryDetails, 0);
        lblError.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        lblError.setText("Error");
        this.setLabelToBeBold(lblError);
        lblError.setForeground(ColorUtil.getErrorLogBackgroundColor());
        lblError.setBackground(ColorUtil.getWhiteBackgroundColor());
        this.txtTCErrors = new StyledText(compositeSummaryDetails, 8);
        this.txtTCErrors.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        this.txtTCErrors.setForeground(ColorUtil.getErrorLogBackgroundColor());
        Label lblIncompleted = new Label(compositeSummaryDetails, 0);
        lblIncompleted.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        lblIncompleted.setText("Incomplete");
        this.setLabelToBeBold(lblIncompleted);
        lblIncompleted.setForeground(ColorUtil.getIncompleteLogColor());
        lblIncompleted.setBackground(ColorUtil.getWhiteBackgroundColor());
        this.txtTCIncompleted = new StyledText(compositeSummaryDetails, 8);
        this.txtTCIncompleted.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        this.txtTCIncompleted.setForeground(ColorUtil.getIncompleteLogColor());
    }

    private void createExecutionSettingTabControls(CTabFolder tabFolder) {
        CTabItem tbtmExecutionSetting = new CTabItem(tabFolder, 0);
        tbtmExecutionSetting.setText(StringConstants.TITLE_EXECUTION_SETTINGS);
        Composite compositeExecutionSetting = new Composite((Composite)tabFolder, 2048);
        tbtmExecutionSetting.setControl((Control)compositeExecutionSetting);
        compositeExecutionSetting.setLayoutData((Object)new GridData(4, 1024, true, false, 1, 1));
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        compositeExecutionSetting.setLayout((Layout)tableColumnLayout);
        this.executionSettingTable = new TableViewer(compositeExecutionSetting, 65538);
        this.executionSettingTable.getTable().setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.executionSettingTable.getTable().setLinesVisible(true);
        this.executionSettingTable.getTable().setHeaderVisible(true);
        this.executionSettingTable.setContentProvider((IContentProvider)new ArrayContentProvider());
        TableViewerColumn tableColumnRunDataKey = new TableViewerColumn(this.executionSettingTable, 0);
        tableColumnRunDataKey.getColumn().setText(StringConstants.COLUMN_LBL_RUN_DATA_KEY);
        tableColumnRunDataKey.setLabelProvider((CellLabelProvider)new MapDataKeyLabelProvider());
        tableColumnRunDataKey.setEditingSupport((EditingSupport)new MapDataKeyEditingSupport((ColumnViewer)this.executionSettingTable));
        tableColumnLayout.setColumnData((Widget)tableColumnRunDataKey.getColumn(), (ColumnLayoutData)new ColumnWeightData(50, tableColumnRunDataKey.getColumn().getWidth()));
        TableViewerColumn tableColumnRunDataValue = new TableViewerColumn(this.executionSettingTable, 0);
        tableColumnRunDataValue.getColumn().setText(StringConstants.COLUMN_LBL_RUN_DATA_VALUE);
        tableColumnRunDataValue.setLabelProvider((CellLabelProvider)new MapDataLabelValueProvider());
        tableColumnRunDataValue.setEditingSupport((EditingSupport)new MapDataValueEditingSupport((ColumnViewer)this.executionSettingTable));
        tableColumnLayout.setColumnData((Widget)tableColumnRunDataValue.getColumn(), (ColumnLayoutData)new ColumnWeightData(50, tableColumnRunDataValue.getColumn().getWidth()));
    }

    private void createRunDataTabControls(CTabFolder tabFolder) {
        CTabItem tbtmRunData = new CTabItem(tabFolder, 0);
        tbtmRunData.setText(StringConstants.TITLE_EXECUTION_ENVIRONMENT);
        Composite compositeRunData = new Composite((Composite)tabFolder, 2048);
        tbtmRunData.setControl((Control)compositeRunData);
        compositeRunData.setLayoutData((Object)new GridData(4, 1024, true, false, 1, 1));
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        compositeRunData.setLayout((Layout)tableColumnLayout);
        this.runDataTable = new TableViewer(compositeRunData, 65538);
        this.runDataTable.getTable().setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.runDataTable.getTable().setLinesVisible(true);
        this.runDataTable.getTable().setHeaderVisible(true);
        this.runDataTable.setContentProvider((IContentProvider)new ArrayContentProvider());
        TableViewerColumn tableColumnRunDataKey = new TableViewerColumn(this.runDataTable, 0);
        tableColumnRunDataKey.getColumn().setText(StringConstants.COLUMN_LBL_RUN_DATA_KEY);
        tableColumnRunDataKey.setLabelProvider((CellLabelProvider)new MapDataKeyLabelProvider());
        tableColumnRunDataKey.setEditingSupport((EditingSupport)new MapDataKeyEditingSupport((ColumnViewer)this.runDataTable));
        tableColumnLayout.setColumnData((Widget)tableColumnRunDataKey.getColumn(), (ColumnLayoutData)new ColumnWeightData(50, tableColumnRunDataKey.getColumn().getWidth()));
        TableViewerColumn tableColumnRunDataValue = new TableViewerColumn(this.runDataTable, 0);
        tableColumnRunDataValue.getColumn().setText(StringConstants.COLUMN_LBL_RUN_DATA_VALUE);
        tableColumnRunDataValue.setLabelProvider((CellLabelProvider)new MapDataLabelValueProvider());
        tableColumnRunDataValue.setEditingSupport((EditingSupport)new MapDataValueEditingSupport((ColumnViewer)this.runDataTable));
        tableColumnLayout.setColumnData((Widget)tableColumnRunDataValue.getColumn(), (ColumnLayoutData)new ColumnWeightData(50, tableColumnRunDataValue.getColumn().getWidth()));
    }

    private void createControls(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBounds(0, 0, 561, 500);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.sashForm = new SashForm(composite, 0);
        this.sashForm.setSashWidth(5);
        this.sashForm.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.sashFormSummary = new SashForm((Composite)this.sashForm, 512);
        this.sashFormSummary.setSashWidth(5);
        this.createCompositeTestCaseTable((Composite)this.sashFormSummary);
        this.createCompositeSummary((Composite)this.sashFormSummary);
        SashForm sashFormDetails = new SashForm((Composite)this.sashForm, 512);
        sashFormDetails.setSashWidth(5);
        this.testLogView.createCompositeTestStepTree(sashFormDetails);
        this.testLogView.createCompositeSelectedTestLog(sashFormDetails);
        sashFormDetails.setWeights(new int[]{6, 4});
        this.sashFormSummary.setWeights(new int[]{75, 25});
        this.sashForm.setWeights(new int[]{40, 60});
        this.sashForm.setMaximizedControl((Control)this.sashFormSummary);
    }

    public void setLabelToBeBold(Label label) {
        label.setFont(JFaceResources.getFontRegistry().getBold(""));
    }

    private void registerListeners() {
        this.eventBroker.subscribe("REPORT/UPDATED", (EventHandler)this);
        this.eventBroker.subscribe("REPORT/RENAMED", (EventHandler)this);
        this.eventBroker.subscribe("SETTINGS/INTERGRATION/KATALON_ANALYTICS", (EventHandler)this);
    }

    public MPart getMPart() {
        return null;
    }

    public ReportEntity getReport() {
        return this.report;
    }

    public void setDirty(boolean dirty) {
        this.getMPart().setDirty(true);
    }

    public Map<String, TestCaseLogDetailsIntegrationView> getIntegratingCompositeMap() {
        return this.integratingCompositeMap;
    }

    public void prepareBeforeReloading() {
        if (this.testCaseTableViewer == null) {
            return;
        }
        this.selectedTestCaseRecordIndex = this.testCaseTableViewer.getTable().getSelectionIndex();
    }

    public void prepareAfterReloading() {
        if (this.selectedTestCaseRecordIndex >= 0) {
            this.testCaseTableViewer.setSelection((ISelection)new StructuredSelection(Arrays.asList(this.testSuiteLogRecord.getChildRecords()[this.selectedTestCaseRecordIndex])));
        }
    }

    public void handleEvent(Event event) {
        if (event.getTopic().equals("REPORT/UPDATED")) {
            try {
                Object[] objects = (Object[])event.getProperty("org.eclipse.e4.data");
                if (objects == null || objects.length != 2) {
                    return;
                }
                String updatedReportId = (String)objects[0];
                if (updatedReportId == null) {
                    return;
                }
                if (updatedReportId.equals(this.report.getId())) {
                    this.prepareBeforeReloading();
                    this.updateReportAndInput((ReportEntity)objects[1]);
                    this.prepareAfterReloading();
                }
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
            }
            return;
        }
        if (event.getTopic().equals("REPORT/RENAMED")) {
            this.handleReportRenamed(event);
            return;
        }
        if ("SETTINGS/INTERGRATION/KATALON_ANALYTICS".equals(event.getTopic())) {
            this.uploadMenuItem.setEnabled(this.analyticsReportService.isIntegrationEnabled());
        }
    }

    private void handleReportRenamed(Event event) {
        Object eventData = event.getProperty("org.eclipse.e4.data");
        if (!(eventData instanceof ReportEntity)) {
            return;
        }
        ReportEntity report = (ReportEntity)eventData;
        if (this.getReport().getId().equals(report.getId())) {
            this.setPartLabel(report.getDisplayName());
        }
    }

    public String getEntityId() {
        return this.getReport().getIdForDisplay();
    }

    @Inject
    @Optional
    public void onSelect(@UIEventTopic(value="org/eclipse/e4/ui/LifeCycle/bringToTop") Event event) {
        MPart selectedPart = EventUtil.getPart((Event)event);
        if (selectedPart == null) {
            return;
        }
        String reportPartId = EntityPartUtil.getReportPartId((String)this.getReport().getId());
        if (selectedPart.getElementId().equals(reportPartId)) {
            EventUtil.post((String)"PROPERTIES/ENTITY", null);
        }
    }

    @Inject
    @Optional
    public void onChangeEntityProperties(@UIEventTopic(value="PROPERTIES/ENTITY_UPDATED") Event event) {
    }

    @PreDestroy
    public void onClose() {
        this.eventBroker.unsubscribe((EventHandler)this);
        this.testSuiteLogRecord = null;
    }

    public void setPartLabel(String label) {
        this.mpart.setLabel(label);
    }

    private void setTestCaseDetailsVisible(boolean isVisible) {
        this.sashForm.setMaximizedControl((Control)(isVisible ? null : this.sashFormSummary));
        this.btnShowHideTestCaseDetails.setText(isVisible ? BTN_HIDE_TEST_CASE_DETAILS : BTN_SHOW_TEST_CASE_DETAILS);
        this.btnShowHideTestCaseDetails.setImage(ImageManager.getImage((String)(isVisible ? "move_right_16.png" : "move_left_16.png")));
        this.compositeTestCaseFilterSelection.layout();
    }

    private final class MapDataKeyEditingSupport
    extends EditingSupport {
        private MapDataKeyEditingSupport(ColumnViewer viewer) {
            super(viewer);
        }

        protected void setValue(Object element, Object value) {
        }

        protected Object getValue(Object element) {
            if (element instanceof Map.Entry) {
                return ((Map.Entry)element).getKey();
            }
            return StringConstants.EMPTY;
        }

        protected CellEditor getCellEditor(Object element) {
            return new TextCellEditor((Composite)this.getViewer().getControl());
        }

        protected boolean canEdit(Object element) {
            return true;
        }
    }

    private final class MapDataKeyLabelProvider
    extends ColumnLabelProvider {
        private MapDataKeyLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof Map.Entry) {
                return ObjectUtils.toString(((Map.Entry)element).getKey());
            }
            return StringConstants.EMPTY;
        }
    }

    private final class MapDataLabelValueProvider
    extends ColumnLabelProvider {
        private MapDataLabelValueProvider() {
        }

        public String getText(Object element) {
            if (element instanceof Map.Entry) {
                return ObjectUtils.toString(((Map.Entry)element).getValue());
            }
            return StringConstants.EMPTY;
        }
    }

    private final class MapDataValueEditingSupport
    extends EditingSupport {
        private MapDataValueEditingSupport(ColumnViewer viewer) {
            super(viewer);
        }

        protected void setValue(Object element, Object value) {
        }

        protected Object getValue(Object element) {
            if (element instanceof Map.Entry) {
                return ObjectUtils.toString(((Map.Entry)element).getValue());
            }
            return StringConstants.EMPTY;
        }

        protected CellEditor getCellEditor(Object element) {
            return new TextCellEditor((Composite)this.getViewer().getControl());
        }

        protected boolean canEdit(Object element) {
            return true;
        }
    }
}

