/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.report.parts;

import com.kms.katalon.composer.components.controls.HelpToolBarForMPart;
import com.kms.katalon.composer.components.impl.control.CTableViewer;
import com.kms.katalon.composer.components.impl.event.EventServiceAdapter;
import com.kms.katalon.composer.components.impl.util.EventUtil;
import com.kms.katalon.composer.components.part.IComposerPartEvent;
import com.kms.katalon.composer.report.constants.StringConstants;
import com.kms.katalon.composer.report.provider.ReportActionColumnLabelProvider;
import com.kms.katalon.composer.report.provider.ReportCollectionTableLabelProvider;
import com.kms.katalon.constants.DocumentationMessageConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.project.ProjectType;
import com.kms.katalon.entity.report.ReportCollectionEntity;
import com.kms.katalon.entity.report.ReportItemDescription;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class ReportCollectionPart
extends EventServiceAdapter
implements IComposerPartEvent {
    private ReportCollectionEntity reportCollectionEntity;
    private TableViewer tableViewer;
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private MPart mpart;

    @PostConstruct
    public void initialize(Composite parent, MPart mpart) {
        this.reportCollectionEntity = (ReportCollectionEntity)mpart.getObject();
        new HelpToolBarForMPart(mpart, DocumentationMessageConstants.REPORT_TEST_SUITE_COLLECTION);
        this.createControls(parent);
        this.updateInput();
        this.setPartLabel(this.reportCollectionEntity.getDisplayName());
        this.eventBroker.subscribe("EXPLORER/RENAMED_SELECTED_ITEM", (EventHandler)this);
        this.eventBroker.subscribe("REPORT/COLLECTION/RENAMED", (EventHandler)this);
    }

    private void updateInput() {
        this.tableViewer.setInput((Object)this.reportCollectionEntity.getReportItemDescriptions());
    }

    private void createControls(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.tableViewer = new CTableViewer(composite, 67584);
        Table table = this.tableViewer.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TableViewerColumn tableViewerColumnNo = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNo = tableViewerColumnNo.getColumn();
        tblclmnNo.setWidth(50);
        tblclmnNo.setText(StringConstants.NO_);
        tableViewerColumnNo.setLabelProvider((CellLabelProvider)new ReportCollectionTableLabelProvider(0));
        TableViewerColumn tableViewerColumnId = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnId = tableViewerColumnId.getColumn();
        tblclmnId.setWidth(250);
        tblclmnId.setText(StringConstants.ID);
        tableViewerColumnId.setLabelProvider((CellLabelProvider)new ReportCollectionTableLabelProvider(1));
        TableViewerColumn tableViewerColumnEnviroment = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnEnvironment = tableViewerColumnEnviroment.getColumn();
        tblclmnEnvironment.setWidth(100);
        tblclmnEnvironment.setText(StringConstants.REPORT_COLLECTION_LBL_ENVIRONMENT);
        tableViewerColumnEnviroment.setLabelProvider((CellLabelProvider)new ReportCollectionTableLabelProvider(2));
        TableViewerColumn tableViewerColumnStatus = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnStatus = tableViewerColumnStatus.getColumn();
        tblclmnStatus.setWidth(100);
        tblclmnStatus.setText(StringConstants.STATUS);
        tableViewerColumnStatus.setLabelProvider((CellLabelProvider)new ReportCollectionTableLabelProvider(3));
        TableViewerColumn tableViewerColumnFailedTests = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnFailedTests = tableViewerColumnFailedTests.getColumn();
        tblclmnFailedTests.setWidth(120);
        tblclmnFailedTests.setText(StringConstants.REPORT_COLLECTION_COLUMN_FAILED_TEST);
        tableViewerColumnFailedTests.setLabelProvider((CellLabelProvider)new ReportCollectionTableLabelProvider(4));
        TableViewerColumn tableViewerColumnAction = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnAction = tableViewerColumnAction.getColumn();
        tblclmnAction.setWidth(90);
        tableViewerColumnAction.setLabelProvider((CellLabelProvider)new ReportActionColumnLabelProvider(5));
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.tableViewer, (int)2);
        ProjectEntity currentProject = ProjectController.getInstance().getCurrentProject();
        if (currentProject.getType() == ProjectType.WEBSERVICE) {
            tblclmnEnvironment.setWidth(0);
            tblclmnEnvironment.setResizable(false);
        }
    }

    public String getEntityId() {
        return this.reportCollectionEntity.getIdForDisplay();
    }

    @Inject
    @Optional
    public void onSelect(@UIEventTopic(value="org/eclipse/e4/ui/LifeCycle/bringToTop") Event event) {
        EventUtil.post((String)"PROPERTIES/ENTITY", null);
    }

    @Inject
    @Optional
    public void onChangeEntityProperties(@UIEventTopic(value="PROPERTIES/ENTITY_UPDATED") Event event) {
    }

    @PreDestroy
    public void onClose() {
    }

    public void handleEvent(Event event) {
        switch (event.getTopic()) {
            case "EXPLORER/RENAMED_SELECTED_ITEM": {
                Object[] objects = this.getObjects(event);
                if (objects == null || objects.length != 2) {
                    return;
                }
                this.handleRenamedReportItem(objects);
                break;
            }
            case "REPORT/COLLECTION/RENAMED": {
                Object eventObject = this.getObject(event);
                if (!(eventObject instanceof ReportCollectionEntity)) {
                    return;
                }
                ReportCollectionEntity reportCollection = (ReportCollectionEntity)eventObject;
                if (!StringUtils.equals((CharSequence)this.reportCollectionEntity.getId(), (CharSequence)reportCollection.getId())) {
                    return;
                }
                this.setPartLabel(reportCollection.getDisplayName());
            }
        }
    }

    private void handleRenamedReportItem(Object[] objects) {
        Object oldRelativeId = objects[0];
        ReportItemDescription reportNameChanged = this.getReportNameChanged(oldRelativeId);
        if (reportNameChanged != null) {
            reportNameChanged.setReportLocation((String)objects[1]);
            this.tableViewer.refresh((Object)reportNameChanged);
        }
    }

    private ReportItemDescription getReportNameChanged(Object oldRelativeId) {
        for (ReportItemDescription itemDescription : this.reportCollectionEntity.getReportItemDescriptions()) {
            if (!itemDescription.getReportLocation().equals(oldRelativeId)) continue;
            return itemDescription;
        }
        return null;
    }

    private void setPartLabel(String label) {
        this.mpart.setLabel(label);
    }
}

