/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.report.parts;

import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.ReportTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ReportController;
import com.kms.katalon.entity.IEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.report.ReportEntity;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class HTMLReportPart
implements EventHandler {
    @Inject
    protected EModelService modelService;
    @Inject
    protected MApplication application;
    @Inject
    private IEventBroker eventBroker;
    private Browser browser;
    private ReportEntity report;
    private MPart mPart;

    @PostConstruct
    public void createComposite(Composite parent, MPart part) {
        this.mPart = part;
        this.registerEventBrokerListers();
        if (part.getObject() != null && part.getObject() instanceof ReportEntity) {
            this.report = (ReportEntity)part.getObject();
            this.showReport(parent, this.report);
        }
    }

    private void registerEventBrokerListers() {
        this.eventBroker.subscribe("EXPLORER/REFRESH_SELECTED_ITEM", (EventHandler)this);
    }

    public void showReport(Composite parent, ReportEntity report) {
        parent.setLayout((Layout)new FillLayout(512));
        this.browser = new Browser(parent, 2048);
        this.loadReport();
    }

    private void loadReport() {
        this.browser.setUrl(this.report.getHtmlFile());
    }

    public void handleEvent(Event event) {
        if (event.getTopic().equals("EXPLORER/REFRESH_SELECTED_ITEM")) {
            try {
                Object object = event.getProperty("org.eclipse.e4.data");
                if (object != null && object instanceof ITreeEntity) {
                    FolderEntity folder;
                    if (object instanceof ReportTreeEntity) {
                        ReportTreeEntity reportTreeEntity = (ReportTreeEntity)object;
                        ReportEntity reportEntity = reportTreeEntity.getObject();
                        if (reportEntity != null && reportEntity.getId().equals(this.report.getId())) {
                            if (ReportController.getInstance().getReportEntity(reportEntity.getId()) != null) {
                                this.loadReport();
                            } else {
                                this.dispose();
                            }
                        }
                    } else if (object instanceof FolderTreeEntity && (folder = (FolderEntity)((ITreeEntity)object).getObject()) != null && FolderController.getInstance().isFolderAncestorOfEntity(folder, (IEntity)this.report) && ReportController.getInstance().getReportEntity(this.report.getId()) == null) {
                        this.dispose();
                    }
                }
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
            }
        }
    }

    private void dispose() {
        MPartStack mStackPart = (MPartStack)this.modelService.find("com.kms.katalon.composer.content", (MUIElement)this.application);
        mStackPart.getChildren().remove(this.mPart);
        this.eventBroker.unsubscribe((EventHandler)this);
    }
}

