/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.report.lookup;

import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.ReportController;
import com.kms.katalon.core.logging.model.TestSuiteLogRecord;
import com.kms.katalon.core.reporting.ReportUtil;
import com.kms.katalon.entity.report.ReportEntity;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class LogRecordLookup
implements EventHandler {
    private static LogRecordLookup _instance;
    private Map<String, TestSuiteLogRecord> suiteLogRecordMap = new HashMap<String, TestSuiteLogRecord>();

    private LogRecordLookup() {
        EventBrokerSingleton.getInstance().getEventBroker().subscribe("REPORT/DELETED", (EventHandler)this);
        EventBrokerSingleton.getInstance().getEventBroker().subscribe("PROJECT/OPENED", (EventHandler)this);
    }

    public static LogRecordLookup getInstance() {
        if (_instance == null) {
            _instance = new LogRecordLookup();
        }
        return _instance;
    }

    public TestSuiteLogRecord getTestSuiteLogRecord(String reportId) {
        if (StringUtils.isEmpty((String)reportId)) {
            return null;
        }
        try {
            ReportEntity report = ReportController.getInstance().getReportEntityByDisplayId(reportId, ProjectController.getInstance().getCurrentProject());
            return report != null ? this.getTestSuiteLogRecord(report) : null;
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            return null;
        }
    }

    public synchronized TestSuiteLogRecord getTestSuiteLogRecord(ReportEntity reportEntity) {
        TestSuiteLogRecord suiteLogRecord = this.suiteLogRecordMap.get(reportEntity.getId());
        if (suiteLogRecord == null) {
            try {
                suiteLogRecord = ReportUtil.generate((String)reportEntity.getLocation());
                this.suiteLogRecordMap.put(reportEntity.getId(), suiteLogRecord);
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
            }
        }
        return suiteLogRecord;
    }

    public synchronized TestSuiteLogRecord getTestSuiteLogRecord(ReportEntity reportEntity, IProgressMonitor progressMonitor) {
        TestSuiteLogRecord suiteLogRecord = this.suiteLogRecordMap.get(reportEntity.getId());
        if (suiteLogRecord == null) {
            try {
                suiteLogRecord = ReportUtil.generate((String)reportEntity.getLocation(), (IProgressMonitor)progressMonitor);
                this.suiteLogRecordMap.put(reportEntity.getId(), suiteLogRecord);
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
            }
        }
        return suiteLogRecord;
    }

    public void refreshLogRecord(ReportEntity reportEntity) {
        if (reportEntity != null) {
            try {
                TestSuiteLogRecord suiteLogRecord = ReportUtil.generate((String)reportEntity.getLocation());
                this.suiteLogRecordMap.put(reportEntity.getId(), suiteLogRecord);
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
            }
        }
    }

    public void handleEvent(Event event) {
        String topic;
        switch (topic = event.getTopic()) {
            case "REPORT/UPDATED": {
                Object[] objects = (Object[])event.getProperty("org.eclipse.e4.data");
                if (objects == null || objects.length != 2) {
                    return;
                }
                String updatedReportId = (String)objects[0];
                if (!this.suiteLogRecordMap.containsKey(updatedReportId)) break;
                this.suiteLogRecordMap.remove(updatedReportId);
                break;
            }
            case "REPORT/DELETED": {
                String reportId = (String)event.getProperty("org.eclipse.e4.data");
                if (!this.suiteLogRecordMap.containsKey(reportId)) break;
                this.suiteLogRecordMap.remove(reportId);
                break;
            }
            case "PROJECT/OPENED": {
                this.suiteLogRecordMap.clear();
            }
        }
    }
}

