/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.report.handlers;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.report.constants.ComposerReportMessageConstants;
import com.kms.katalon.composer.report.constants.ImageConstants;
import com.kms.katalon.composer.report.constants.StringConstants;
import com.kms.katalon.composer.report.parts.ReportPart;
import com.kms.katalon.entity.report.ReportEntity;
import com.kms.katalon.execution.launcher.ILauncher;
import com.kms.katalon.execution.launcher.manager.LauncherManager;
import com.kms.katalon.execution.launcher.result.LauncherStatus;
import com.kms.katalon.tracking.service.Trackings;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class OpenReportHandler {
    private static final String REPORT_PART_URI = "bundleclass://com.kms.katalon.composer.report/" + ReportPart.class.getName();
    @Inject
    MApplication application;
    @Inject
    EPartService partService;
    @Inject
    EModelService modelService;
    @Inject
    private IEclipseContext context;

    @PostConstruct
    public void registerEventHandler(IEventBroker eventBroker) {
        eventBroker.subscribe("EXPLORER/OPEN_SELECTED_ITEM", new EventHandler(){

            public void handleEvent(Event event) {
                Object object = event.getProperty("org.eclipse.e4.data");
                if (object != null && object instanceof ReportEntity) {
                    OpenReportHandler.this.excute((ReportEntity)object);
                }
            }
        });
    }

    @Inject
    @Optional
    private void getNotifications(@UIEventTopic(value="REPORT/OPEN") ReportEntity entity) {
        this.excute(entity);
    }

    public void excute(ReportEntity report) {
        try {
            if (report == null || StringUtils.isBlank((String)report.getId())) {
                return;
            }
            ILauncher currentLauncher = LauncherManager.getInstance().getLauncher(report.getName());
            if (currentLauncher != null && currentLauncher.getStatus().compareTo((Enum)LauncherStatus.TERMINATED) < 0) {
                MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)StringConstants.WARN, (String)ComposerReportMessageConstants.HAND_WARN_MSG_EXECUTION_IS_RUNNING);
                return;
            }
            String partId = "com.kms.katalon.composer.content.report(" + report.getId() + ")";
            MPartStack stack = (MPartStack)this.modelService.find("com.kms.katalon.composer.content", (MUIElement)this.application);
            MPart mPart = (MPart)this.modelService.find(partId, (MUIElement)this.application);
            boolean alreadyOpened = true;
            if (mPart == null) {
                mPart = (MPart)this.modelService.createModelElement(MPart.class);
                mPart.setElementId(partId);
                mPart.setLabel(report.getDisplayName());
                mPart.setContributionURI(REPORT_PART_URI);
                mPart.setCloseable(true);
                mPart.setIconURI(ImageConstants.URL_16_REPORT);
                mPart.setTooltip(report.getIdForDisplay());
                stack.getChildren().add(mPart);
                alreadyOpened = false;
            }
            this.context.set(ReportEntity.class, (Object)report);
            this.partService.activate(mPart);
            stack.setSelectedElement((MUIElement)mPart);
            if (!alreadyOpened) {
                Trackings.trackOpenObject((String)"report");
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)(String.valueOf(StringConstants.HAND_ERROR_MSG_UNABLE_TO_OPEN_REPORT) + " (" + e.getMessage() + ")"));
        }
    }
}

