/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.report.handlers;

import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.tree.ReportTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.report.lookup.LogRecordLookup;
import com.kms.katalon.core.logging.model.TestSuiteLogRecord;
import com.kms.katalon.entity.report.ReportEntity;
import com.kms.katalon.jasper.pdf.TestSuitePdfGenerator;
import com.kms.katalon.jasper.pdf.exception.JasperReportException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.inject.Inject;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Shell;

public class ExportPDFReportHandler {
    @Inject
    private UISynchronize sync;

    @CanExecute
    public boolean canExecute(ESelectionService selectionService) {
        return true;
    }

    @Execute
    public void execute(ESelectionService selectionService, Shell shell) {
        DirectoryDialog directoryDialog = new DirectoryDialog(shell);
        directoryDialog.open();
        if (directoryDialog.getFilterPath() == null) {
            MessageDialog.openWarning(null, (String)"Warning", (String)"Directory not found.");
            return;
        }
        File exportDirectory = new File(directoryDialog.getFilterPath());
        if (exportDirectory != null && exportDirectory.exists() && exportDirectory.isDirectory()) {
            Object[] selectedObjects;
            Object[] objectArray = selectedObjects = (Object[])selectionService.getSelection("com.kms.katalon.composer.part.explorer");
            int n = selectedObjects.length;
            int n2 = 0;
            while (n2 < n) {
                Object selectedObject = objectArray[n2];
                try {
                    if (selectedObject instanceof ReportTreeEntity && ((ReportTreeEntity)selectedObject).getObject() instanceof ReportEntity) {
                        ReportEntity reportEntity = ((ReportTreeEntity)selectedObject).getObject();
                        this.exportToPDF(reportEntity, exportDirectory, shell);
                    }
                }
                catch (Exception e) {
                    LoggerSingleton.logError((Throwable)e);
                    MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)("Unable to export pdf report (" + e.getClass().getSimpleName() + ")"), (String)e.getMessage());
                }
                ++n2;
            }
        }
    }

    private void exportToPDF(final ReportEntity reportEntity, final File exportDirectory, Shell shell) throws InvocationTargetException, InterruptedException {
        ProgressMonitorDialog monitorDialog = new ProgressMonitorDialog(shell);
        monitorDialog.run(true, false, new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    try {
                        monitor.beginTask("Exporting report to PDF...", -1);
                        TestSuiteLogRecord suiteLogRecord = LogRecordLookup.getInstance().getTestSuiteLogRecord(reportEntity);
                        TestSuitePdfGenerator generator = new TestSuitePdfGenerator(suiteLogRecord);
                        File exportedFile = generator.exportToPDF(new File(exportDirectory, String.valueOf(FilenameUtils.getBaseName((String)reportEntity.getDisplayName())) + ".pdf").getAbsolutePath());
                        Program.launch((String)exportedFile.toURI().toString());
                    }
                    catch (JasperReportException | IOException e) {
                        ExportPDFReportHandler.this.sync.syncExec(new Runnable((Exception)e){
                            private final /* synthetic */ Exception val$e;
                            {
                                this.val$e = exception;
                            }

                            @Override
                            public void run() {
                                MultiStatusErrorDialog.showErrorDialog((Throwable)this.val$e, (String)("Unable to export pdf report (" + this.val$e.getClass().getSimpleName() + ")"), (String)this.val$e.getMessage());
                                LoggerSingleton.logError((Throwable)this.val$e);
                            }
                        });
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
            }
        });
    }
}

