/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.report.handlers;

import com.kms.katalon.composer.components.impl.tree.ReportTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.core.reporting.ReportUtil;
import com.kms.katalon.entity.report.ReportEntity;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Shell;

public class ExportHTMLReportHandler {
    @CanExecute
    public static boolean canExecute(ESelectionService selectionService) {
        return true;
    }

    @Execute
    public static void execute(ESelectionService selectionService, Shell shell) {
        DirectoryDialog directoryDialog = new DirectoryDialog(shell);
        directoryDialog.open();
        if (directoryDialog.getFilterPath() == null) {
            MessageDialog.openWarning(null, (String)"Warning", (String)"Directory not found.");
            return;
        }
        File exportDirectory = new File(directoryDialog.getFilterPath());
        if (exportDirectory != null && exportDirectory.exists() && exportDirectory.isDirectory()) {
            Object[] selectedObjects;
            Object[] objectArray = selectedObjects = (Object[])selectionService.getSelection("com.kms.katalon.composer.part.explorer");
            int n = selectedObjects.length;
            int n2 = 0;
            while (n2 < n) {
                Object selectedObject = objectArray[n2];
                try {
                    if (selectedObject instanceof ReportTreeEntity && ((ReportTreeEntity)selectedObject).getObject() instanceof ReportEntity) {
                        ReportEntity report = ((ReportTreeEntity)selectedObject).getObject();
                        File htmlFile = new File(report.getHtmlFile());
                        if (!htmlFile.exists()) {
                            ReportUtil.writeLogRecordToFiles((String)report.getLocation());
                        }
                        File exportedHtml = new File(exportDirectory, String.valueOf(report.getDisplayName()) + ".html");
                        FileUtils.copyFile((File)htmlFile, (File)exportedHtml);
                        Program.launch((String)exportedHtml.toURI().toString());
                    }
                }
                catch (Throwable e) {
                    LoggerSingleton.logError((Throwable)e);
                    MessageDialog.openError((Shell)shell, (String)"Error", (String)("Unable to export html report (" + e.getMessage() + ")"));
                }
                ++n2;
            }
        }
    }
}

