/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.report.handlers;

import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.integration.analytics.constants.ComposerAnalyticsStringConstants;
import com.kms.katalon.composer.integration.analytics.constants.ComposerIntegrationAnalyticsMessageConstants;
import com.kms.katalon.composer.report.constants.ComposerReportMessageConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.integration.analytics.constants.IntegrationAnalyticsMessages;
import com.kms.katalon.integration.analytics.entity.AnalyticsProject;
import com.kms.katalon.integration.analytics.entity.AnalyticsTeam;
import com.kms.katalon.integration.analytics.entity.AnalyticsTokenInfo;
import com.kms.katalon.integration.analytics.exceptions.AnalyticsApiExeception;
import com.kms.katalon.integration.analytics.providers.AnalyticsApiProvider;
import com.kms.katalon.integration.analytics.setting.AnalyticsSettingStore;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class AnalyticsAuthorizationHandler {
    public static AnalyticsTokenInfo getToken(String serverUrl, String email, String password, AnalyticsSettingStore settingStore) {
        try {
            boolean encryptionEnabled = true;
            AnalyticsTokenInfo tokenInfo = AnalyticsApiProvider.requestToken((String)serverUrl, (String)email, (String)password);
            settingStore.setToken(tokenInfo.getAccess_token(), encryptionEnabled);
            return tokenInfo;
        }
        catch (Exception ex) {
            LoggerSingleton.logError((Throwable)ex);
            try {
                settingStore.setPassword("", true);
                settingStore.enableIntegration(false);
            }
            catch (IOException | GeneralSecurityException e) {
                LoggerSingleton.logError((Throwable)e);
            }
            MultiStatusErrorDialog.showErrorDialog((Throwable)ex, (String)ComposerAnalyticsStringConstants.ERROR, (String)ComposerIntegrationAnalyticsMessageConstants.MSG_REQUEST_TOKEN_ERROR);
            return null;
        }
    }

    public static List<AnalyticsProject> getProjects(final String serverUrl, String email, String password, final AnalyticsTeam team, final AnalyticsTokenInfo tokenInfo, ProgressMonitorDialog monitorDialog) {
        final ArrayList<AnalyticsProject> projects = new ArrayList<AnalyticsProject>();
        try {
            monitorDialog.run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            monitor.beginTask(IntegrationAnalyticsMessages.MSG_DLG_PRG_RETRIEVING_PROJECTS, 2);
                            monitor.subTask(IntegrationAnalyticsMessages.MSG_DLG_PRG_GETTING_PROJECTS);
                            List loaded = AnalyticsApiProvider.getProjects((String)serverUrl, (AnalyticsTeam)team, (String)tokenInfo.getAccess_token());
                            if (loaded != null && !loaded.isEmpty()) {
                                projects.addAll(loaded);
                            }
                            monitor.worked(1);
                        }
                        catch (Exception e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
            return projects;
        }
        catch (InvocationTargetException exception) {
            Throwable cause = exception.getCause();
            if (cause instanceof AnalyticsApiExeception) {
                MultiStatusErrorDialog.showErrorDialog((Throwable)exception, (String)ComposerAnalyticsStringConstants.ERROR, (String)cause.getMessage());
            } else {
                LoggerSingleton.logError((Throwable)cause);
            }
        }
        catch (InterruptedException interruptedException) {}
        return projects;
    }

    public static List<AnalyticsTeam> getTeams(final String serverUrl, String email, String password, final AnalyticsTokenInfo tokenInfo, ProgressMonitorDialog monitorDialog) {
        final ArrayList<AnalyticsTeam> teams = new ArrayList<AnalyticsTeam>();
        try {
            monitorDialog.run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            monitor.beginTask(IntegrationAnalyticsMessages.MSG_DLG_PRG_RETRIEVING_TEAMS, 2);
                            monitor.subTask(IntegrationAnalyticsMessages.MSG_DLG_PRG_GETTING_TEAMS);
                            List loaded = AnalyticsApiProvider.getTeams((String)serverUrl, (String)tokenInfo.getAccess_token());
                            if (loaded != null && !loaded.isEmpty()) {
                                teams.addAll(loaded);
                            }
                            monitor.worked(1);
                        }
                        catch (Exception e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
            return teams;
        }
        catch (InvocationTargetException exception) {
            Throwable cause = exception.getCause();
            if (cause instanceof AnalyticsApiExeception) {
                MultiStatusErrorDialog.showErrorDialog((Throwable)exception, (String)ComposerAnalyticsStringConstants.ERROR, (String)cause.getMessage());
            } else {
                LoggerSingleton.logError((Throwable)cause);
            }
        }
        catch (InterruptedException interruptedException) {}
        return teams;
    }

    public static void createDefaultProject(final AnalyticsSettingStore analyticsSettingStore, final String serverUrl, final AnalyticsTeam team, final AnalyticsTokenInfo tokenInfo, ProgressMonitorDialog monitorDialog) {
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        final String currentProjectName = project.getName();
        try {
            monitorDialog.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    try {
                        monitor.beginTask(ComposerReportMessageConstants.REPORT_MSG_UPLOADING_TO_ANALYTICS, 2);
                        monitor.subTask(ComposerReportMessageConstants.REPORT_MSG_UPLOADING_TO_ANALYTICS_SENDING);
                        AnalyticsProject analyticsProject = AnalyticsApiProvider.createProject((String)serverUrl, (String)currentProjectName, (AnalyticsTeam)team, (String)tokenInfo.getAccess_token());
                        analyticsSettingStore.setProject(analyticsProject);
                        analyticsSettingStore.setTeam(team);
                        monitor.worked(1);
                    }
                    catch (AnalyticsApiExeception | IOException ex) {
                        LoggerSingleton.logError((Throwable)ex);
                        MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)ComposerAnalyticsStringConstants.ERROR, (String)ComposerReportMessageConstants.REPORT_ERROR_MSG_UNABLE_TO_UPLOAD_REPORT);
                    }
                }
            });
        }
        catch (InterruptedException | InvocationTargetException ex) {
            LoggerSingleton.logError((Throwable)ex);
            MultiStatusErrorDialog.showErrorDialog((Throwable)ex, (String)ComposerAnalyticsStringConstants.ERROR, (String)ComposerReportMessageConstants.REPORT_ERROR_MSG_UNABLE_TO_UPLOAD_REPORT);
        }
    }
}

