/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.operation;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.ObjectUndoContext;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.PlatformUI;

public class OperationExecutor {
    private IUndoContext undoContext;
    private IOperationHistory operationHistory;
    private Object parentPart;

    public OperationExecutor(Object parentPart) {
        this.undoContext = new ObjectUndoContext(parentPart);
        this.parentPart = parentPart;
    }

    private IOperationHistory getOperationHistory() {
        if (this.operationHistory == null) {
            this.operationHistory = PlatformUI.getWorkbench().getOperationSupport().getOperationHistory();
        }
        return this.operationHistory;
    }

    public IUndoContext getUndoContext() {
        return this.undoContext;
    }

    public IStatus executeOperation(IUndoableOperation operation, IProgressMonitor progressMonitor, IAdaptable adaptable) {
        IOperationHistory operationHistory = this.getOperationHistory();
        try {
            operation.addContext(this.undoContext);
            return operationHistory.execute(operation, progressMonitor, adaptable);
        }
        catch (ExecutionException e) {
            LoggerSingleton.logError(e);
            return Status.CANCEL_STATUS;
        }
    }

    public IStatus executeOperation(IUndoableOperation operation, IAdaptable adaptable) {
        return this.executeOperation(operation, (IProgressMonitor)new NullProgressMonitor(), adaptable);
    }

    public IStatus executeOperation(IUndoableOperation operation) {
        return this.executeOperation(operation, null);
    }

    public IStatus undoOperation(IAdaptable adaptable, IProgressMonitor progressMonitor) {
        IOperationHistory operationHistory = this.getOperationHistory();
        try {
            return operationHistory.undo(this.undoContext, progressMonitor, adaptable);
        }
        catch (ExecutionException e) {
            LoggerSingleton.logError(e);
            return Status.CANCEL_STATUS;
        }
    }

    public IStatus undoOperation(IAdaptable adaptable) {
        return this.undoOperation(adaptable, (IProgressMonitor)new NullProgressMonitor());
    }

    public IStatus undoOperation() {
        return this.undoOperation(null);
    }

    public IStatus redoOperation(IAdaptable adaptable, IProgressMonitor progressMonitor) {
        IOperationHistory operationHistory = this.getOperationHistory();
        try {
            return operationHistory.redo(this.undoContext, progressMonitor, adaptable);
        }
        catch (ExecutionException e) {
            LoggerSingleton.logError(e);
            return Status.CANCEL_STATUS;
        }
    }

    public IStatus redoOperation(IAdaptable adaptable) {
        return this.redoOperation(adaptable, (IProgressMonitor)new NullProgressMonitor());
    }

    public IStatus redoOperation() {
        return this.redoOperation(null);
    }

    public void dispose() {
        this.getOperationHistory().dispose(this.undoContext, true, true, true);
    }

    public void refresh() {
        this.dispose();
        this.undoContext = new ObjectUndoContext(this.parentPart);
    }
}

