/*
 * Decompiled with CFR 0.152.
 */
package org.stringtemplate.v4.misc;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import org.stringtemplate.v4.misc.Coordinate;

public class Misc {
    public static final String newline = System.getProperty("line.separator");

    public static String join(Iterator iter, String separator) {
        StringBuilder buf = new StringBuilder();
        while (iter.hasNext()) {
            buf.append(iter.next());
            if (!iter.hasNext()) continue;
            buf.append(separator);
        }
        return buf.toString();
    }

    public static String strip(String s, int n2) {
        return s.substring(n2, s.length() - n2);
    }

    public static String trimOneStartingNewline(String s) {
        if (s.startsWith("\r\n")) {
            s = s.substring(2);
        } else if (s.startsWith("\n")) {
            s = s.substring(1);
        }
        return s;
    }

    public static String trimOneTrailingNewline(String s) {
        if (s.endsWith("\r\n")) {
            s = s.substring(0, s.length() - 2);
        } else if (s.endsWith("\n")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public static String stripLastPathElement(String f2) {
        int slash = f2.lastIndexOf(47);
        if (slash < 0) {
            return f2;
        }
        return f2.substring(0, slash);
    }

    public static String getFileNameNoSuffix(String f2) {
        if (f2 == null) {
            return null;
        }
        f2 = Misc.getFileName(f2);
        return f2.substring(0, f2.lastIndexOf(46));
    }

    public static String getFileName(String fullFileName) {
        if (fullFileName == null) {
            return null;
        }
        File f2 = new File(fullFileName);
        return f2.getName();
    }

    public static String getPrefix(String name) {
        if (name == null) {
            return null;
        }
        int lastSlash = name.lastIndexOf(47);
        if (lastSlash > 0) {
            return name.substring(0, lastSlash);
        }
        return "";
    }

    public static String replaceEscapes(String s) {
        s = s.replaceAll("\n", "\\\\n");
        s = s.replaceAll("\r", "\\\\r");
        s = s.replaceAll("\t", "\\\\t");
        return s;
    }

    public static boolean urlExists(URL url) {
        try {
            URLConnection con = url.openConnection();
            InputStream is = con.getInputStream();
            is.close();
            return true;
        }
        catch (IOException ioe) {
            return false;
        }
    }

    public static Coordinate getLineCharPosition(String s, int index) {
        int line = 1;
        int charPos = 0;
        for (int p = 0; p < index; ++p) {
            if (s.charAt(p) == '\n') {
                ++line;
                charPos = 0;
                continue;
            }
            ++charPos;
        }
        return new Coordinate(line, charPos);
    }

    public static Object accessField(Field f2, Object o2, Object value) throws IllegalAccessException {
        try {
            f2.setAccessible(true);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        value = f2.get(o2);
        return value;
    }

    public static Object invokeMethod(Method m2, Object o2, Object value) throws IllegalAccessException, InvocationTargetException {
        try {
            m2.setAccessible(true);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        value = m2.invoke(o2, (Object[])null);
        return value;
    }

    public static Method getMethod(Class c2, String methodName) {
        Method m2;
        try {
            m2 = c2.getMethod(methodName, null);
        }
        catch (NoSuchMethodException nsme) {
            m2 = null;
        }
        return m2;
    }
}

