/*
 * Decompiled with CFR 0.152.
 */
package org.stringtemplate.v4;

import java.net.URLEncoder;
import java.util.Locale;
import org.stringtemplate.v4.AttributeRenderer;

public class StringRenderer
implements AttributeRenderer {
    public String toString(Object o2, String formatString, Locale locale) {
        String s = (String)o2;
        if (formatString == null) {
            return s;
        }
        if (formatString.equals("upper")) {
            return s.toUpperCase(locale);
        }
        if (formatString.equals("lower")) {
            return s.toLowerCase(locale);
        }
        if (formatString.equals("cap")) {
            return s.length() > 0 ? Character.toUpperCase(s.charAt(0)) + s.substring(1) : s;
        }
        if (formatString.equals("url-encode")) {
            return URLEncoder.encode(s);
        }
        if (formatString.equals("xml-encode")) {
            return StringRenderer.escapeHTML(s);
        }
        return String.format(formatString, s);
    }

    public static String escapeHTML(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder(s.length());
        int len = s.length();
        block6: for (int i2 = 0; i2 < len; ++i2) {
            char c2 = s.charAt(i2);
            switch (c2) {
                case '&': {
                    buf.append("&amp;");
                    continue block6;
                }
                case '<': {
                    buf.append("&lt;");
                    continue block6;
                }
                case '>': {
                    buf.append("&gt;");
                    continue block6;
                }
                case '\t': 
                case '\n': 
                case '\r': {
                    buf.append(c2);
                    continue block6;
                }
                default: {
                    boolean aboveASCII;
                    boolean control = c2 < ' ';
                    boolean bl = aboveASCII = c2 > '~';
                    if (control || aboveASCII) {
                        buf.append("&#");
                        buf.append((int)c2);
                        buf.append(";");
                        continue block6;
                    }
                    buf.append(c2);
                }
            }
        }
        return buf.toString();
    }
}

