/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.ocr;

import com.google.guava19.common.collect.Lists;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.nodes.PImage;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.sikuli.core.draw.PiccoloImageRenderer;
import org.sikuli.core.logging.ImageExplainer;
import org.sikuli.core.search.ImageQuery;
import org.sikuli.core.search.ImageSearcher;
import org.sikuli.core.search.RegionMatch;
import org.sikuli.ocr.FontLibrary;
import org.sikuli.ocr.FontModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FontModelLearner {
    private static ImageExplainer explainer = ImageExplainer.getExplainer(FontModelLearner.class);
    private static Logger logger = LoggerFactory.getLogger(FontModelLearner.class);

    private static BufferedImage crop(BufferedImage src, int x, int y, int width, int height) {
        BufferedImage dest = new BufferedImage(width, height, 5);
        Graphics g2 = dest.getGraphics();
        g2.drawImage(src, 0, 0, width, height, x, y, x + width, y + height, null);
        g2.dispose();
        return dest;
    }

    public static FontModel learn(BufferedImage trainingImage, String text) {
        logger.trace("learning started");
        final ArrayList imageList = Lists.newArrayList();
        ArrayList candidates = Lists.newArrayList();
        List<Font> fonts = FontLibrary.getFonts();
        double[] sizes = new double[]{14.0, 13.0, 12.0, 11.0, 10.0, 9.0};
        double[] trackings = new double[]{0.0, -0.01, -0.02, -0.03};
        for (Font font : fonts) {
            for (double size : sizes) {
                for (double tracking : trackings) {
                    FontModel model = new FontModel();
                    model.setFont(font);
                    model.setSize(size);
                    model.setTracking(tracking);
                    candidates.add(model);
                }
            }
        }
        logger.trace("parameters generated");
        for (FontModel candidate : candidates) {
            BufferedImage modelImage = candidate.toImage(text);
            imageList.add(modelImage);
        }
        logger.trace("individual model images generated");
        BufferedImage tallestImage = Collections.max(imageList, new Comparator<BufferedImage>(){

            @Override
            public int compare(BufferedImage a2, BufferedImage b2) {
                return a2.getHeight() - b2.getHeight();
            }
        });
        BufferedImage widestImage = Collections.max(imageList, new Comparator<BufferedImage>(){

            @Override
            public int compare(BufferedImage a2, BufferedImage b2) {
                return a2.getWidth() - b2.getWidth();
            }
        });
        int n2 = imageList.size();
        final int dy = tallestImage.getHeight() + 2;
        int w = widestImage.getWidth() + 10;
        PiccoloImageRenderer a2 = new PiccoloImageRenderer(w, n2 * dy){

            @Override
            protected void addContent(PLayer layer) {
                for (int i2 = 0; i2 < imageList.size(); ++i2) {
                    BufferedImage image = (BufferedImage)imageList.get(i2);
                    PImage pImage = new PImage(image);
                    pImage.setOffset(5.0, i2 * dy);
                    layer.addChild(pImage);
                }
            }
        };
        BufferedImage tiledModelImage = a2.render();
        explainer.step(tiledModelImage, (Object)"tiledModelImage");
        logger.trace("tiled model image generated");
        ImageSearcher s = new ImageSearcher(tiledModelImage);
        ImageQuery q = new ImageQuery(trainingImage);
        List matches = s.search(q, null, 1);
        RegionMatch m2 = (RegionMatch)matches.get(0);
        int index = (int)Math.round(1.0 * (double)(m2.y + 1) / (double)dy);
        logger.trace("learning stopped. top score = " + m2.getScore() + " index = " + index + " m.y = " + m2.y);
        FontModel bestModel = (FontModel)candidates.get(index);
        return bestModel;
    }

    static class FontModelCandidate {
        private final FontModel model;
        private final double score;

        public FontModelCandidate(FontModel model, double score) {
            this.model = model;
            this.score = score;
        }

        public FontModel getModel() {
            return this.model;
        }
    }
}

