/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.core.search.algorithm;

import com.google.guava19.common.collect.Lists;
import com.googlecode.javacv.cpp.opencv_core;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import org.sikuli.core.search.RegionMatch;
import org.sikuli.core.search.TemplateMatchingUtilities;
import org.sikuli.core.search.algorithm.GrayscaleTemplateMatchAlgorithm;

public class SearchByGrayscaleAtOriginalResolution
extends GrayscaleTemplateMatchAlgorithm {
    opencv_core.IplImage resultMatrix = null;

    public SearchByGrayscaleAtOriginalResolution(BufferedImage input, BufferedImage query) {
        super(input, query);
    }

    @Override
    public void execute() {
        this.resultMatrix = TemplateMatchingUtilities.computeTemplateMatchResultMatrix(this.input, this.query);
    }

    @Override
    public RegionMatch fetchNext() {
        TemplateMatchingUtilities.TemplateMatchResult result = TemplateMatchingUtilities.fetchNextBestMatch(this.resultMatrix, this.query);
        RegionMatch m2 = new RegionMatch(result);
        m2.setScore(result.score);
        return m2;
    }

    public List<RegionMatch> fetchAll(int limit, double minScore) {
        RegionMatch m2;
        ArrayList matches = Lists.newArrayList();
        while (matches.size() < limit && (m2 = this.fetchNext()).getScore() >= minScore) {
            matches.add(m2);
        }
        return matches;
    }
}

