/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.core.search;

import com.google.guava19.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.sikuli.core.search.Collector;
import org.sikuli.core.search.Filter;
import org.sikuli.core.search.Match;
import org.sikuli.core.search.Query;
import org.sikuli.core.search.SearchAlgorithm;
import org.sikuli.core.search.TopMatchesCollector;

public abstract class Searcher<T extends Match> {
    protected abstract SearchAlgorithm<T> getAlgorithm(Query var1);

    protected void explain(Query query, List<T> outputs) {
    }

    public List<T> search(Query query, Filter<T> filter, int n2) {
        TopMatchesCollector results = new TopMatchesCollector(n2);
        this.search(query, filter, results);
        return results.topMatches();
    }

    public List<T> search(Query query, Filter<T> filter, int n2, SearchAlgorithm<T> alg) {
        TopMatchesCollector results = new TopMatchesCollector(n2);
        this.search(query, filter, results, alg);
        return results.topMatches();
    }

    public List<T> search(Query query, int n2) {
        TopMatchesCollector results = new TopMatchesCollector(n2);
        this.search(query, null, results);
        return results.topMatches();
    }

    private void search(Query query, Filter<T> filter, Collector<T> collector) {
        this.search(query, filter, collector, this.getAlgorithm(query));
    }

    private void search(Query query, Filter<T> filter, Collector<T> collector, SearchAlgorithm<T> alg) {
        alg.execute();
        ArrayList matches = Lists.newArrayList();
        while (!collector.hasEnough()) {
            T m2 = alg.fetchNext();
            if (filter == null || filter.accept(m2)) {
                collector.collect(m2);
                matches.add(m2);
            }
            if (filter == null || filter.acceptMore(m2)) continue;
            break;
        }
        this.explain(query, matches);
    }
}

