/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.core.cv;

import com.google.guava19.common.base.Function;
import com.google.guava19.common.collect.Iterables;
import com.google.guava19.common.collect.Lists;
import com.googlecode.javacpp.Loader;
import com.googlecode.javacv.cpp.opencv_core;
import com.googlecode.javacv.cpp.opencv_imgproc;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import org.sikuli.core.cv.ImagePreprocessor;
import org.sikuli.core.draw.ImageRenderer;
import org.sikuli.core.draw.PiccoloImageRenderer;
import org.sikuli.core.logging.ImageExplainer;

public class TextMap {
    private static final int MIN_CHARACTER_WIDTH = 1;
    private static final int MAX_CHARACTER_WIDTH = 50;
    private static final int MIN_CHARACTER_HEIGHT = 8;
    private static final int MAX_CHARACTER_HEIGHT = 20;
    ImageExplainer explainer = ImageExplainer.getExplainer(TextMap.class);
    private opencv_core.IplImage characterBlockMask;
    private List<TextBlock> blobs;

    public static TextMap createFrom(BufferedImage image) {
        TextMap m2 = new TextMap();
        m2.init(image);
        return m2;
    }

    public double computeTextScore(int x, int y, int width, int height) {
        int x1 = Math.max(0, x);
        int y1 = Math.max(0, y);
        int w1 = Math.min(this.characterBlockMask.width() - x1 - 2, width);
        int h1 = Math.min(this.characterBlockMask.height() - y1 - 2, height);
        int w0 = this.characterBlockMask.width();
        int h0 = this.characterBlockMask.height();
        opencv_core.cvSetImageROI(this.characterBlockMask, opencv_core.cvRect(x1, y1, w1, h1));
        int n2 = opencv_core.cvCountNonZero(this.characterBlockMask);
        opencv_core.cvResetImageROI(this.characterBlockMask);
        return 1.0 * (double)n2 / (double)(width * height);
    }

    public Iterable<Rectangle> getCharacterBounds() {
        return Iterables.transform(this.blobs, (Function)new Function<TextBlock, Rectangle>(){

            public Rectangle apply(TextBlock b2) {
                return new Rectangle(b2.x, b2.y, b2.width, b2.height);
            }
        });
    }

    void init(BufferedImage image) {
        this.explainer.step(image, (Object)"input image");
        opencv_core.IplImage grayImage = ImagePreprocessor.createGrayscale(image);
        opencv_core.IplImage foregroundMask = this.computeForegroundMask(grayImage);
        this.explainer.step(foregroundMask, (Object)"foreground mask");
        this.blobs = this.computeBlobs(foregroundMask);
        this.explainer.step(this.visualize(foregroundMask.getBufferedImage(), this.blobs), (Object)"extracted blobs");
        this.blobs = this.rejectOverlyLargeOrSmallBlobs(this.blobs);
        this.explainer.step(this.visualize(foregroundMask.getBufferedImage(), this.blobs), (Object)"overly small/large blobs removed");
        this.characterBlockMask = this.computeCharacterBlockMask(foregroundMask, this.blobs);
        this.explainer.step(this.characterBlockMask.getBufferedImage(), (Object)"character block mask");
    }

    public BufferedImage getImage() {
        return this.characterBlockMask.getBufferedImage();
    }

    ImageRenderer visualize(BufferedImage input, final List<TextBlock> blobs) {
        PiccoloImageRenderer m2 = new PiccoloImageRenderer(input){

            @Override
            protected void addContent(PLayer layer) {
                for (TextBlock b2 : blobs) {
                    PPath p = PPath.createRectangle(b2.x, b2.y, b2.width, b2.height);
                    p.setStrokePaint(Color.red);
                    p.setPaint(null);
                    layer.addChild(p);
                }
            }
        };
        return m2;
    }

    opencv_core.IplImage computeForegroundMask(opencv_core.IplImage grayImage) {
        opencv_core.IplImage foregroundMask = opencv_core.IplImage.create(opencv_core.cvGetSize(grayImage), 8, 1);
        opencv_core.IplImage edgeMap = opencv_core.IplImage.create(opencv_core.cvGetSize(grayImage), 8, 1);
        opencv_imgproc.cvCanny(grayImage, edgeMap, 33.0, 66.5, 3);
        opencv_imgproc.IplConvKernel kernel = opencv_imgproc.IplConvKernel.create(3, 3, 1, 1, 0, null);
        opencv_imgproc.cvDilate(edgeMap, edgeMap, kernel, 1);
        kernel.release();
        opencv_imgproc.cvAdaptiveThreshold(grayImage, foregroundMask, 255.0, 0, 1, 5, 1.0);
        opencv_core.cvAnd(foregroundMask, edgeMap, foregroundMask, null);
        return foregroundMask;
    }

    List<TextBlock> computeBlobs(opencv_core.IplImage binaryImage) {
        opencv_core.IplImage clone = binaryImage.clone();
        opencv_core.CvMemStorage storage = opencv_core.CvMemStorage.create();
        opencv_core.CvSeq contour = new opencv_core.CvSeq(null);
        opencv_imgproc.cvFindContours(clone, storage, contour, Loader.sizeof(opencv_core.CvContour.class), 3, 2);
        ArrayList blobs = Lists.newArrayList();
        this.collectBlobs(contour, blobs);
        return blobs;
    }

    void collectBlobs(opencv_core.CvSeq seq, List<TextBlock> blobs) {
        while (seq != null && !seq.isNull()) {
            if (seq.elem_size() > 0) {
                opencv_core.CvRect b2 = opencv_imgproc.cvBoundingRect(seq, 0);
                if (b2.height() < 20) {
                    TextBlock blob = new TextBlock(b2.x(), b2.y(), b2.width(), b2.height());
                    blobs.add(blob);
                } else {
                    this.collectBlobs(seq.v_next(), blobs);
                }
            }
            seq = seq.h_next();
        }
    }

    List<TextBlock> rejectOverlyLargeOrSmallBlobs(List<TextBlock> blobs) {
        ArrayList out = Lists.newArrayList();
        for (TextBlock b2 : blobs) {
            if (b2.width > 50 || b2.height > 20 || b2.width < 1 || b2.height < 8) continue;
            out.add(b2);
        }
        return out;
    }

    opencv_core.IplImage computeCharacterBlockMask(opencv_core.IplImage foregroundMask, List<TextBlock> blobs) {
        opencv_core.IplImage characterBlockMask = opencv_core.IplImage.create(opencv_core.cvGetSize(foregroundMask), 8, 1);
        opencv_core.cvSet(characterBlockMask, opencv_core.cvScalarAll(0.0), null);
        for (TextBlock b2 : blobs) {
            opencv_core.cvSetImageROI(characterBlockMask, opencv_core.cvRect(b2.x, b2.y, b2.width, b2.height));
            opencv_core.cvSet(characterBlockMask, opencv_core.cvScalarAll(255.0), null);
        }
        return characterBlockMask;
    }

    static class TextBlock {
        public int x;
        public int y;
        public int width;
        public int height;

        public TextBlock(int x, int y, int width, int height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }
    }
}

