/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.api.robot.desktop;

import com.google.guava19.common.collect.Lists;
import java.awt.AWTException;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.List;
import org.sikuli.api.DefaultScreenLocation;
import org.sikuli.api.ScreenLocation;
import org.sikuli.api.robot.desktop.AWTMouse;
import org.sikuli.api.robot.desktop.AWTRobot;
import org.sikuli.api.robot.desktop.DesktopScreen;

class AWTDesktop {
    private static GraphicsEnvironment _genv = GraphicsEnvironment.getLocalGraphicsEnvironment();
    private static GraphicsDevice[] _gdev = _genv.getScreenDevices();
    private static AWTRobot[] _robots;
    private static List<ScreenDevice> _screens;

    AWTDesktop() {
    }

    private static void initScreens() {
        _screens = Lists.newArrayList();
        for (int i2 = 0; i2 < _gdev.length; ++i2) {
            ScreenDevice device = new ScreenDevice();
            device.id = i2;
            device.gdev = _gdev[i2];
            device.robot = _robots[i2];
            device.mouse = new AWTMouse(device.robot);
            device.screen = new DesktopScreen(i2);
            _screens.add(device);
        }
    }

    private static void initRobots() {
        try {
            _robots = new AWTRobot[_gdev.length];
            for (int i2 = 0; i2 < _gdev.length; ++i2) {
                AWTDesktop._robots[i2] = new AWTRobot(_gdev[i2]);
                _robots[i2].setAutoDelay(10);
            }
        }
        catch (AWTException aWTException) {
            // empty catch block
        }
    }

    public static ScreenLocation getCurrentMouseScreenLocation() {
        Point p = MouseInfo.getPointerInfo().getLocation();
        DesktopScreen screen = AWTDesktop.getCurrentScreenDevice().screen;
        DefaultScreenLocation screenLocation = new DefaultScreenLocation(screen, p.x, p.y);
        screenLocation.setScreen(screen);
        return screenLocation;
    }

    static AWTMouse getCurrentMouse() {
        return AWTDesktop.getCurrentScreenDevice().mouse;
    }

    static ScreenDevice getCurrentScreenDevice() {
        GraphicsDevice currentGraphicsDevice = MouseInfo.getPointerInfo().getDevice();
        for (ScreenDevice s : _screens) {
            if (s.gdev != currentGraphicsDevice) continue;
            return s;
        }
        return null;
    }

    static ScreenDevice getScreenDevice(int id) {
        if (id < _screens.size()) {
            return _screens.get(id);
        }
        return null;
    }

    public static AWTRobot getCurrentRobot() {
        return AWTDesktop.getCurrentScreenDevice().getRobot();
    }

    static AWTMouse getMouse(ScreenLocation location) {
        int id = ((DesktopScreen)location.getScreen()).getId();
        return AWTDesktop._screens.get((int)id).mouse;
    }

    static AWTRobot getRobot(ScreenLocation location) {
        int id = ((DesktopScreen)location.getScreen()).getId();
        return AWTDesktop._screens.get((int)id).robot;
    }

    public static Rectangle getScreenBounds(int screenId) {
        return AWTDesktop.getScreenDevice(screenId).getBounds();
    }

    public static BufferedImage captureScreenshot(int screenId, int x, int y, int width, int height) {
        return _robots[screenId].captureScreen(new Rectangle(x, y, width, height));
    }

    static {
        AWTDesktop.initRobots();
        AWTDesktop.initScreens();
    }

    static class ScreenDevice {
        int id;
        GraphicsDevice gdev;
        AWTRobot robot;
        AWTMouse mouse;
        DesktopScreen screen;

        ScreenDevice() {
        }

        Rectangle getBounds() {
            return this.gdev.getDefaultConfiguration().getBounds();
        }

        AWTRobot getRobot() {
            return this.robot;
        }
    }
}

