/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.api;

import com.google.guava19.common.collect.Lists;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import org.sikuli.api.APILogger;
import org.sikuli.api.DefaultTarget;
import org.sikuli.api.ScreenLocation;
import org.sikuli.api.ScreenRegion;
import org.sikuli.api.Target;
import org.sikuli.core.draw.PiccoloImageRenderer;

class ScreenRegionImageLogger
extends APILogger {
    private final ScreenRegion loggedScreenRegion;
    private final File outputDir;

    ScreenRegionImageLogger(ScreenRegion region, File outputDir) {
        this.loggedScreenRegion = region;
        this.outputDir = outputDir;
        if (!outputDir.exists()) {
            outputDir.mkdir();
        }
    }

    void writeLogImage(BufferedImage image, String postfix) {
        try {
            String filename = System.currentTimeMillis() + "-" + postfix + ".png";
            ImageIO.write((RenderedImage)image, "png", new File(this.outputDir, filename));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void logMouseAction(final String actionName, final ScreenLocation location) {
        BufferedImage img = this.loggedScreenRegion.capture();
        LogImageRenderer ir = new LogImageRenderer(img){

            @Override
            protected void addContent(PLayer layer) {
                PPath c2 = PPath.createEllipse(0.0f, 0.0f, 10.0f, 10.0f);
                c2.setPaint(Color.red);
                c2.setOffset((double)location.getX() - ScreenRegionImageLogger.this.loggedScreenRegion.getBounds().getX() - 5.0, (double)location.getY() - ScreenRegionImageLogger.this.loggedScreenRegion.getBounds().getY() - 5.0);
                layer.addChild(c2);
                this.addTextLabel(layer, actionName, location.getX() - ((ScreenRegionImageLogger)ScreenRegionImageLogger.this).loggedScreenRegion.getBounds().x - 20, location.getY() - ((ScreenRegionImageLogger)ScreenRegionImageLogger.this).loggedScreenRegion.getBounds().y - 40);
                1.addNodeWithShadow(layer, c2);
            }
        };
        this.writeLogImage(ir.render(), actionName);
    }

    private void logFindHelper(final String actionName, final ScreenRegion screenRegion, final Target target, final List<ScreenRegion> results) {
        BufferedImage img = this.loggedScreenRegion.getLastCapturedImage();
        LogImageRenderer ir = new LogImageRenderer(img){

            @Override
            protected void addContent(PLayer layer) {
                this.addTextLabel(layer, actionName, 3, 3);
                BufferedImage targetImage = ((DefaultTarget)target).toImage();
                if (targetImage != null) {
                    PImage im = new PImage(targetImage);
                    im.setOffset(3.0, 30.0);
                    im.setPaint(Color.black);
                    2.addNodeWithShadow(layer, im);
                }
                this.addRectangle(layer, screenRegion.getBounds().x - ((ScreenRegionImageLogger)ScreenRegionImageLogger.this).loggedScreenRegion.getBounds().x, screenRegion.getBounds().y - ((ScreenRegionImageLogger)ScreenRegionImageLogger.this).loggedScreenRegion.getBounds().y, screenRegion.getBounds().width, screenRegion.getBounds().height, Color.green);
                for (ScreenRegion result : results) {
                    this.addRectangle(layer, result.getBounds().x - ((ScreenRegionImageLogger)ScreenRegionImageLogger.this).loggedScreenRegion.getBounds().x, result.getBounds().y - ((ScreenRegionImageLogger)ScreenRegionImageLogger.this).loggedScreenRegion.getBounds().y, result.getBounds().width, result.getBounds().height, Color.red);
                }
            }
        };
        this.writeLogImage(ir.render(), actionName);
    }

    @Override
    public void findAllPerformed(ScreenRegion screenRegion, Target target, List<ScreenRegion> results) {
        this.logFindHelper("FindAll", screenRegion, target, results);
    }

    @Override
    public void findPerformed(ScreenRegion screenRegion, Target target, ScreenRegion result) {
        ArrayList results = Lists.newArrayList();
        if (result != null) {
            results.add(result);
        }
        this.logFindHelper("Find", screenRegion, target, results);
    }

    @Override
    public void clickPerformed(ScreenLocation location) {
        this.logMouseAction("Click", location);
    }

    @Override
    public void rightClickPerformed(ScreenLocation location) {
        this.logMouseAction("RightClick", location);
    }

    @Override
    public void doubleClickPerformed(ScreenLocation location) {
        this.logMouseAction("DoubleClick", location);
    }

    @Override
    public void dragPerformed(ScreenLocation location) {
        this.logMouseAction("Drag", location);
    }

    @Override
    public void dropPerformed(ScreenLocation location) {
        this.logMouseAction("Drop", location);
    }

    abstract class LogImageRenderer
    extends PiccoloImageRenderer {
        public LogImageRenderer(BufferedImage input) {
            super(input);
        }

        void addTextLabel(PNode parent, String txt, int x, int y) {
            PText t = new PText(txt);
            t.setScale(1.5);
            t.setPaint(Color.yellow);
            t.setOffset(x, y);
            LogImageRenderer.addNodeWithShadow(parent, t);
        }

        void addRectangle(PNode parent, int x, int y, int width, int height, Color color) {
            PPath r = PPath.createRectangle(x, y, width, height);
            r.setStrokePaint(color);
            r.setStroke(new BasicStroke(2.0f));
            r.setPaint(null);
            LogImageRenderer.addNodeWithShadow(parent, r);
        }
    }
}

