/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.api;

import com.google.guava19.common.collect.Lists;
import com.google.guava19.common.primitives.Doubles;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sikuli.api.DefaultTarget;
import org.sikuli.api.ScreenRegion;
import org.sikuli.api.Target;

public class MultiStateTarget
extends DefaultTarget
implements Target {
    Map<Target, Object> states = new HashMap<Target, Object>();

    @Override
    protected List<ScreenRegion> getUnordredMatches(ScreenRegion screenRegion) {
        BufferedImage image = screenRegion.capture();
        ArrayList allMatches = Lists.newArrayList();
        for (Target t : this.states.keySet()) {
            t.setLimit(this.getLimit());
            List<ScreenRegion> matches = t.doFindAll(screenRegion);
            allMatches.addAll(matches);
        }
        Collections.sort(allMatches, new Comparator<ScreenRegion>(){

            @Override
            public int compare(ScreenRegion arg0, ScreenRegion arg1) {
                return Doubles.compare((double)arg1.getScore(), (double)arg0.getScore());
            }
        });
        for (ScreenRegion m2 : allMatches) {
            Rectangle oldBounds = m2.getBounds();
            Rectangle newBounds = new Rectangle();
            newBounds.width = oldBounds.width + 10;
            newBounds.height = oldBounds.height + 10;
            newBounds.x = oldBounds.x - 5;
            newBounds.y = oldBounds.y - 5;
            m2.setBounds(newBounds);
        }
        int n2 = Math.min(this.getLimit(), allMatches.size());
        List<ScreenRegion> results = allMatches.subList(0, n2);
        for (ScreenRegion r : results) {
            r.getStates().putAll(this.states);
        }
        return results;
    }

    public void addState(Target target, Object state) {
        this.states.put(target, state);
    }
}

