/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.api;

import com.google.guava19.common.collect.ImmutableList;
import com.google.guava19.common.collect.Lists;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.Timer;
import org.sikuli.api.APILogger;
import org.sikuli.api.AbstractScreenRegion;
import org.sikuli.api.DefaultScreenLocation;
import org.sikuli.api.Screen;
import org.sikuli.api.ScreenLocation;
import org.sikuli.api.ScreenRegion;
import org.sikuli.api.ScreenRegionRecorder;
import org.sikuli.api.Target;
import org.sikuli.api.event.StateChangeListener;
import org.sikuli.api.event.TargetEventListener;
import org.sikuli.api.event.VisualEventManager;
import org.sikuli.core.cv.ImageMask;
import org.sikuli.ocr.DigitRecognizer;
import org.sikuli.ocr.RecognizedDigit;

public class DefaultScreenRegion
extends AbstractScreenRegion
implements ScreenRegion {
    private BufferedImage lastCapturedImage;
    private Map<Target, Object> states = new ConcurrentHashMap<Target, Object>();
    private ImageMask mask = null;
    List<Rectangle> rois = Lists.newArrayList();

    public DefaultScreenRegion(Screen screen) {
        super(screen);
    }

    public DefaultScreenRegion(ScreenRegion parent, int x, int y, int width, int height) {
        super(parent.getScreen());
        this.setX(parent.getBounds().x + x);
        this.setY(parent.getBounds().y + y);
        this.setWidth(width);
        this.setHeight(height);
    }

    public DefaultScreenRegion(Screen screen, int x, int y, int width, int height) {
        super(screen);
        this.setX(x);
        this.setY(y);
        this.setWidth(width);
        this.setHeight(height);
    }

    @Override
    public List<ScreenRegion> findAll(Target target) {
        List<ScreenRegion> rs = target.doFindAll(this);
        return rs;
    }

    @Override
    public ScreenRegion find(Target target) {
        ScreenRegion result = this._find(target);
        APILogger.getLogger().findPerformed(this, target, result);
        return result;
    }

    private ScreenRegion _find(Target target) {
        int oldLimit = target.getLimit();
        target.setLimit(1);
        List<ScreenRegion> results = target.doFindAll(this);
        target.setLimit(oldLimit);
        ScreenRegion result = results.size() == 0 ? null : results.get(0);
        return result;
    }

    @Override
    public ScreenRegion wait(Target target, int mills) {
        RepeatFind ru = new RepeatFind(target, mills);
        ScreenRegion result = ru.run();
        APILogger.getLogger().waitPerformed(this, target, mills, result);
        return result;
    }

    @Override
    public BufferedImage capture() {
        this.lastCapturedImage = this.getScreen().getScreenshot(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        return this.lastCapturedImage;
    }

    private BufferedImage applyMask(BufferedImage input) {
        if (this.mask != null) {
            return this.mask.createMaskedImage(input);
        }
        return input;
    }

    @Override
    public BufferedImage getLastCapturedImage() {
        if (this.lastCapturedImage == null) {
            this.lastCapturedImage = this.capture();
        }
        return this.lastCapturedImage;
    }

    @Override
    public ScreenLocation getCenter() {
        return new DefaultScreenLocation(this.getScreen(), this.getX() + this.getWidth() / 2, this.getY() + this.getHeight() / 2);
    }

    @Override
    public void addTargetEventListener(Target target, TargetEventListener listener) {
        VisualEventManager.getSingleton().addTargetEventListener(this, target, listener);
    }

    @Override
    public void removeTargetEventListener(Target target, TargetEventListener listener) {
        VisualEventManager.getSingleton().removeTargetEventListener(this, target, listener);
    }

    @Override
    public ScreenRegion snapshot() {
        DefaultScreenRegion r = new DefaultScreenRegion(new StaticScreen(this), this.getX(), this.getY(), this.getWidth(), this.getHeight());
        return r;
    }

    public void record(File output, int duration) {
        ScreenRegionRecorder recorder = new ScreenRegionRecorder(this, output);
        recorder.start(duration);
    }

    @Override
    public void addStateChangeEventListener(StateChangeListener listener) {
        VisualEventManager.getSingleton().addStateChangeEventListener(this, listener);
    }

    public ImageMask getMask() {
        return this.mask;
    }

    public void setMask(ImageMask mask) {
        this.mask = mask;
    }

    @Override
    public void addROI(int x, int y, int width, int height) {
        this.rois.add(new Rectangle(x, y, width, height));
    }

    @Override
    public List<Rectangle> getROIs() {
        return ImmutableList.copyOf(this.rois);
    }

    public Integer extractInteger() {
        List<RecognizedDigit> digits = DigitRecognizer.recognize(this.capture());
        Collections.sort(digits, new Comparator<RecognizedDigit>(){

            @Override
            public int compare(RecognizedDigit d1, RecognizedDigit d2) {
                return d1.x - d2.x;
            }
        });
        String numberString = "";
        for (RecognizedDigit d2 : digits) {
            numberString = numberString + d2.digit;
        }
        return Integer.parseInt(numberString);
    }

    @Override
    public Map<Target, Object> getStates() {
        return this.states;
    }

    @Override
    public void addState(Target target, Object state) {
        this.states.put(target, state);
    }

    @Override
    public void removeState(Target target) {
        this.states.remove(target);
    }

    @Override
    public Object getState() {
        Target topStateTarget = null;
        double topScore = 0.0;
        Set<Target> keySet = this.states.keySet();
        for (Target target : keySet) {
            ScreenRegion match = this._find(target);
            if (match == null || !(match.getScore() > topScore)) continue;
            topStateTarget = target;
            topScore = match.getScore();
        }
        if (topStateTarget != null) {
            return this.states.get(topStateTarget);
        }
        return null;
    }

    static class StaticScreen
    implements Screen {
        final BufferedImage fullScreenshot;
        final Dimension screenSize;

        private static BufferedImage crop(BufferedImage src, int x, int y, int width, int height) {
            BufferedImage dest = new BufferedImage(width, height, 5);
            Graphics g2 = dest.getGraphics();
            g2.drawImage(src, 0, 0, width, height, x, y, x + width, y + height, null);
            g2.dispose();
            return dest;
        }

        StaticScreen(ScreenRegion screenRegion) {
            this.screenSize = screenRegion.getScreen().getSize();
            this.fullScreenshot = screenRegion.getScreen().getScreenshot(0, 0, this.screenSize.width, this.screenSize.height);
        }

        @Override
        public BufferedImage getScreenshot(int x, int y, int width, int height) {
            return StaticScreen.crop(this.fullScreenshot, x, y, width, height);
        }

        @Override
        public Dimension getSize() {
            return this.screenSize;
        }
    }

    class RepeatFind {
        private volatile boolean timeout = false;
        private Target target;
        private int duration;
        private ScreenRegion r = null;

        RepeatFind(Target target, int duration) {
            this.target = target;
            this.duration = duration;
        }

        public ScreenRegion run() {
            Timer t = new Timer(this.duration, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    RepeatFind.this.timeout = true;
                }
            });
            t.start();
            while (this.r == null && !this.timeout) {
                this.r = DefaultScreenRegion.this._find(this.target);
            }
            return this.r;
        }
    }
}

