/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.api;

import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.List;
import org.sikuli.api.ImageTarget;
import org.sikuli.api.ScreenRegion;
import org.sikuli.core.search.ColorImageQuery;
import org.sikuli.core.search.ImageSearcher;
import org.sikuli.core.search.RegionMatch;
import org.sikuli.core.search.ScoreFilter;

public class ColorImageTarget
extends ImageTarget {
    public ColorImageTarget(URL url) {
        super(url);
    }

    public ColorImageTarget(BufferedImage targetImage) {
        super(targetImage);
    }

    @Override
    protected double getDefaultMinScore() {
        return 0.9;
    }

    @Override
    protected List<ScreenRegion> getUnordredMatches(ScreenRegion screenRegion) {
        ImageSearcher searcher = new ImageSearcher(screenRegion.capture());
        ColorImageQuery query = new ColorImageQuery(this.targetImage);
        ScoreFilter filter = new ScoreFilter(this.getMinScore());
        List<RegionMatch> topMatches = searcher.search(query, filter, this.getLimit());
        return ColorImageTarget.convertToScreenRegions(screenRegion, topMatches);
    }
}

