/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox.util;

import edu.umd.cs.piccolox.util.MutablePoints;
import edu.umd.cs.piccolox.util.Points;
import edu.umd.cs.piccolox.util.XYArray;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class LineShape
implements Shape,
MutablePoints {
    private MutablePoints points;
    private final Rectangle2D bounds = new Rectangle2D.Double();

    public LineShape(MutablePoints points) {
        this.setPoints(points);
    }

    public void setPoints(MutablePoints points) {
        this.points = points == null ? new XYArray() : points;
    }

    public int getPointCount() {
        return this.points.getPointCount();
    }

    public double getX(int pointIndex) {
        return this.points.getX(pointIndex);
    }

    public double getY(int pointIndex) {
        return this.points.getY(pointIndex);
    }

    public Point2D getPoint(int pointIndex, Point2D destinationPoint) {
        return this.points.getPoint(pointIndex, destinationPoint);
    }

    public Rectangle2D getBounds(Rectangle2D dst) {
        this.points.getBounds(dst);
        return dst;
    }

    public void updateBounds() {
        this.bounds.setRect(0.0, 0.0, 0.0, 0.0);
        this.points.getBounds(this.bounds);
    }

    public void setPoint(int pointIndex, double x, double y) {
        this.points.setPoint(pointIndex, x, y);
        this.updateBounds();
    }

    public void addPoint(int pointIndex, double x, double y) {
        this.points.addPoint(pointIndex, x, y);
        this.updateBounds();
    }

    public void removePoints(int pointIndex, int num) {
        this.points.removePoints(pointIndex, num);
        this.updateBounds();
    }

    public void transformPoints(AffineTransform transform) {
        XYArray newPoints = new XYArray(this.points.getPointCount());
        newPoints.appendPoints(this.points);
        newPoints.transformPoints(transform);
        this.points = newPoints;
    }

    public Rectangle getBounds() {
        return new Rectangle((int)this.bounds.getX(), (int)this.bounds.getY(), (int)this.bounds.getWidth(), (int)this.bounds.getHeight());
    }

    public Rectangle2D getBounds2D() {
        return this.bounds;
    }

    public static boolean contains(double x, double y, double x1, double y1, double x2, double y2, boolean min, boolean max, double distance) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        if (dx == 0.0 && dy == 0.0) {
            return false;
        }
        double dx2 = dx * dx;
        double dy2 = dy * dy;
        double p = dx != 0.0 ? ((x - x1) / dx + dy * (y - y1) / dx2) / (1.0 + dy2 / dx2) : ((y - y1) / dy + dx * (x - x1) / dy2) / (1.0 + dx2 / dy2);
        if (min && p < 0.0 || max && p > 1.0) {
            return false;
        }
        double len = (dx = p * dx + x1 - x) * dx + (dy = p * dy + y1 - y) * dy;
        return len < distance;
    }

    public boolean contains(double x, double y, double d2) {
        if (this.points.getPointCount() == 0) {
            return false;
        }
        double x2 = this.points.getX(0);
        double y2 = this.points.getX(0);
        for (int i2 = 0; i2 < this.points.getPointCount(); ++i2) {
            double x1 = x2;
            double y1 = y2;
            if (!LineShape.contains(x, y, x1, y1, x2 = this.points.getX(i2), y2 = this.points.getX(i2), false, false, d2)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(double x, double y) {
        return this.contains(x, y, 2.0);
    }

    public boolean contains(Point2D p) {
        return this.contains(p.getX(), p.getY());
    }

    public static boolean intersects(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4, boolean min1, boolean max1, boolean min2, boolean max2) {
        double p1;
        double p2;
        double dx1 = x2 - x1;
        double dy1 = y2 - y1;
        double dx2 = x4 - x3;
        double dy2 = y4 - y3;
        if (dy1 != 0.0) {
            double d2 = dx1 / dy1;
            p2 = (x3 - x1 + d2 * (y1 - y3)) / (d2 * dy2 - dx2);
            p1 = (dy2 * p2 + y3 - y1) / dy1;
        } else if (dy2 != 0.0) {
            double d3 = dx2 / dy2;
            p1 = (x1 - x3 + d3 * (y3 - y1)) / (d3 * dy1 - dx1);
            p2 = (dy1 * p1 + y1 - y3) / dy2;
        } else if (dx1 != 0.0) {
            double d4 = dy1 / dx1;
            p2 = (y3 - y1 + d4 * (x1 - x3)) / (d4 * dx2 - dy2);
            p1 = (dx2 * p2 + x3 - x1) / dx1;
        } else if (dx2 != 0.0) {
            double d5 = dy2 / dx2;
            p1 = (y1 - y3 + d5 * (x3 - x1)) / (d5 * dx1 - dy1);
            p2 = (dx1 * p1 + x1 - x3) / dx2;
        } else {
            return false;
        }
        return !(min1 && !(p1 >= 0.0) || max1 && !(p1 <= 1.0) || min2 && !(p2 >= 0.0) || max2 && !(p2 <= 1.0));
    }

    public boolean intersects(double x, double y, double w, double h2) {
        if (this.points.getPointCount() == 0) {
            return false;
        }
        double x2 = this.points.getX(0);
        double y2 = this.points.getY(0);
        for (int i2 = 0; i2 < this.points.getPointCount(); ++i2) {
            double x1 = x2;
            double y1 = y2;
            if (!LineShape.intersects(x, y, x + w, y, x1, y1, x2 = this.points.getX(i2), y2 = this.points.getY(i2), true, true, true, true) && !LineShape.intersects(x + w, y, x + w, y + h2, x1, y1, x2, y2, true, true, true, true) && !LineShape.intersects(x + w, y + h2, x, y + h2, x1, y1, x2, y2, true, true, true, true) && !LineShape.intersects(x, y + h2, x, y, x1, y1, x2, y2, true, true, true, true)) continue;
            return true;
        }
        return false;
    }

    public boolean intersects(Rectangle2D r) {
        return this.intersects(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public boolean contains(double x, double y, double width, double height) {
        return this.contains(x, y) && this.contains(x + width, y) && this.contains(x, y + height) && this.contains(x + width, y + height);
    }

    public boolean contains(Rectangle2D r) {
        return this.contains(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public PathIterator getPathIterator(AffineTransform at) {
        return new LinePathIterator(this.points, at);
    }

    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return new LinePathIterator(this.points, at);
    }

    private static class LinePathIterator
    implements PathIterator {
        private final Points points;
        private final AffineTransform trans;
        private int i = 0;
        private final Point2D tempPoint = new Point2D.Double();

        public LinePathIterator(Points points, AffineTransform trans) {
            this.points = points;
            this.trans = trans;
        }

        public int getWindingRule() {
            return 0;
        }

        public boolean isDone() {
            return this.i >= this.points.getPointCount();
        }

        public void next() {
            ++this.i;
        }

        private void currentSegment() {
            this.tempPoint.setLocation(this.points.getX(this.i), this.points.getY(this.i));
            if (this.trans != null) {
                this.trans.transform(this.tempPoint, this.tempPoint);
            }
        }

        public int currentSegment(float[] coords) {
            this.currentSegment();
            coords[0] = (float)this.tempPoint.getX();
            coords[1] = (float)this.tempPoint.getY();
            if (this.i == 0) {
                return 0;
            }
            return 1;
        }

        public int currentSegment(double[] coords) {
            this.currentSegment();
            coords[0] = this.tempPoint.getX();
            coords[1] = this.tempPoint.getY();
            if (this.i == 0) {
                return 0;
            }
            return 1;
        }
    }
}

